/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime.models;

public class GangExpectedTime
implements Comparable<GangExpectedTime> {
    private static final long STALE_THRESHOLD = 300000L;
    private long timeRead;
    private long initialMinutesUntilAppearance;

    public GangExpectedTime(long timeRead, int initialMinutesUntilAppearance) {
        this.timeRead = timeRead;
        this.initialMinutesUntilAppearance = initialMinutesUntilAppearance;
    }

    public boolean isStale() {
        return (float)this.getTimeUntilExpectedAppearance().longValue() * -1.0f > 300000.0f;
    }

    public String toString() {
        long deltaTimeMinutes = this.getTimeUntilExpectedAppearance() / 1000L / 60L;
        if (deltaTimeMinutes == 0L) {
            return "Now";
        }
        if (deltaTimeMinutes > 0L) {
            return String.format("~%s mins", deltaTimeMinutes + 1L);
        }
        long minutesSinceAppearance = deltaTimeMinutes * -1L + 1L;
        return String.format("~%s mins ago", minutesSinceAppearance);
    }

    @Override
    public int compareTo(GangExpectedTime other) {
        return (int)(this.getExpectedAppearanceTime() - other.getExpectedAppearanceTime());
    }

    private Long getExpectedAppearanceTime() {
        return this.timeRead + this.initialMinutesUntilAppearance * 60L * 1000L;
    }

    private Long getTimeUntilExpectedAppearance() {
        return this.getExpectedAppearanceTime() - System.currentTimeMillis();
    }
}

