/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime;

import com.dylange.organisedcrime.config.OrganisedCrimeConfig;
import com.dylange.organisedcrime.models.GangInfo;
import com.dylange.organisedcrime.tools.InformationBoardTextReader;
import com.dylange.organisedcrime.tools.ViewStateMapper;
import com.dylange.organisedcrime.ui.LocationViewState;
import com.dylange.organisedcrime.ui.OrganisedCrimePanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Organised crime", description="Keeps track of organised crime locations across worlds", enabledByDefault=false)
public class OrganisedCrimePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OrganisedCrimePlugin.class);
    private static final int PANEL_REFRESH_TICK_THRESHOLD = 50;
    private static final int STALE_DATA_REFRESH_TICK_THRESHOLD = 50;
    private NavigationButton navButton;
    private OrganisedCrimePanel panel;
    private int ticksSinceLastUiUpdate = 0;
    private int ticksSinceLastStaleDataCull = 0;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private static final Logger logger = LoggerFactory.getLogger(OrganisedCrimePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldService worldService;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OrganisedCrimeConfig config;
    public Map<Integer, GangInfo> gangInfoMap = new HashMap<Integer, GangInfo>();

    @Provides
    OrganisedCrimeConfig provideOrganisedCrimeConfig(ConfigManager configManager) {
        return (OrganisedCrimeConfig)configManager.getConfig(OrganisedCrimeConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = new OrganisedCrimePanel(this.config, this::worldClicked);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("Organised Crime").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.updatePanelData(this.gangInfoMap);
    }

    protected void shutDown() throws Exception {
        this.gangInfoMap.clear();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void worldClicked(int world) {
        this.hop(world);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (++this.ticksSinceLastUiUpdate >= 50) {
            this.refreshPanel();
        }
        if (++this.ticksSinceLastStaleDataCull >= 50 && !this.gangInfoMap.isEmpty()) {
            this.clearStaleGangInfo();
        }
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.displaySwitcherAttempts = 0;
                this.quickHopTargetWorld = null;
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.displaySwitcherAttempts = 0;
            this.quickHopTargetWorld = null;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("organised-crime")) {
            this.updatePanelData(this.gangInfoMap);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 229) {
            this.gangInfoMap.keySet().forEach(world -> logger.debug("Worlds before: " + world));
            logger.debug("Removing world " + this.client.getWorld() + " from list.");
            this.gangInfoMap.remove(this.client.getWorld());
            this.gangInfoMap.keySet().forEach(world -> logger.debug("Worlds after: " + world));
            this.updatePanelData(this.gangInfoMap);
            return;
        }
        if (widgetLoaded.getGroupId() != 291) {
            return;
        }
        try {
            GangInfo gangInfo = InformationBoardTextReader.getDisplayedGangInfo(this.client);
            if (gangInfo != null) {
                this.gangInfoMap.put(gangInfo.getWorld(), gangInfo);
                this.updatePanelData(this.gangInfoMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.refreshPanel();
            this.clearStaleGangInfo();
        }
    }

    private void clearStaleGangInfo() {
        HashMap<Integer, GangInfo> gangInfoCopy = new HashMap<Integer, GangInfo>();
        AtomicBoolean removedAnyStaleValue = new AtomicBoolean(false);
        this.gangInfoMap.forEach((world, gangInfo) -> {
            if (!gangInfo.getExpectedTime().isStale()) {
                gangInfoCopy.put((Integer)world, (GangInfo)gangInfo);
            } else {
                removedAnyStaleValue.set(true);
            }
        });
        this.ticksSinceLastStaleDataCull = 0;
        if (removedAnyStaleValue.get()) {
            this.gangInfoMap = gangInfoCopy;
            this.updatePanelData(this.gangInfoMap);
        }
    }

    private void refreshPanel() {
        this.ticksSinceLastUiUpdate = 0;
        this.panel.refresh();
    }

    private void updatePanelData(Map<Integer, GangInfo> data) {
        List<LocationViewState> listItems = ViewStateMapper.gangInfoMapToLocationListItems(data, this.config);
        SwingUtilities.invokeLater(() -> {
            if (listItems.isEmpty()) {
                this.panel.displayEmpty();
            } else {
                this.panel.display(listItems);
            }
        });
    }

    private void hop(int worldId) {
        WorldResult worldResult = this.worldService.getWorlds();
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }
}

