/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.resourceareanotifier;

import com.ywcode.resourceareanotifier.ResourceAreaNotifierPlugin;
import com.ywcode.resourceareanotifier.Sound;
import com.ywcode.resourceareanotifier.SoundFileManager;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    private boolean loadClip(Sound sound) {
        block15: {
            BufferedInputStream stream = new BufferedInputStream(SoundFileManager.getSoundStream(sound));
            try {
                try (AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(stream);){
                    this.clip.open(audioInputStream2);
                }
                boolean audioInputStream2 = true;
            }
            catch (Throwable audioInputStream2) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable) {
                        audioInputStream2.addSuppressed(throwable);
                    }
                    throw audioInputStream2;
                }
                catch (UnsupportedAudioFileException e) {
                    Toolkit.getDefaultToolkit().beep();
                    log.warn("Failed to load Resource Area Notifier sound " + sound + ". Use 16-bit .wav files (not 32-bit) if trying to use custom files. Attempting to delete and re-download the file now.", (Throwable)e);
                    File toDelete = new File(SoundFileManager.getDOWNLOAD_DIR(), sound.getResourceName());
                    toDelete.delete();
                    this.executor.submit(() -> {
                        SoundFileManager.ensureDownloadDirectoryExists();
                        SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
                    });
                    break block15;
                }
                catch (IOException | LineUnavailableException e) {
                    Toolkit.getDefaultToolkit().beep();
                    log.warn("Failed to load Resource Area Notifier sound " + sound, (Throwable)e);
                }
            }
            ((InputStream)stream).close();
            return audioInputStream2;
        }
        return false;
    }

    public void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                Toolkit.getDefaultToolkit().beep();
                log.warn("Failed to get clip for Resource Area Notifier sound " + sound, (Throwable)e);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)ResourceAreaNotifierPlugin.getNotificationSoundVolume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.loop(0);
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
    }
}

