/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.resourceareanotifier;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.ywcode.resourceareanotifier.BoxNotificationOverlay;
import com.ywcode.resourceareanotifier.NotificationOverlay;
import com.ywcode.resourceareanotifier.ResourceAreaNotifierConfig;
import com.ywcode.resourceareanotifier.ScreenNotificationOverlay;
import com.ywcode.resourceareanotifier.Sound;
import com.ywcode.resourceareanotifier.SoundEngine;
import com.ywcode.resourceareanotifier.SoundFileManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Resource Area Notifier", description="Notifies when the gate in the wilderness Resource Area opens.", tags={"crabs,dark crab,crab,dark crab gang,darkcrabgang,dcg,wilderness,resource,area,crab pen,piles,gate,notifier,notification"})
public class ResourceAreaNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ResourceAreaNotifierPlugin.class);
    private static boolean notifyOnGateOpen;
    private static NotificationOverlay notificationOverlay;
    private static Color solidFlashColor;
    private static Color boxColorPrimary;
    private static Color boxColorSecondary;
    private static int boxHeight;
    private static int boxWidth;
    private static int minimumNotificationOverlayDuration;
    private static int maximumNotificationOverlayDuration;
    private static boolean removeOverlayInteracting;
    private static boolean removeOverlayIgnore;
    private static Sound notificationSound;
    private static int notificationSoundVolume;
    private static boolean ignoreVeryClose;
    private static boolean ignoreClose;
    private static boolean ignoreFriends;
    private static boolean ignoreFCMembers;
    private static boolean ignoreCCMembers;
    private static final List<String> playersToIgnore;
    private static final int gateOpenFloorId = 38848;
    private static final WorldPoint gateOpenFloorWorldPoint;
    private static final WorldPoint outsideGateWorldPoint;
    private static final int resourceAreaX1 = 3174;
    private static final int resourceAreaX2 = 3196;
    private static final int resourceAreaY1 = 3924;
    private static final int resourceAreaY2 = 3944;
    private static final int resourceAreaY2Plus3 = 3947;
    private static final int gateTilesVisibleY = 3930;
    private static final int gateVeryCloseY = 3939;
    private static final WorldArea resourceAreaYPlus3WorldArea;
    private static final WorldArea resourceAreaPlayerSpawnedWorldArea;
    private static final List<Player> currentTickOutsidePlayers;
    private static final List<Player> currentTickInsidePlayers;
    private static final List<Player> previousTickOutsidePlayers;
    private static final List<Player> previousTickInsidePlayers;
    private static boolean listsEmpty;
    private static boolean gateOpenedThisTick;
    private static boolean overlayActive;
    private static int overlayActiveTime;
    private static boolean forceOverlayRemovalAfterMinDuration;
    private static int gateOpenedAmount;
    private static long nanoOverlayStart;
    private static boolean localPlayerIsInResourceAreaAndYPlus3;
    @Inject
    private Client client;
    @Inject
    private ResourceAreaNotifierConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BoxNotificationOverlay boxNotificationOverlay;
    @Inject
    private ScreenNotificationOverlay screenNotificationOverlay;
    @Inject
    private ConfigManager configManager;

    public void startUp() throws Exception {
        this.updateConfig(true);
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    public void shutDown() throws Exception {
        this.clearCacheLists();
        this.soundEngine.close();
        this.removeNotificationOverlays();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("ResourceAreaNotifier")) {
            this.updateConfig(false);
            String configKey = configChanged.getKey();
            if (configKey.equals("playersToIgnore")) {
                this.convertCommaSeparatedConfigStringToList(this.config.playersToIgnore(), playersToIgnore);
            }
            if (this.client.getGameState() != GameState.STARTING && this.client.getGameState() != GameState.UNKNOWN) {
                switch (configKey) {
                    case "notificationOverlay": 
                    case "solidFlashColor": 
                    case "boxColorPrimary": 
                    case "boxColorSecondary": 
                    case "boxHeight": 
                    case "boxWidth": {
                        this.removeNotificationOverlays();
                        this.addNotificationOverlays();
                        break;
                    }
                    case "notificationSound": {
                        this.playNotificationSound();
                    }
                }
            }
        }
    }

    private void updateConfig(boolean updateList) {
        notifyOnGateOpen = this.config.notifyOnGateOpen();
        notificationOverlay = this.config.notificationOverlay();
        solidFlashColor = this.config.solidFlashColor();
        boxColorPrimary = this.config.boxColorPrimary();
        boxColorSecondary = this.config.boxColorSecondary();
        boxHeight = this.config.boxHeight();
        boxWidth = this.config.boxWidth();
        minimumNotificationOverlayDuration = this.config.minimumNotificationOverlayDuration();
        maximumNotificationOverlayDuration = this.config.maximumNotificationOverlayDuration();
        removeOverlayInteracting = this.config.removeOverlayInteracting();
        removeOverlayIgnore = this.config.removeOverlayIgnore();
        notificationSound = this.config.notificationSound();
        notificationSoundVolume = this.config.notificationSoundVolume();
        ignoreVeryClose = this.config.ignoreVeryClose();
        ignoreClose = this.config.ignoreClose();
        ignoreFriends = this.config.ignoreFriends();
        ignoreFCMembers = this.config.ignoreFCMembers();
        ignoreCCMembers = this.config.ignoreCCMembers();
        if (updateList) {
            this.convertCommaSeparatedConfigStringToList(this.config.playersToIgnore(), playersToIgnore);
        }
        if (maximumNotificationOverlayDuration < minimumNotificationOverlayDuration) {
            maximumNotificationOverlayDuration = minimumNotificationOverlayDuration;
            this.configManager.setConfiguration("ResourceAreaNotifier", "maximumNotificationOverlayDuration", (Object)minimumNotificationOverlayDuration);
        }
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged profileChanged) {
        this.removeNotificationOverlays();
        this.updateConfig(true);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.HOPPING || gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.removeNotificationOverlays();
        }
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned wallObjectSpawned) {
        if (localPlayerIsInResourceAreaAndYPlus3 && wallObjectSpawned.getWallObject().getId() == 38848 && wallObjectSpawned.getTile().getWorldLocation().equals((Object)gateOpenFloorWorldPoint)) {
            gateOpenedThisTick = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        localPlayerIsInResourceAreaAndYPlus3 = this.isInResourceAreaAndYPlus3();
        if (localPlayerIsInResourceAreaAndYPlus3) {
            int localPlayerY = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getY();
            if (localPlayerY < 3930) {
                this.clearCacheLists();
            } else {
                this.cachePlayers();
            }
            if (gateOpenedThisTick) {
                this.notifyGateOpened();
            }
        } else if (!listsEmpty) {
            this.clearCacheLists();
        }
        this.conditionalRemoveOverlay();
        gateOpenedThisTick = false;
        this.increaseOverlayTimer();
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        if (localPlayerIsInResourceAreaAndYPlus3 && gateOpenedAmount > 0) {
            Player spawnedPlayer = playerSpawned.getPlayer();
            String spawnedPlayerUsername = spawnedPlayer.getName();
            if ((ignoreFriends && spawnedPlayer.isFriend() || ignoreFCMembers && spawnedPlayer.isFriendsChatMember() || ignoreCCMembers && spawnedPlayer.isClanMember() || spawnedPlayerUsername != null && playersToIgnore.contains(Text.standardize((String)spawnedPlayerUsername))) && resourceAreaPlayerSpawnedWorldArea.contains(spawnedPlayer.getWorldLocation())) {
                --gateOpenedAmount;
            }
        }
    }

    private void clearCacheLists() {
        currentTickInsidePlayers.clear();
        previousTickInsidePlayers.clear();
        currentTickOutsidePlayers.clear();
        previousTickOutsidePlayers.clear();
        listsEmpty = true;
    }

    private void removeNotificationOverlays() {
        this.overlayManager.remove((Overlay)this.boxNotificationOverlay);
        this.overlayManager.remove((Overlay)this.screenNotificationOverlay);
        gateOpenedAmount = 0;
        overlayActive = false;
        overlayActiveTime = 0;
        forceOverlayRemovalAfterMinDuration = false;
        nanoOverlayStart = 0L;
    }

    private void convertCommaSeparatedConfigStringToList(String configString, List<String> listToConvertTo) {
        listToConvertTo.clear();
        listToConvertTo.addAll(Text.fromCSV((String)Text.standardize((String)configString)));
    }

    private void addNotificationOverlays() {
        if (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.LOADING) {
            if (!overlayActive) {
                switch (notificationOverlay) {
                    case Disabled: {
                        return;
                    }
                    case BoxSolid: 
                    case BoxFlash: {
                        this.overlayManager.add((Overlay)this.boxNotificationOverlay);
                        break;
                    }
                    case Solid: 
                    case Flash: {
                        this.overlayManager.add((Overlay)this.screenNotificationOverlay);
                    }
                }
                overlayActive = true;
            }
            overlayActiveTime = 0;
            forceOverlayRemovalAfterMinDuration = false;
            nanoOverlayStart = System.nanoTime();
        }
    }

    private void playNotificationSound() {
        if (notificationSound == Sound.DISABLED) {
            return;
        }
        this.executor.submit(() -> this.soundEngine.playClip(notificationSound));
    }

    private boolean isInResourceAreaAndYPlus3() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        WorldPoint playerWorldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation());
        return resourceAreaYPlus3WorldArea.contains(playerWorldPoint);
    }

    private void cachePlayers() {
        listsEmpty = false;
        this.updateLists(previousTickOutsidePlayers, currentTickOutsidePlayers);
        this.updateLists(previousTickInsidePlayers, currentTickInsidePlayers);
        List players = this.client.getPlayers();
        for (Player player : players) {
            WorldPoint playerWorldPoint = player.getWorldLocation();
            if (playerWorldPoint.equals((Object)gateOpenFloorWorldPoint)) {
                currentTickInsidePlayers.add(player);
                continue;
            }
            if (!playerWorldPoint.equals((Object)outsideGateWorldPoint)) continue;
            currentTickOutsidePlayers.add(player);
        }
    }

    private void updateLists(List<Player> listToCopyTo, List<Player> listToCopyFrom) {
        listToCopyTo.clear();
        listToCopyTo.addAll(listToCopyFrom);
        listToCopyFrom.clear();
    }

    private void notifyGateOpened() {
        if (this.shouldNotify()) {
            ++gateOpenedAmount;
            if (notifyOnGateOpen) {
                this.notifier.notify("Wilderness Resource Area gate opened!");
            }
            this.addNotificationOverlays();
            this.playNotificationSound();
        }
    }

    private boolean shouldNotify() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        int localPlayerY = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getY();
        if (localPlayerY < 3930) {
            return true;
        }
        if (ignoreClose || ignoreVeryClose && localPlayerY >= 3939) {
            return false;
        }
        Player gatingPlayer = this.getPlayerThatGated();
        if (gatingPlayer == null) {
            return true;
        }
        if (gatingPlayer == player || ignoreFriends && gatingPlayer.isFriend() || ignoreFCMembers && gatingPlayer.isFriendsChatMember() || ignoreCCMembers && gatingPlayer.isClanMember()) {
            return false;
        }
        String gatingPlayerUsername = gatingPlayer.getName();
        if (gatingPlayerUsername != null && playersToIgnore.contains(Text.standardize((String)gatingPlayerUsername))) {
            return false;
        }
        return this.getIfPlayerEntered(gatingPlayer);
    }

    @Nullable
    private Player getPlayerThatGated() {
        if (this.getPlayerEnteredOrLeft(previousTickOutsidePlayers, currentTickInsidePlayers) != null) {
            return this.getPlayerEnteredOrLeft(previousTickOutsidePlayers, currentTickInsidePlayers);
        }
        if (this.getPlayerEnteredOrLeft(previousTickInsidePlayers, currentTickOutsidePlayers) != null) {
            return this.getPlayerEnteredOrLeft(previousTickInsidePlayers, currentTickOutsidePlayers);
        }
        return null;
    }

    @Nullable
    private Player getPlayerEnteredOrLeft(List<Player> previousTick, List<Player> currentTickOpposite) {
        for (Player player : previousTick) {
            if (!currentTickOpposite.contains(player)) continue;
            return player;
        }
        return null;
    }

    private boolean getIfPlayerEntered(Player player) {
        return !player.getWorldLocation().equals((Object)outsideGateWorldPoint);
    }

    private void conditionalRemoveOverlay() {
        if (overlayActive) {
            if (overlayActiveTime >= maximumNotificationOverlayDuration) {
                this.removeNotificationOverlays();
                return;
            }
            if (removeOverlayIgnore && gateOpenedAmount == 0 && this.isInResourceAreaAndYPlus3()) {
                forceOverlayRemovalAfterMinDuration = true;
            }
            long mouseIdleNanoTime = (long)this.client.getMouseIdleTicks() * 20L * 1000000L;
            long keyboardIdleNanoTime = (long)this.client.getKeyboardIdleTicks() * 20L * 1000000L;
            long currentNanoTime = System.nanoTime();
            if (removeOverlayInteracting && (nanoOverlayStart + mouseIdleNanoTime < currentNanoTime || nanoOverlayStart + keyboardIdleNanoTime < currentNanoTime)) {
                forceOverlayRemovalAfterMinDuration = true;
            }
            if (forceOverlayRemovalAfterMinDuration && overlayActiveTime >= minimumNotificationOverlayDuration) {
                this.removeNotificationOverlays();
            }
        }
    }

    private void increaseOverlayTimer() {
        if (overlayActive) {
            ++overlayActiveTime;
        }
    }

    @Provides
    ResourceAreaNotifierConfig provideConfig(ConfigManager configManager) {
        return (ResourceAreaNotifierConfig)configManager.getConfig(ResourceAreaNotifierConfig.class);
    }

    public static NotificationOverlay getNotificationOverlay() {
        return notificationOverlay;
    }

    public static Color getSolidFlashColor() {
        return solidFlashColor;
    }

    public static Color getBoxColorPrimary() {
        return boxColorPrimary;
    }

    public static Color getBoxColorSecondary() {
        return boxColorSecondary;
    }

    public static int getBoxHeight() {
        return boxHeight;
    }

    public static int getBoxWidth() {
        return boxWidth;
    }

    public static int getNotificationSoundVolume() {
        return notificationSoundVolume;
    }

    static {
        playersToIgnore = new ArrayList<String>();
        gateOpenFloorWorldPoint = new WorldPoint(3184, 3944, 0);
        outsideGateWorldPoint = new WorldPoint(3184, 3945, 0);
        resourceAreaYPlus3WorldArea = new WorldArea(3174, 3924, 23, 24, 0);
        resourceAreaPlayerSpawnedWorldArea = new WorldArea(3174, 3930, 23, 15, 0);
        currentTickOutsidePlayers = new ArrayList<Player>();
        currentTickInsidePlayers = new ArrayList<Player>();
        previousTickOutsidePlayers = new ArrayList<Player>();
        previousTickInsidePlayers = new ArrayList<Player>();
        listsEmpty = true;
    }
}

