/*
 * Decompiled with CFR 0.152.
 */
package com.clanevents;

import com.clanevents.GoogleSheet;
import com.clanevents.SheetValueRange;
import com.clanevents.State;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.swing.event.SwingPropertyChangeSupport;

public class Service {
    SwingPropertyChangeSupport propChangeFirer;
    Optional<List<List<Object>>> apiValues = Optional.empty();
    List<SheetValueRange> sheetValueRangeList = new ArrayList<SheetValueRange>();
    State state = State.IDLE;

    public Service() {
        this.propChangeFirer = new SwingPropertyChangeSupport(this);
    }

    public void addListener(PropertyChangeListener prop) {
        this.propChangeFirer.addPropertyChangeListener(prop);
    }

    public void setState(State newState) {
        State oldVal = this.state;
        this.state = newState;
        this.propChangeFirer.firePropertyChange("state", (Object)oldVal, (Object)newState);
    }

    public void refreshData() {
        this.setState(State.LOADING);
        CompletableFuture.supplyAsync(() -> {
            try {
                List<SheetValueRange> googleValues = GoogleSheet.getValues();
                this.setSheetValueRangeList(googleValues);
            }
            catch (Exception e) {
                e.printStackTrace();
                return State.ERROR;
            }
            return State.COMPLETED;
        }).handle((r, v) -> {
            this.setState((State)((Object)r));
            return null;
        });
    }

    public Optional<List<List<Object>>> getSheet(String header) {
        return this.sheetValueRangeList.stream().filter(s -> s.getSheet().equals(header)).findFirst().map(m -> m.getValueRange().getValues());
    }

    public SwingPropertyChangeSupport getPropChangeFirer() {
        return this.propChangeFirer;
    }

    public Optional<List<List<Object>>> getApiValues() {
        return this.apiValues;
    }

    public List<SheetValueRange> getSheetValueRangeList() {
        return this.sheetValueRangeList;
    }

    public State getState() {
        return this.state;
    }

    public void setPropChangeFirer(SwingPropertyChangeSupport propChangeFirer) {
        this.propChangeFirer = propChangeFirer;
    }

    public void setApiValues(Optional<List<List<Object>>> apiValues) {
        this.apiValues = apiValues;
    }

    public void setSheetValueRangeList(List<SheetValueRange> sheetValueRangeList) {
        this.sheetValueRangeList = sheetValueRangeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service other = (Service)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SwingPropertyChangeSupport this$propChangeFirer = this.getPropChangeFirer();
        SwingPropertyChangeSupport other$propChangeFirer = other.getPropChangeFirer();
        if (this$propChangeFirer == null ? other$propChangeFirer != null : !this$propChangeFirer.equals(other$propChangeFirer)) {
            return false;
        }
        Optional<List<List<Object>>> this$apiValues = this.getApiValues();
        Optional<List<List<Object>>> other$apiValues = other.getApiValues();
        if (this$apiValues == null ? other$apiValues != null : !((Object)this$apiValues).equals(other$apiValues)) {
            return false;
        }
        List<SheetValueRange> this$sheetValueRangeList = this.getSheetValueRangeList();
        List<SheetValueRange> other$sheetValueRangeList = other.getSheetValueRangeList();
        if (this$sheetValueRangeList == null ? other$sheetValueRangeList != null : !((Object)this$sheetValueRangeList).equals(other$sheetValueRangeList)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Service;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SwingPropertyChangeSupport $propChangeFirer = this.getPropChangeFirer();
        result = result * 59 + ($propChangeFirer == null ? 43 : $propChangeFirer.hashCode());
        Optional<List<List<Object>>> $apiValues = this.getApiValues();
        result = result * 59 + ($apiValues == null ? 43 : ((Object)$apiValues).hashCode());
        List<SheetValueRange> $sheetValueRangeList = this.getSheetValueRangeList();
        result = result * 59 + ($sheetValueRangeList == null ? 43 : ((Object)$sheetValueRangeList).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "Service(propChangeFirer=" + this.getPropChangeFirer() + ", apiValues=" + this.getApiValues() + ", sheetValueRangeList=" + this.getSheetValueRangeList() + ", state=" + this.getState() + ")";
    }
}

