/*
 * Decompiled with CFR 0.152.
 */
package com.clanevents;

import com.clanevents.ClanEventsConfig;
import com.clanevents.ClanEventsOverlay;
import com.clanevents.ClanEventsPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Events", description="A plugin used to keep track of clan events.", tags={"ely", "elysium", "cc", "hunt", "pass", "event", "clan"})
public class ClanEventsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanEventsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClanEventsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClanEventsOverlay overlay;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ClientToolbar clientToolbar;
    private ClanEventsPanel panel;
    private NavigationButton uiNavigationButton;
    static final String CONFIG_GROUP = "clanevents";

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.startClanPanel();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.panel.removeAll();
            this.panel.init(this.config);
            if (!this.config.sheetId().equals("") && !this.config.apiKey().equals("")) {
                this.clientToolbar.addNavigation(this.uiNavigationButton);
            } else {
                this.clientToolbar.removeNavigation(this.uiNavigationButton);
            }
        }
    }

    private void startClanPanel() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.panel = (ClanEventsPanel)this.injector.getInstance(ClanEventsPanel.class);
        this.panel.init(this.config);
        this.uiNavigationButton = NavigationButton.builder().tooltip("Clan Events").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        if (!this.config.sheetId().equals("") && !this.config.apiKey().equals("")) {
            this.clientToolbar.addNavigation(this.uiNavigationButton);
        }
    }

    @Provides
    ClanEventsConfig provideConfig(ConfigManager configManager) {
        return (ClanEventsConfig)configManager.getConfig(ClanEventsConfig.class);
    }
}

