/*
 * Decompiled with CFR 0.152.
 */
package com.clanevents;

import com.clanevents.ClanEventsConfig;
import com.clanevents.ColumnCellRenderer;
import com.clanevents.GoogleSheet;
import com.clanevents.KeyName;
import com.clanevents.Service;
import com.clanevents.State;
import com.clanevents.components.combobox.ComboBoxIconEntry;
import com.clanevents.components.combobox.ComboBoxIconListRenderer;
import com.clanevents.constants.EntrySelect;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClanEventsPanel
extends PluginPanel
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ClanEventsPanel.class);
    private final JButton buttonArea = this.createRefreshButton();
    private final JPanel ssArea = new JPanel();
    private final Service service = new Service();
    private final GoogleSheet sheet = new GoogleSheet();
    private Boolean openedTab = false;
    final JComboBox<ComboBoxIconEntry> dropdown = new JComboBox();
    final ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
    private final ActionListener timertask = event -> {
        if (!this.openedTab.booleanValue()) {
            this.service.refreshData();
        } else {
            this.openedTab = false;
        }
    };
    private final Timer timer = new Timer(0, this.timertask);

    ClanEventsPanel() {
    }

    public void init(ClanEventsConfig config) {
        if (config.apiKey().equals("") || config.sheetId().equals("")) {
            JTextArea text = new JTextArea();
            text.append("Enter a valid Google Sheet ID \nor API Key in the config.");
            this.add(text);
            return;
        }
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        if (config.autoRefresh()) {
            this.timer.setRepeats(true);
            this.timer.setDelay(config.refreshPeriod() * 1000 * 60);
        } else {
            this.timer.setRepeats(false);
        }
        this.getScrollPane().setEnabled(false);
        this.setFocusTraversalKeysEnabled(false);
        this.getParent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ClanEventsPanel.this.requestFocus();
            }
        });
        this.sheet.setKey(config.apiKey());
        this.sheet.setSheetId(config.sheetId());
        this.dropdown.setFocusable(false);
        this.dropdown.setForeground(Color.WHITE);
        this.dropdown.setRenderer(this.renderer);
        if (this.dropdown.getItemListeners().length > 0) {
            this.dropdown.removeItemListener(this.dropdown.getItemListeners()[0]);
        }
        this.dropdown.removeAllItems();
        this.setEntry(config.entry_1());
        this.setEntry(config.entry_2());
        this.setEntry(config.entry_3());
        this.setEntry(config.entry_4());
        this.setEntry(config.entry_5());
        this.setEntry(config.entry_6());
        this.setEntry(config.entry_7());
        this.dropdown.setSelectedIndex(0);
        this.dropdown.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.drawDataPanel();
            }
        });
        this.add(this.dropdown);
        this.add(this.buttonArea, "North");
        im.put(KeyStroke.getKeyStroke(49, 0), (Object)KeyName.KN_1);
        im.put(KeyStroke.getKeyStroke(97, 0), (Object)KeyName.KN_1);
        im.put(KeyStroke.getKeyStroke(50, 0), (Object)KeyName.KN_2);
        im.put(KeyStroke.getKeyStroke(98, 0), (Object)KeyName.KN_2);
        im.put(KeyStroke.getKeyStroke(51, 0), (Object)KeyName.KN_3);
        im.put(KeyStroke.getKeyStroke(99, 0), (Object)KeyName.KN_3);
        im.put(KeyStroke.getKeyStroke(52, 0), (Object)KeyName.KN_4);
        im.put(KeyStroke.getKeyStroke(100, 0), (Object)KeyName.KN_4);
        im.put(KeyStroke.getKeyStroke(53, 0), (Object)KeyName.KN_5);
        im.put(KeyStroke.getKeyStroke(101, 0), (Object)KeyName.KN_5);
        im.put(KeyStroke.getKeyStroke(54, 0), (Object)KeyName.KN_6);
        im.put(KeyStroke.getKeyStroke(102, 0), (Object)KeyName.KN_6);
        im.put(KeyStroke.getKeyStroke(55, 0), (Object)KeyName.KN_7);
        im.put(KeyStroke.getKeyStroke(103, 0), (Object)KeyName.KN_7);
        im.put(KeyStroke.getKeyStroke(38, 0), (Object)KeyName.KN_UP);
        im.put(KeyStroke.getKeyStroke(224, 0), (Object)KeyName.KN_UP);
        im.put(KeyStroke.getKeyStroke(40, 0), (Object)KeyName.KN_DOWN);
        im.put(KeyStroke.getKeyStroke(225, 0), (Object)KeyName.KN_DOWN);
        im.put(KeyStroke.getKeyStroke(config.entryKeybind().getKeyCode(), 0), (Object)KeyName.KN_KEYBIND);
        am.put((Object)KeyName.KN_1, new KeyAction(KeyName.KN_1, config));
        am.put((Object)KeyName.KN_2, new KeyAction(KeyName.KN_2, config));
        am.put((Object)KeyName.KN_3, new KeyAction(KeyName.KN_3, config));
        am.put((Object)KeyName.KN_4, new KeyAction(KeyName.KN_4, config));
        am.put((Object)KeyName.KN_5, new KeyAction(KeyName.KN_5, config));
        am.put((Object)KeyName.KN_6, new KeyAction(KeyName.KN_6, config));
        am.put((Object)KeyName.KN_7, new KeyAction(KeyName.KN_7, config));
        am.put((Object)KeyName.KN_UP, new KeyAction(KeyName.KN_UP, config));
        am.put((Object)KeyName.KN_DOWN, new KeyAction(KeyName.KN_DOWN, config));
        am.put((Object)KeyName.KN_KEYBIND, new KeyAction(KeyName.KN_KEYBIND, config));
        this.ssArea.setLayout(new BoxLayout(this.ssArea, 1));
        this.add(this.ssArea, "North");
        this.service.addListener(this);
        if (this.service.state.equals((Object)State.IDLE)) {
            this.service.refreshData();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("state") && evt.getNewValue() != evt.getOldValue()) {
            State currentState = (State)((Object)evt.getNewValue());
            this.updateButtonAsync(currentState);
            if (Objects.requireNonNull(currentState) == State.COMPLETED) {
                this.drawDataPanel();
            } else if (Objects.requireNonNull(currentState) == State.ERROR) {
                this.updateButtonAsync(State.ERROR);
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.updateButtonAsync(State.COMPLETED);
            }
        }
    }

    private void drawDataPanel() {
        Optional.ofNullable((ComboBoxIconEntry)this.dropdown.getSelectedItem()).flatMap(ComboBoxIconEntry::getData).ifPresent(this::updateUiAfterAPI);
    }

    public void setEntry(EntrySelect entry) {
        switch (entry) {
            case HOME: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"home.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Home", Optional.of("home")));
                break;
            }
            case HUB: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"hub.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Clan Hub", Optional.of("hub")));
                break;
            }
            case SOTW: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"sotw.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Skill of the Week", Optional.of("sotw")));
                break;
            }
            case BOTW: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"botw.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Boss of the Week", Optional.of("botw")));
                break;
            }
            case HOF_OVERALL: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"hof.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Hall of Fame - Overall", Optional.of("hof_overall")));
                break;
            }
            case HOF_KC: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"hof.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Hall of Fame - KC", Optional.of("hof_kc")));
                break;
            }
            case HOF_PB: {
                BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"hof.png");
                this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Hall of Fame - PB", Optional.of("hof_pb")));
            }
        }
    }

    private JButton createRefreshButton() {
        JButton button = new JButton("Refresh");
        button.setFocusable(false);
        button.addActionListener(e -> {
            if (this.service.state != State.LOADING) {
                this.service.refreshData();
            }
        });
        return button;
    }

    private void updateButtonAsync(State state) {
        SwingUtilities.invokeLater(() -> {
            this.buttonArea.setVisible(false);
            switch (state) {
                case LOADING: {
                    this.buttonArea.setEnabled(false);
                    this.buttonArea.setText("Loading data...");
                    break;
                }
                case ERROR: {
                    this.buttonArea.setEnabled(false);
                    this.buttonArea.setText("<html><center><font color = red>Error fetching data!<br>Please wait a minute before trying again.</font></center></html>");
                    break;
                }
                default: {
                    this.buttonArea.setEnabled(true);
                    this.buttonArea.setText("Refresh");
                }
            }
            this.buttonArea.revalidate();
            this.buttonArea.repaint();
            this.buttonArea.setVisible(true);
        });
    }

    private static void createLinkEvent(JButton button, String url) {
        final String link = url;
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getButton() == 1) {
                    try {
                        URI myURI = new URI(link);
                        ClanEventsPanel.openWebpage(myURI);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createHideEvent(JButton button) {
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                block5: {
                    if (event.getButton() != 1) break block5;
                    try {
                        for (int i = 0; i < ClanEventsPanel.this.ssArea.getComponentCount(); ++i) {
                            Container c;
                            if (ClanEventsPanel.this.ssArea.getComponent(i) != event.getComponent().getParent() || (c = (Container)ClanEventsPanel.this.ssArea.getComponent(i + 1)).getComponent(0).getClass().isAssignableFrom(JButton.class)) continue;
                            c.setVisible(!c.isVisible());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void addTableMouseEvents(final JTable table) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Point p = e.getPoint();
                int row = table.rowAtPoint(p);
                int col = table.columnAtPoint(p);
                Object tooltip = table.getValueAt(row, col);
                table.setToolTipText(tooltip == null ? " " : tooltip.toString());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                table.setToolTipText(null);
            }
        });
    }

    private void addParentMouseEvents(Component comp) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ClanEventsPanel.this.ssArea.getParent().getParent().dispatchEvent(e);
            }
        });
    }

    public void updateUiAfterAPI(String header) {
        this.service.getSheet(header).ifPresent(this::updatePanelAsync);
    }

    public void updatePanelAsync(List<List<Object>> values) {
        SwingUtilities.invokeLater(() -> this.formatPanelData(values));
    }

    private void formatPanelData(List<List<Object>> values) {
        this.ssArea.setVisible(false);
        SwingUtil.fastRemoveAll((Container)this.ssArea);
        String[][] rows = new String[values.size()][];
        boolean setInvisible = false;
        int j = 0;
        for (List<Object> lst : values) {
            rows[j++] = lst.toArray(new String[0]);
        }
        block91: for (j = 0; j < rows.length; ++j) {
            String val1;
            try {
                val1 = rows[j][0].trim();
            }
            catch (Exception e) {
                val1 = "";
            }
            switch (val1) {
                case "<column>": {
                    Color color;
                    int style;
                    String[] str;
                    String val2;
                    int i;
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(new EmptyBorder(0, 0, 3, 0));
                    DefaultTableModel model = new DefaultTableModel();
                    JTable table = new JTable(model);
                    this.addTableMouseEvents(table);
                    table.setAutoResizeMode(0);
                    model.addColumn(null);
                    ArrayList<ColumnCellRenderer> hr = new ArrayList<ColumnCellRenderer>();
                    ArrayList<ColumnCellRenderer> cr = new ArrayList<ColumnCellRenderer>();
                    hr.add(new ColumnCellRenderer(new DefaultTableCellRenderer()));
                    cr.add(new ColumnCellRenderer(new DefaultTableCellRenderer()));
                    ArrayList<String> names = new ArrayList<String>();
                    names.add("");
                    int column_val_idx = 0;
                    for (i = 1; i < rows[j].length; ++i) {
                        try {
                            val2 = rows[j][i].trim();
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        if (Objects.equals(val2, "<column>")) {
                            model.addColumn(null);
                            hr.add(new ColumnCellRenderer(new DefaultTableCellRenderer()));
                            cr.add(new ColumnCellRenderer(new DefaultTableCellRenderer()));
                            names.add("");
                            column_val_idx = 0;
                            continue;
                        }
                        try {
                            switch (column_val_idx) {
                                case 0: {
                                    names.set(model.getColumnCount() - 1, val2);
                                    break;
                                }
                                case 1: {
                                    ((ColumnCellRenderer)hr.get(model.getColumnCount() - 1)).setMax(Integer.parseInt(val2));
                                    ((ColumnCellRenderer)cr.get(model.getColumnCount() - 1)).setMax(Integer.parseInt(val2));
                                }
                                case 2: {
                                    val2 = val2.replaceAll(" +", " ");
                                    val2 = val2.replaceAll(", ", ",").toLowerCase();
                                    str = val2.split(",");
                                    switch (str[1]) {
                                        case "bold": {
                                            style = 1;
                                            break;
                                        }
                                        case "italic": {
                                            style = 2;
                                            break;
                                        }
                                        default: {
                                            style = 0;
                                        }
                                    }
                                    ((ColumnCellRenderer)hr.get(model.getColumnCount() - 1)).setFont(new Font(str[0], style, Integer.parseInt(str[2])));
                                    break;
                                }
                                case 3: {
                                    color = (Color)Color.class.getField(val2).get(null);
                                    ((ColumnCellRenderer)hr.get(model.getColumnCount() - 1)).setColor(color);
                                    break;
                                }
                                case 4: {
                                    val2 = val2.replaceAll(" +", " ");
                                    val2 = val2.replaceAll(", ", ",").toLowerCase();
                                    str = val2.split(",");
                                    switch (str[1]) {
                                        case "bold": {
                                            style = 1;
                                            break;
                                        }
                                        case "italic": {
                                            style = 2;
                                            break;
                                        }
                                        default: {
                                            style = 0;
                                        }
                                    }
                                    ((ColumnCellRenderer)cr.get(model.getColumnCount() - 1)).setFont(new Font(str[0], style, Integer.parseInt(str[2])));
                                    break;
                                }
                                case 5: {
                                    color = (Color)Color.class.getField(val2).get(null);
                                    ((ColumnCellRenderer)cr.get(model.getColumnCount() - 1)).setColor(color);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++column_val_idx;
                    }
                    for (i = 0; i < model.getColumnCount(); ++i) {
                        TableColumn tc = table.getColumnModel().getColumn(i);
                        tc.setPreferredWidth(0);
                        tc.setHeaderValue(names.get(i));
                        tc.setHeaderRenderer((TableCellRenderer)hr.get(i));
                        tc.setCellRenderer((TableCellRenderer)cr.get(i));
                    }
                    ++j;
                    while (j < rows.length) {
                        try {
                            val2 = rows[j][0];
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        if (Objects.equals(val2.trim().toLowerCase(), "</column>")) break;
                        model.addRow(rows[j]);
                        ++j;
                    }
                    Dimension d = new Dimension(table.getPreferredSize().width, table.getRowHeight() * table.getRowCount());
                    table.setPreferredScrollableViewportSize(d);
                    JScrollPane scroll = new JScrollPane(table);
                    scroll.setHorizontalScrollBarPolicy(31);
                    this.addParentMouseEvents(table);
                    this.addParentMouseEvents(table.getTableHeader());
                    table.setEnabled(false);
                    panel.add((Component)scroll, "North");
                    if (setInvisible) {
                        panel.setVisible(false);
                        setInvisible = false;
                    }
                    this.ssArea.add(panel);
                    continue block91;
                }
                case "<button>": {
                    int style;
                    String val2;
                    int i;
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(new EmptyBorder(0, 0, 3, 0));
                    JButton button = new JButton("<html>");
                    button.setBorder(new EmptyBorder(3, 3, 3, 3));
                    button.setFocusable(false);
                    this.addParentMouseEvents(button);
                    block95: for (i = 1; i < rows[j].length; ++i) {
                        try {
                            val2 = rows[j][i].trim();
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        try {
                            block47 : switch (i - 1) {
                                case 0: {
                                    switch (val2 = val2.toLowerCase()) {
                                        case "right": {
                                            style = 4;
                                            break;
                                        }
                                        case "center": {
                                            style = 0;
                                            break;
                                        }
                                        default: {
                                            style = 2;
                                        }
                                    }
                                    button.setHorizontalAlignment(style);
                                    break;
                                }
                                case 1: {
                                    switch (val2.toLowerCase()) {
                                        case "hide": {
                                            this.createHideEvent(button);
                                            setInvisible = true;
                                            break block47;
                                        }
                                        case "show": {
                                            this.createHideEvent(button);
                                            break block47;
                                        }
                                    }
                                    if (val2.isEmpty()) continue block95;
                                    ClanEventsPanel.createLinkEvent(button, val2);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++j;
                    String newLine = "";
                    boolean addNewline = false;
                    while (j < rows.length) {
                        try {
                            val2 = String.join((CharSequence)" ", rows[j]);
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        if (Objects.equals(val2.trim().toLowerCase(), "</button>")) {
                            button.setText(button.getText() + "</html>");
                            break;
                        }
                        button.setText(button.getText() + newLine + val2);
                        if (!addNewline) {
                            newLine = "<br>";
                            addNewline = true;
                        }
                        ++j;
                    }
                    panel.add((Component)button, "North");
                    this.ssArea.add(panel);
                    continue block91;
                }
                case "<text>": {
                    Color color;
                    int style;
                    String[] str;
                    String val2;
                    int i;
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(new EmptyBorder(0, 0, 3, 0));
                    JTextArea text = new JTextArea();
                    text.setBorder(new EmptyBorder(3, 3, 4, 4));
                    text.setLayout(new BorderLayout());
                    text.setLineWrap(true);
                    text.setWrapStyleWord(true);
                    for (i = 1; i < rows[j].length; ++i) {
                        try {
                            val2 = rows[j][i].trim();
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        try {
                            switch (i - 1) {
                                case 0: {
                                    val2 = val2.replaceAll(" +", " ");
                                    val2 = val2.replaceAll(", ", ",").toLowerCase();
                                    str = val2.split(",");
                                    switch (str[1]) {
                                        case "bold": {
                                            style = 1;
                                            break;
                                        }
                                        case "italic": {
                                            style = 2;
                                            break;
                                        }
                                        default: {
                                            style = 0;
                                        }
                                    }
                                    text.setFont(new Font(str[0], style, Integer.parseInt(str[2])));
                                    break;
                                }
                                case 1: {
                                    color = (Color)Color.class.getField(val2).get(null);
                                    text.setForeground(color);
                                    text.setDisabledTextColor(color);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++j;
                    String newLine = "";
                    boolean addNewline = false;
                    while (j < rows.length) {
                        try {
                            val2 = String.join((CharSequence)" ", rows[j]);
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        if (Objects.equals(val2.trim().toLowerCase(), "</text>")) break;
                        text.append(newLine + val2);
                        if (!addNewline) {
                            newLine = System.lineSeparator();
                            addNewline = true;
                        }
                        ++j;
                    }
                    JScrollPane scroll = new JScrollPane(text);
                    scroll.setHorizontalScrollBarPolicy(31);
                    scroll.setBorder(new EmptyBorder(0, 0, -1, -1));
                    this.addParentMouseEvents(text);
                    text.setEnabled(false);
                    panel.add((Component)scroll, "North");
                    if (setInvisible) {
                        panel.setVisible(false);
                        setInvisible = false;
                    }
                    this.ssArea.add(panel);
                    continue block91;
                }
                case "<html>": {
                    ++j;
                }
                default: {
                    String val2;
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(new EmptyBorder(0, 0, 3, 0));
                    JLabel label = new JLabel("<html>");
                    label.setBorder(new EmptyBorder(3, 3, 3, 3));
                    String newLine = "";
                    boolean addNewline = false;
                    while (j < rows.length) {
                        try {
                            val2 = String.join((CharSequence)" ", rows[j]);
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                        if (Objects.equals(val2.trim().toLowerCase(), "</html>")) {
                            label.setText(label.getText() + val2);
                            break;
                        }
                        label.setText(label.getText() + newLine + val2);
                        if (!addNewline) {
                            newLine = "<br>";
                            addNewline = true;
                        }
                        ++j;
                    }
                    panel.add((Component)label, "North");
                    if (setInvisible) {
                        panel.setVisible(false);
                        setInvisible = false;
                    }
                    this.ssArea.add(panel);
                }
            }
        }
        this.ssArea.revalidate();
        this.ssArea.repaint();
        this.ssArea.setVisible(true);
    }

    public void onActivate() {
        this.openedTab = true;
        this.timer.start();
    }

    public void onDeactivate() {
        this.timer.stop();
    }

    private class KeyAction
    extends AbstractAction {
        KeyName key;
        ClanEventsConfig config;

        KeyAction(KeyName key, ClanEventsConfig config) {
            this.key = key;
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.key) {
                case KN_1: 
                case KN_2: 
                case KN_3: 
                case KN_4: 
                case KN_5: 
                case KN_6: 
                case KN_7: {
                    if (!ClanEventsPanel.this.dropdown.isPopupVisible() || ClanEventsPanel.this.dropdown.getItemCount() < this.key.getValue()) break;
                    ClanEventsPanel.this.dropdown.setSelectedIndex(this.key.getValue() - 1);
                    ClanEventsPanel.this.dropdown.setPopupVisible(false);
                    break;
                }
                case KN_UP: {
                    if (!ClanEventsPanel.this.dropdown.isPopupVisible()) break;
                    int selected = ClanEventsPanel.this.dropdown.getSelectedIndex();
                    if (selected == 0) {
                        ClanEventsPanel.this.dropdown.setSelectedIndex(ClanEventsPanel.this.dropdown.getItemCount() - 1);
                    } else {
                        ClanEventsPanel.this.dropdown.setSelectedIndex(selected - 1);
                    }
                    ClanEventsPanel.this.dropdown.setPopupVisible(false);
                    break;
                }
                case KN_DOWN: {
                    if (!ClanEventsPanel.this.dropdown.isPopupVisible()) break;
                    int selected = ClanEventsPanel.this.dropdown.getSelectedIndex();
                    if (selected == ClanEventsPanel.this.dropdown.getItemCount() - 1) {
                        ClanEventsPanel.this.dropdown.setSelectedIndex(0);
                    } else {
                        ClanEventsPanel.this.dropdown.setSelectedIndex(selected + 1);
                    }
                    ClanEventsPanel.this.dropdown.setPopupVisible(false);
                    break;
                }
                case KN_KEYBIND: {
                    ClanEventsPanel.this.dropdown.setPopupVisible(!ClanEventsPanel.this.dropdown.isPopupVisible());
                }
            }
        }
    }
}

