/*
 * Decompiled with CFR 0.152.
 */
package com.clanevents;

import com.clanevents.ClanEventsConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class ClanEventsOverlay
extends OverlayPanel {
    @Inject
    private ClanEventsConfig config;

    @Inject
    private ClanEventsOverlay() {
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Clan Events overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        String text = this.config.eventPass() + " " + this.config.challengePass();
        Color passColor = this.config.passColor();
        Color timeColor = this.config.timeColor();
        if (passColor.toString().equals(timeColor.toString())) {
            passColor = Color.green;
            timeColor = Color.WHITE;
        }
        if (!text.equals(" ") && !text.equals("  ") && this.config.overlay()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(text).leftColor(passColor).build());
            if (this.config.dtm()) {
                text = text + " " + ClanEventsOverlay.localToGMT();
                List elem = this.panelComponent.getChildren();
                ((LineComponent)elem.get(0)).setRight(ClanEventsOverlay.localToGMT());
                ((LineComponent)elem.get(0)).setRightColor(timeColor);
            }
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(text) + 10, 0));
        }
        return super.render(graphics);
    }

    public static String localToGMT() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date) + " UTC";
    }
}

