/*
 * Decompiled with CFR 0.152.
 */
package com.clanevents;

import com.clanevents.constants.EntrySelect;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="clanevents")
public interface ClanEventsConfig
extends Config {
    public static final int REFRESH_PERIOD_MIN = 5;
    public static final int REFRESH_PERIOD_MAX = 1440;
    @ConfigSection(name="Overlay", description="Overlay configuration.", position=0)
    public static final String overlaySection = "Overlay section";
    @ConfigSection(name="Plugin Panel", description="Plugin panel configuration", position=1)
    public static final String panelSection = "Plugin Panel section";

    @ConfigItem(position=1, keyName="overlay", name="Display Overlay", description="Displays the overlay on your game screen.", section="Overlay section")
    default public boolean overlay() {
        return false;
    }

    @ConfigItem(position=2, keyName="dtm", name="Date & Time", description="Adds the date and time to the overlay.", section="Overlay section")
    default public boolean dtm() {
        return true;
    }

    @ConfigItem(position=3, keyName="eventPass", name="Event Password:", description="Adds the event password to the overlay.", section="Overlay section")
    default public String eventPass() {
        return "";
    }

    @ConfigItem(position=4, keyName="challengePass", name="Challenge Password:", description="Adds the challenge password to the overlay.", section="Overlay section")
    default public String challengePass() {
        return "";
    }

    @ConfigItem(position=5, keyName="disclaimer", name="Colors below must be different", description="The Password Color and the Date & Time Color must be different.", section="Overlay section")
    default public void disclaimer() {
    }

    @ConfigItem(position=6, keyName="passColor", name="Password Color", description="The color of the Event Password and Challenge Password.", section="Overlay section")
    default public Color passColor() {
        return Color.GREEN;
    }

    @ConfigItem(position=7, keyName="timeColor", name="Date & Time Color", description="The color of the Date & Time.", section="Overlay section")
    default public Color timeColor() {
        return Color.WHITE;
    }

    @ConfigItem(position=1, keyName="sheetId", name="Google Sheet ID:", description="ID of the Google Sheet to read.", section="Plugin Panel section")
    default public String sheetId() {
        return "1YMcXxSL3s1NEzsPVMMkPn7EdGNFKENiwqNyDKkJTO80";
    }

    @ConfigItem(position=2, keyName="apiKey", name="Google API Key:", description="Key used to access the Google Sheet (ask your clan for one).", section="Plugin Panel section")
    default public String apiKey() {
        return "";
    }

    @ConfigItem(position=4, keyName="autoRefresh", name="Automatic Refresh", description="Enables automatic refreshing of the Clan Events panel.", section="Plugin Panel section")
    default public boolean autoRefresh() {
        return false;
    }

    @Range(min=5, max=1440)
    @ConfigItem(position=5, keyName="refreshPeriod", name="Refresh Period (min)", description="(5-1440) How often the Automatic Refresh should occur in minutes.", section="Plugin Panel section")
    @Units(value=" mins")
    default public int refreshPeriod() {
        return 10;
    }

    @ConfigItem(position=6, keyName="entryKeybind", name="Entry Select Keybind", description="Sets the keybind used for opening the entry menu in the Clan Events panel.", section="Plugin Panel section")
    default public Keybind entryKeybind() {
        return new Keybind(32, 0);
    }

    @ConfigItem(position=7, keyName="entry_1", name="Entry 1", description="Selects what to show for entry 1 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_1() {
        return EntrySelect.HOME;
    }

    @ConfigItem(position=8, keyName="entry_2", name="Entry 2", description="Selects what to show for entry 2 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_2() {
        return EntrySelect.HUB;
    }

    @ConfigItem(position=9, keyName="entry_3", name="Entry 3", description="Selects what to show for entry 3 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_3() {
        return EntrySelect.SOTW;
    }

    @ConfigItem(position=10, keyName="entry_4", name="Entry 4", description="Selects what to show for entry 4 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_4() {
        return EntrySelect.BOTW;
    }

    @ConfigItem(position=11, keyName="entry_5", name="Entry 5", description="Selects what to show for entry 5 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_5() {
        return EntrySelect.HOF_OVERALL;
    }

    @ConfigItem(position=12, keyName="entry_6", name="Entry 6", description="Selects what to show for entry 6 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_6() {
        return EntrySelect.HOF_KC;
    }

    @ConfigItem(position=13, keyName="entry_7", name="Entry 7", description="Selects what to show for entry 7 of the Clan Events panel.", section="Plugin Panel section")
    default public EntrySelect entry_7() {
        return EntrySelect.HOF_PB;
    }
}

