/*
 * Decompiled with CFR 0.152.
 */
package com.adriansoftware;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.sourceforge.jdatepicker.impl.DateComponentFormatter;
import net.sourceforge.jdatepicker.impl.JDatePanelImpl;
import net.sourceforge.jdatepicker.impl.JDatePickerImpl;
import net.sourceforge.jdatepicker.impl.UtilDateModel;
import org.apache.commons.lang3.StringUtils;

public class DatePickerPanel
extends JPanel {
    private final String labelText;
    private final LocalDateTime localDateTime;
    private final Consumer<Void> callback;
    private UtilDateModel model;
    private JComboBox<String> hour;
    private JComboBox<String> minute;
    private JComboBox<String> amPm;

    public DatePickerPanel(LocalDateTime localDateTime, String labelText, Consumer<Void> callback) {
        this.localDateTime = localDateTime;
        this.labelText = labelText;
        this.callback = callback;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.model = new UtilDateModel(Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        Properties p = new Properties();
        p.put("text.today", "Today");
        p.put("text.month", "Month");
        p.put("text.year", "Year");
        JDatePanelImpl datePanel = new JDatePanelImpl(this.model);
        JDatePickerImpl picker = new JDatePickerImpl(datePanel, new DateComponentFormatter());
        picker.setTextEditable(true);
        this.hour = new JComboBox<String>(DatePickerPanel.getArrayOfIntegers(1, 12));
        this.hour.setSelectedItem("12");
        this.minute = new JComboBox<String>(DatePickerPanel.getArrayOfIntegers(0, 60));
        this.minute.setSelectedItem("00");
        this.amPm = new JComboBox<String>(new Vector<String>(Arrays.asList("AM", "PM")));
        this.amPm.setSelectedItem("AM");
        this.addListeners();
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new BoxLayout(timePanel, 2));
        timePanel.add(this.hour);
        timePanel.add(Box.createHorizontalGlue());
        timePanel.add(this.minute);
        timePanel.add(Box.createHorizontalGlue());
        timePanel.add(this.amPm);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 3));
        containerPanel.add(picker);
        containerPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        containerPanel.add(timePanel);
        this.add(containerPanel);
        this.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(this.labelText)));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
    }

    private void addListeners() {
        this.model.addChangeListener(event -> this.callback.accept(null));
        this.hour.addItemListener(event -> this.callback.accept(null));
        this.minute.addItemListener(event -> this.callback.accept(null));
        this.amPm.addItemListener(event -> this.callback.accept(null));
    }

    public LocalDateTime getLocalDateTime() {
        if (this.hour == null || this.amPm == null || this.model == null || this.minute == null) {
            return null;
        }
        int h = Integer.parseInt(String.valueOf(this.hour.getSelectedItem()).replaceAll("^0+", "")) - 1;
        if (this.amPm.getSelectedItem() == "PM") {
            h += 12;
        }
        return LocalDateTime.of(this.model.getYear(), this.model.getMonth() + 1, this.model.getDay(), h, Integer.parseInt((String)this.minute.getSelectedItem()), 0, 0);
    }

    protected static Vector<String> getArrayOfIntegers(int start, int end, boolean pad) {
        return Stream.iterate(start, n -> n + 1).limit(end).map(v -> DatePickerPanel.getFormattedTimeString(String.valueOf(v), pad)).collect(Collectors.toCollection(Vector::new));
    }

    protected static Vector<String> getArrayOfIntegers(int start, int end) {
        return DatePickerPanel.getArrayOfIntegers(start, end, true);
    }

    protected static String getFormattedTimeString(String s, boolean pad) {
        return pad ? StringUtils.leftPad((String)s, (int)2, (char)'0') : s;
    }
}

