/*
 * Decompiled with CFR 0.152.
 */
package com.adriansoftware;

import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Item;
import net.runelite.client.game.ItemManager;

class ContainerCalculation {
    private final ItemManager itemManager;
    private int hash;
    private Long gePrice;

    @Inject
    private ContainerCalculation(ItemManager itemManager) {
        this.itemManager = itemManager;
    }

    @Nullable
    long calculate(Item[] items) {
        int newHash = this.hashItems(items);
        if (this.gePrice != null && this.hash == newHash) {
            return this.gePrice;
        }
        this.hash = newHash;
        long ge = 0L;
        block4: for (Item item : items) {
            int qty = item.getQuantity();
            int id = item.getId();
            if (id <= 0 || qty == 0) continue;
            switch (id) {
                case 995: {
                    ge += (long)qty;
                    continue block4;
                }
                case 13204: {
                    ge += (long)qty * 1000L;
                    continue block4;
                }
                default: {
                    ge += (long)this.itemManager.getItemPrice(id) * (long)qty;
                }
            }
        }
        return ge;
    }

    private int hashItems(Item[] items) {
        HashMap<Integer, Integer> mapCheck = new HashMap<Integer, Integer>(items.length);
        for (Item item : items) {
            mapCheck.put(item.getId(), item.getQuantity());
        }
        return mapCheck.hashCode();
    }
}

