/*
 * Decompiled with CFR 0.152.
 */
package com.adriansoftware;

import com.adriansoftware.BankHistoryConfig;
import com.adriansoftware.BankValue;
import com.adriansoftware.BankValueHistoryContainer;
import com.adriansoftware.BankValueHistoryDeserializer;
import com.adriansoftware.ContainerCalculation;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankValueHistoryTracker {
    private static final Logger log = LoggerFactory.getLogger(BankValueHistoryTracker.class);
    private static final List<Integer> TAB_VARBITS = ImmutableList.of((Object)4171, (Object)4172, (Object)4173, (Object)4174, (Object)4175, (Object)4176, (Object)4177, (Object)4178, (Object)4179);
    private static final File HISTORY_CACHE;
    private static final Gson GSON;
    private static final String EXTENTION = ".json";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BankHistoryConfig config;
    @Inject
    private ContainerCalculation bankCalculation;

    @Provides
    BankHistoryConfig getConfig(ConfigManager configManager) {
        return (BankHistoryConfig)configManager.getConfig(BankHistoryConfig.class);
    }

    public void add(String username, BankValue bankValue) {
        BankValueHistoryContainer valueHistory = this.getBankValueHistory(username);
        if (valueHistory != null) {
            valueHistory.addPrice(bankValue);
            try (FileWriter writer = new FileWriter(this.getFileForUser(username));){
                GSON.toJson((Object)valueHistory, (Appendable)writer);
            }
            catch (IOException e) {
                log.error("Unable to write to price value cache", (Throwable)e);
            }
            log.debug("Adding bank value history entry {}", (Object)valueHistory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BankValueHistoryContainer getBankValueHistory(String username) {
        try {
            File playerHistoryFile = this.getFileForUser(username);
            try (FileReader reader = new FileReader(this.getFileForUser(username));){
                log.debug("Creating bank history cache file at {}", (Object)playerHistoryFile.getAbsolutePath());
                BankValueHistoryContainer container = (BankValueHistoryContainer)GSON.fromJson((Reader)reader, BankValueHistoryContainer.class);
                if (container == null) {
                    BankValueHistoryContainer bankValueHistoryContainer = new BankValueHistoryContainer();
                    return bankValueHistoryContainer;
                }
                BankValueHistoryContainer bankValueHistoryContainer = container;
                return bankValueHistoryContainer;
            }
        }
        catch (IOException e) {
            log.error("Error reading/writing to the cache files", (Throwable)e);
            return null;
        }
    }

    public File getFileForUser(@NonNull String username) throws IOException {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        File file = new File(HISTORY_CACHE, username + EXTENTION);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public List<String> getAvailableUsers() {
        ArrayList<String> result = new ArrayList<String>();
        File[] accountFiles = HISTORY_CACHE.listFiles();
        if (accountFiles == null) {
            return result;
        }
        for (File file : accountFiles) {
            result.add(file.getName().replace(EXTENTION, ""));
        }
        return result;
    }

    public LocalDateTime getLastDataEntry(String username, int tab) {
        BankValueHistoryContainer container = this.getBankValueHistory(username);
        Set times = container.getPricesMap().entrySet().parallelStream().filter(bv -> ((BankValue)bv.getValue()).getTab() == tab).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (times == null || times.isEmpty()) {
            return null;
        }
        return (LocalDateTime)Collections.max(times);
    }

    public void addEntry(boolean force, Consumer<String> callback) {
        this.clientThread.invokeLater(() -> {
            int currentBankTab = this.client.getVar(4150);
            LocalDateTime lastEntry = this.getLastDataEntry(this.client.getUsername(), currentBankTab);
            LocalDateTime nextUpdateTime = LocalDateTime.of(0, 1, 1, 0, 0);
            if (lastEntry != null) {
                nextUpdateTime = lastEntry.plusHours(this.config.getDefaultDatasetEntry());
            }
            if (this.config.getOnlyManualEntries() && !force) {
                callback.accept("Automatic entries are currently disabled");
                return;
            }
            if (force || lastEntry == null || LocalDateTime.now().isAfter(nextUpdateTime)) {
                this.add(this.client.getUsername(), BankValue.builder().tab(this.client.getVar(4150)).bankValue(this.bankCalculation.calculate(this.getBankTabItems())).build());
                if (callback != null) {
                    callback.accept("New entry added!");
                }
            } else if (callback != null) {
                callback.accept("No entry added.");
            }
        });
    }

    public void addEntry() {
        this.addEntry(false, null);
    }

    private Item[] getBankTabItems() {
        ItemContainer container = this.client.getItemContainer(InventoryID.BANK);
        if (container == null) {
            return null;
        }
        Item[] items = container.getItems();
        int currentTab = this.client.getVar(4150);
        if (currentTab > 0) {
            int startIndex = 0;
            for (int i = currentTab - 1; i > 0; --i) {
                startIndex += this.client.getVar(TAB_VARBITS.get(i - 1).intValue());
            }
            int itemCount = this.client.getVar(TAB_VARBITS.get(currentTab - 1).intValue());
            return Arrays.copyOfRange(items, startIndex, startIndex + itemCount);
        }
        return items;
    }

    static {
        GSON = RuneLiteAPI.GSON.newBuilder().registerTypeAdapter(BankValueHistoryContainer.class, (Object)new BankValueHistoryDeserializer()).create();
        HISTORY_CACHE = new File(RuneLite.RUNELITE_DIR, "bank-value-tracker");
        HISTORY_CACHE.mkdirs();
    }
}

