/*
 * Decompiled with CFR 0.152.
 */
package com.adriansoftware;

import com.adriansoftware.BankHistoryConfig;
import com.adriansoftware.BankHistoryPanel;
import com.adriansoftware.BankValueHistoryTracker;
import com.adriansoftware.DefaultBankValuePanel;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Value Tracking", description="Track the value of your bank over time", tags={"bank", "value", "history", "tracking"})
public class BankHistoryPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankHistoryPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BankValueHistoryTracker tracker;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private BankHistoryPanel bankHistoryPanel;

    @Provides
    BankHistoryConfig getConfig(ConfigManager configManager) {
        return (BankHistoryConfig)configManager.getConfig(BankHistoryConfig.class);
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"bank_logo.png");
        this.navButton = NavigationButton.builder().tooltip("Bank Value History").icon(icon).priority(10).build();
        this.setActivePanel("");
        this.clientToolbar.addNavigation(this.navButton);
    }

    private void setActivePanel(String username) {
        if (!Strings.isNullOrEmpty((String)username) || this.hasAccountData()) {
            if (this.bankHistoryPanel == null) {
                log.trace("Setting the active panel to the bank history panel");
                this.bankHistoryPanel = (BankHistoryPanel)((Object)this.injector.getInstance(BankHistoryPanel.class));
                this.bankHistoryPanel.init(username);
                this.setCurrentPanel(this.bankHistoryPanel);
            }
        } else {
            log.trace("Setting the active panel to the default panel");
            DefaultBankValuePanel panel = new DefaultBankValuePanel();
            panel.init();
            this.setCurrentPanel(panel);
        }
    }

    private void setCurrentPanel(PluginPanel pluginPanel) {
        if (this.navButton.getPanel() != pluginPanel) {
            PluginPanel panel = this.navButton.getPanel();
            if (panel == null) {
                this.navButton.setPanel(pluginPanel);
                return;
            }
            Container con = panel.getParent();
            if (con != null) {
                this.navButton.setPanel(pluginPanel);
                this.removeExistingPanel(con);
                con.add((Component)pluginPanel, "North");
                con.revalidate();
                con.repaint();
            }
        }
    }

    private void removeExistingPanel(Container con) {
        Component[] comps = con.getComponents();
        if (comps != null) {
            for (Component component : comps) {
                if (!(component instanceof PluginPanel)) continue;
                log.trace("Removing plugin panel instance from container");
                con.remove(component);
            }
        }
    }

    private boolean hasAccountData() {
        return !this.tracker.getAvailableUsers().isEmpty();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if ("setBankTitle".equals(event.getEventName())) {
            this.tracker.addEntry();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) throws InvocationTargetException, InterruptedException {
        if (event.getGroupId() == 12) {
            log.trace("Player opened the bank");
            SwingUtilities.invokeAndWait(() -> this.setActivePanel(this.client.getUsername()));
            if (this.isHistoryPanelActive()) {
                this.bankHistoryPanel.setDatasetButton(true);
            }
        }
    }

    private boolean isHistoryPanelActive() {
        return this.bankHistoryPanel != null && this.navButton.getPanel() == this.bankHistoryPanel;
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 12) {
            log.debug("onWidgetClosed: Bank closed");
            this.bankHistoryPanel.setDatasetButton(false);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState().getState()) {
            case 40: {
                this.bankHistoryPanel.setDatasetButton(false);
            }
        }
    }
}

