/*
 * Decompiled with CFR 0.152.
 */
package com.adriansoftware;

import com.adriansoftware.BankHistoryConfig;
import com.adriansoftware.BankValue;
import com.adriansoftware.BankValueHistoryContainer;
import com.adriansoftware.BankValueHistoryTracker;
import com.adriansoftware.DatePickerPanel;
import com.google.inject.Provides;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.QuantityFormatter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class BankHistoryPanel
extends PluginPanel {
    @Inject
    private BankHistoryConfig config;
    @Inject
    private BankValueHistoryTracker tracker;
    private DatePickerPanel toDatePickerPanel;
    private DatePickerPanel startDatePickerPanel;
    private JFreeChart chart;
    private ChartPanel graphPanel = null;
    private SimpleTimeSelection timeSelection = SimpleTimeSelection.ALL;
    private Map<LocalDateTime, Long> currentDataRange;
    private JLabel changeLabel;
    private TimeSeriesCollection dataset;
    private int currentBankTab = -1;
    private JButton addDatasetButton;

    @Provides
    BankHistoryConfig getConfig(ConfigManager configManager) {
        return (BankHistoryConfig)configManager.getConfig(BankHistoryConfig.class);
    }

    public void init(String username) {
        this.init(username, false);
    }

    public void init() {
        this.init("", false);
    }

    private void init(final String username, boolean isNewWindow) {
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        Set<String> accounts = this.getAccounts(username);
        JPanel uiWrapperPanel = new JPanel();
        uiWrapperPanel.setLayout(new BoxLayout(uiWrapperPanel, 3));
        uiWrapperPanel.setMaximumSize(new Dimension(1280, 500));
        JComboBox<String> accountSelectionCombo = new JComboBox<String>(new Vector<String>(accounts));
        JCheckBox accountSelectionVisible = new JCheckBox("Show accounts");
        accountSelectionVisible.setSelected(this.config.getShowAccounts());
        accountSelectionVisible.addItemListener(event -> accountSelectionCombo.setVisible(accountSelectionVisible.isSelected()));
        accountSelectionVisible.setFocusPainted(false);
        accountSelectionCombo.addItemListener(change -> this.updateDataset(change.getItem().toString()));
        String account = this.config.getDefaultAccount();
        JComboBox simpleComboBox = new JComboBox(new Vector(Stream.of(SimpleTimeSelection.values()).map(SimpleTimeSelection::getFormattedName).collect(Collectors.toList())));
        simpleComboBox.addItemListener(event -> {
            this.timeSelection = SimpleTimeSelection.of((String)event.getItem());
            this.updateDataset((String)accountSelectionCombo.getSelectedItem());
        });
        final JButton showAdvancedButton = new JButton("Advanced");
        showAdvancedButton.setFocusPainted(false);
        final JPanel simpleContainer = new JPanel();
        simpleContainer.setLayout(new BoxLayout(simpleContainer, 2));
        simpleContainer.add(simpleComboBox);
        LocalDate today = LocalDate.now();
        LocalDateTime startOfDay = today.atStartOfDay();
        Consumer<Void> callback = t -> this.updateDataset((String)accountSelectionCombo.getSelectedItem());
        this.startDatePickerPanel = new DatePickerPanel(startOfDay, "Start Date", callback);
        this.toDatePickerPanel = new DatePickerPanel(startOfDay.plusDays(1L), "End Date", callback);
        this.startDatePickerPanel.init();
        this.toDatePickerPanel.init();
        final JPanel datePickerContainer = new JPanel();
        datePickerContainer.setLayout(new BoxLayout(datePickerContainer, 3));
        datePickerContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        datePickerContainer.add(this.startDatePickerPanel);
        datePickerContainer.add(Box.createRigidArea(new Dimension(0, 10)));
        datePickerContainer.add(this.toDatePickerPanel);
        datePickerContainer.setVisible(false);
        showAdvancedButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean visible = datePickerContainer.isVisible();
                datePickerContainer.setVisible(!visible);
                simpleContainer.setVisible(visible);
                if (visible) {
                    showAdvancedButton.setText("Advanced");
                    BankHistoryPanel.this.timeSelection = null;
                } else {
                    showAdvancedButton.setText("Simple");
                }
            }
        });
        JPanel advancedContainer = new JPanel();
        advancedContainer.setLayout(new BorderLayout());
        advancedContainer.add((Component)showAdvancedButton, "Center");
        advancedContainer.add(Box.createRigidArea(new Dimension(0, 10)), "South");
        advancedContainer.setMaximumSize(new Dimension(1280, 45));
        JPanel openInNewWindowContainer = new JPanel();
        openInNewWindowContainer.setLayout(new BorderLayout());
        openInNewWindowContainer.add(Box.createRigidArea(new Dimension(0, 10)), "South");
        JButton newWindowButton = new JButton("Open In New Window");
        newWindowButton.setMaximumSize(new Dimension(100, 30));
        newWindowButton.setFocusPainted(false);
        newWindowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JFrame frame = (JFrame)SwingUtilities.getWindowAncestor((Component)((Object)BankHistoryPanel.this));
                JDialog dialog = new JDialog(frame, "Bank History", false);
                BankHistoryPanel panel = new BankHistoryPanel();
                panel.setTracker(BankHistoryPanel.this.tracker);
                panel.setConfig(BankHistoryPanel.this.config);
                panel.init(username, true);
                dialog.setPreferredSize(new Dimension(500, 500));
                dialog.getContentPane().add((Component)((Object)panel), "Center");
                dialog.setLocationRelativeTo(null);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        openInNewWindowContainer.add((Component)newWindowButton, "Center");
        JPanel tabPanel = new JPanel();
        JComboBox<String> tabSelectionCombo = new JComboBox<String>(DatePickerPanel.getArrayOfIntegers(0, 10, false));
        tabSelectionCombo.addItemListener(event -> {
            this.currentBankTab = Integer.parseInt((String)event.getItem());
            this.updateDataset((String)accountSelectionCombo.getSelectedItem());
        });
        int defaultBankTab = this.config.getDefaultBankTab();
        tabSelectionCombo.setSelectedIndex(defaultBankTab);
        this.currentBankTab = defaultBankTab;
        JLabel tabLabel = new JLabel("Bank Tab: ");
        tabPanel.setLayout(new BoxLayout(tabPanel, 2));
        tabPanel.add(tabLabel);
        tabPanel.add(tabSelectionCombo);
        JPanel addDatasetPanel = new JPanel();
        addDatasetPanel.setLayout(new BorderLayout());
        this.addDatasetButton = new JButton("Add Entry");
        this.setDatasetButton(false);
        this.addDatasetButton.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.addDatasetButton.setForeground(Color.WHITE);
        this.addDatasetButton.setFocusPainted(false);
        this.addDatasetButton.addActionListener(event -> {
            this.setDatasetButton(false);
            this.tracker.addEntry(true, s -> SwingUtilities.invokeLater(() -> {
                this.updateDataset((String)accountSelectionCombo.getSelectedItem());
                this.setDatasetButton(true);
            }));
        });
        addDatasetPanel.add((Component)this.addDatasetButton, "Center");
        JPanel refreshPanel = new JPanel();
        refreshPanel.setLayout(new BorderLayout());
        JButton refreshButton = new JButton("Refresh");
        refreshButton.setFocusPainted(false);
        refreshButton.addActionListener(event -> this.updateDataset((String)accountSelectionCombo.getSelectedItem()));
        refreshPanel.add((Component)refreshButton, "Center");
        this.add(uiWrapperPanel);
        uiWrapperPanel.add(accountSelectionCombo);
        uiWrapperPanel.add(accountSelectionVisible);
        uiWrapperPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        uiWrapperPanel.add(advancedContainer);
        uiWrapperPanel.add(simpleContainer);
        uiWrapperPanel.add(datePickerContainer);
        uiWrapperPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        uiWrapperPanel.add(tabPanel);
        uiWrapperPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.loadGraph(account.isEmpty() ? (String)accounts.stream().findFirst().get() : account);
        JPanel changePanel = new JPanel();
        changePanel.setLayout(new BorderLayout());
        this.changeLabel = this.getChangeLabelValue();
        this.changeLabel.setHorizontalAlignment(0);
        changePanel.add((Component)this.changeLabel, "Center");
        uiWrapperPanel.add(changePanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(addDatasetPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(refreshPanel);
        if (!isNewWindow) {
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(openInNewWindowContainer);
        }
    }

    private Set<String> getAccounts(String username) {
        HashSet<String> result = new HashSet<String>(this.tracker.getAvailableUsers());
        if (!username.isEmpty()) {
            result.add(username);
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("No accounts available");
        }
        return result;
    }

    private void updateDataset(String account) {
        this.dataset = this.getDataset(account);
        this.setChangeLabel();
        this.chart.getXYPlot().setDataset(this.dataset);
    }

    private void setChangeLabel() {
        JLabel result = this.getChangeLabelValue();
        if (this.changeLabel != null) {
            this.changeLabel.setForeground(result.getForeground());
            this.changeLabel.setText(result.getText());
        } else {
            this.changeLabel = result;
        }
    }

    private JLabel getChangeLabelValue() {
        JLabel result = new JLabel();
        result.setForeground(ColorScheme.BRAND_ORANGE);
        if (this.currentDataRange == null || this.currentDataRange.isEmpty()) {
            result.setText("No Data available for selected range");
            return result;
        }
        LocalDateTime start = Collections.min(this.currentDataRange.keySet());
        LocalDateTime end = Collections.max(this.currentDataRange.keySet());
        long startValue = this.currentDataRange.get(start);
        long endValue = this.currentDataRange.get(end);
        long finishValue = endValue - startValue;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        String percentChange = decimalFormat.format((double)(endValue - startValue) / (double)Math.abs(startValue) * 100.0);
        String formattedValue = QuantityFormatter.quantityToStackSize((long)finishValue);
        Object formattedString = "No Change";
        if (finishValue < 0L) {
            formattedString = formattedValue + " (" + percentChange + "%)";
            result.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        } else if (finishValue > 0L) {
            formattedString = formattedValue + " (+ " + percentChange + "%)";
            result.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        }
        result.setText((String)formattedString);
        return result;
    }

    public void loadGraph(String username) {
        this.dataset = this.getDataset(username);
        ChartFactory.setChartTheme(StandardChartTheme.createDarknessTheme());
        this.chart = ChartFactory.createTimeSeriesChart(null, "Date/time", "Bank Value (mil)", this.dataset, false, true, false);
        XYPlot plot = this.chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
        }
        plot.setBackgroundPaint(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        this.chart.setBackgroundPaint(ColorScheme.DARK_GRAY_HOVER_COLOR);
        if (this.graphPanel != null) {
            this.remove(this.graphPanel);
        }
        this.graphPanel = new ChartPanel(this.chart);
        this.graphPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.graphPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add(this.graphPanel, "South");
        this.revalidate();
        this.repaint();
    }

    private TimeSeriesCollection getDataset(String username) {
        BankValueHistoryContainer container = this.tracker.getBankValueHistory(username);
        TimeSeriesCollection collection = new TimeSeriesCollection();
        if (container == null) {
            return collection;
        }
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"bankValueVsTime"));
        HashMap<LocalDateTime, Long> currentDataRange = new HashMap<LocalDateTime, Long>();
        for (Map.Entry<LocalDateTime, BankValue> entry : container.getPricesMap().entrySet()) {
            LocalDateTime end;
            LocalDateTime start;
            long price = entry.getValue().getBankValue();
            LocalDateTime entryDateTime = entry.getKey();
            if (this.timeSelection != null) {
                start = SimpleTimeSelection.getPastTime(this.timeSelection);
                end = LocalDateTime.now();
            } else {
                start = this.startDatePickerPanel.getLocalDateTime();
                end = this.toDatePickerPanel.getLocalDateTime();
            }
            if (this.currentBankTab == -1 || this.currentBankTab != entry.getValue().getTab() || this.timeSelection != SimpleTimeSelection.ALL && (end == null || start == null || !this.onOrAfter(entryDateTime, start) || !this.onOrBefore(entryDateTime, end))) continue;
            currentDataRange.put(entryDateTime.atZone(ZoneId.systemDefault()).toLocalDateTime(), price);
            timeSeries.add((RegularTimePeriod)new Millisecond(Date.from(entryDateTime.atZone(ZoneId.systemDefault()).toInstant())), price);
        }
        this.currentDataRange = currentDataRange;
        collection.addSeries(timeSeries);
        return collection;
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if ("setBankTitle".equals(event.getEventName())) {
            this.addDatasetButton.setEnabled(true);
        }
    }

    private boolean onOrBefore(LocalDateTime first, LocalDateTime second) {
        return first.compareTo(second) == 0 || first.isBefore(second);
    }

    private boolean onOrAfter(LocalDateTime first, LocalDateTime second) {
        return first.compareTo(second) == 0 || first.isAfter(second);
    }

    protected void setDatasetButton(boolean enabled) {
        if (this.addDatasetButton != null && this.addDatasetButton.isEnabled() != enabled) {
            this.addDatasetButton.setEnabled(enabled);
        }
    }

    public void setConfig(BankHistoryConfig config) {
        this.config = config;
    }

    public void setTracker(BankValueHistoryTracker tracker) {
        this.tracker = tracker;
    }

    private static enum SimpleTimeSelection {
        ALL("All"),
        TODAY("Today"),
        HOUR("1 hour"),
        TWO_HOURS("2 Hours"),
        THREE_HOURS("4 Hours"),
        EIGHT_HOURS("8 Hours"),
        TWENTY_FOUR_HOURS("24 Hours"),
        WEEK("Week"),
        MONTH("Month"),
        SIX_MONTHS("6 Months"),
        YEAR("Year");

        private final String formattedName;

        static LocalDateTime getPastTime(SimpleTimeSelection timeSelection) {
            LocalDateTime dateTime = LocalDateTime.now();
            switch (timeSelection) {
                case ALL: {
                    return null;
                }
                case TODAY: {
                    LocalDate date = LocalDate.now();
                    return date.atStartOfDay();
                }
                case HOUR: {
                    return dateTime.minusHours(1L);
                }
                case TWO_HOURS: {
                    return dateTime.minusHours(2L);
                }
                case THREE_HOURS: {
                    return dateTime.minusHours(3L);
                }
                case EIGHT_HOURS: {
                    return dateTime.minusHours(8L);
                }
                case TWENTY_FOUR_HOURS: {
                    return dateTime.minusDays(1L);
                }
                case WEEK: {
                    return dateTime.minusWeeks(1L);
                }
                case MONTH: {
                    return dateTime.minusMonths(1L);
                }
                case SIX_MONTHS: {
                    return dateTime.minusMonths(6L);
                }
                case YEAR: {
                    return dateTime.minusYears(1L);
                }
            }
            throw new IllegalArgumentException("Unable to get past time");
        }

        public static SimpleTimeSelection of(String item) {
            for (SimpleTimeSelection t : SimpleTimeSelection.values()) {
                if (!t.getFormattedName().equals(item)) continue;
                return t;
            }
            throw new IllegalArgumentException("no SimpleTimeSelection of " + item + " found.");
        }

        private SimpleTimeSelection(String formattedName) {
            this.formattedName = formattedName;
        }

        public String getFormattedName() {
            return this.formattedName;
        }
    }
}

