/*
 * Decompiled with CFR 0.152.
 */
package com.npcidletimer;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.npcidletimer.NPCIdleTimerConfig;
import com.npcidletimer.NPCIdleTimerOverlay;
import com.npcidletimer.WanderingNPC;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Idle Timer")
public class NPCIdleTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NPCIdleTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NPCIdleTimerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NPCIdleTimerOverlay npcidletimeroverlay;
    private Instant lastTickUpdate;
    private long lastTrueTickUpdate;
    private final Map<Integer, WanderingNPC> wanderingNPCs = new HashMap<Integer, WanderingNPC>();
    private List<String> selectedNPCs = new ArrayList<String>();

    @Provides
    NPCIdleTimerConfig getConfig(ConfigManager configManager) {
        return (NPCIdleTimerConfig)configManager.getConfig(NPCIdleTimerConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.npcidletimeroverlay);
        this.selectedNPCs = this.getSelectedNPCs();
        this.rebuildAllNpcs();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.npcidletimeroverlay);
        this.wanderingNPCs.clear();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (this.client.isInInstancedRegion()) {
            return;
        }
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null || !this.selectedNPCs.contains(npcName.toLowerCase())) {
            return;
        }
        this.wanderingNPCs.putIfAbsent(npc.getIndex(), new WanderingNPC(npc));
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        if (this.client.isInInstancedRegion()) {
            return;
        }
        NPC npc = npcDespawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null || !this.selectedNPCs.contains(npcName.toLowerCase())) {
            return;
        }
        this.wanderingNPCs.remove(npc.getIndex());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.wanderingNPCs.clear();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.isInInstancedRegion()) {
            return;
        }
        this.lastTrueTickUpdate = this.client.getTickCount();
        this.lastTickUpdate = Instant.now();
        for (NPC npc : this.client.getNpcs()) {
            WanderingNPC wnpc;
            String npcName = npc.getName();
            if (npcName == null || !this.selectedNPCs.contains(npcName.toLowerCase()) || (wnpc = this.wanderingNPCs.get(npc.getIndex())) == null) continue;
            if (this.config.showOverlayTicks()) {
                long currentTick;
                if (wnpc.getCurrentLocation().getX() != npc.getWorldLocation().getX() || wnpc.getCurrentLocation().getY() != npc.getWorldLocation().getY()) {
                    currentTick = this.client.getTickCount();
                    wnpc.setCurrentLocation(npc.getWorldLocation());
                    wnpc.setTimeWithoutMoving(0L);
                    wnpc.setTrueStoppedMovingTick(currentTick);
                    wnpc.setNpc(npc);
                    continue;
                }
                currentTick = this.client.getTickCount();
                wnpc.setTimeWithoutMoving(this.lastTrueTickUpdate - wnpc.getTrueStoppedMovingTick());
                continue;
            }
            if (wnpc.getCurrentLocation().getX() != npc.getWorldLocation().getX() || wnpc.getCurrentLocation().getY() != npc.getWorldLocation().getY()) {
                wnpc.setCurrentLocation(npc.getWorldLocation());
                wnpc.setTimeWithoutMoving(0L);
                wnpc.setStoppedMovingTick(Instant.now());
                wnpc.setNpc(npc);
                continue;
            }
            wnpc.setTimeWithoutMoving(this.lastTickUpdate.getEpochSecond() - wnpc.getStoppedMovingTick().getEpochSecond());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcidletimerplugin")) {
            return;
        }
        this.selectedNPCs = this.getSelectedNPCs();
        this.rebuildAllNpcs();
    }

    @VisibleForTesting
    List<String> getSelectedNPCs() {
        String configNPCs = this.config.npcToShowTimer().toLowerCase();
        if (configNPCs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNPCs);
    }

    private void rebuildAllNpcs() {
        this.wanderingNPCs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null || !this.selectedNPCs.contains(npcName.toLowerCase())) continue;
            this.wanderingNPCs.putIfAbsent(npc.getIndex(), new WanderingNPC(npc));
        }
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }

    long getLastTrueTickUpdate() {
        return this.lastTrueTickUpdate;
    }

    Map<Integer, WanderingNPC> getWanderingNPCs() {
        return this.wanderingNPCs;
    }
}

