/*
 * Decompiled with CFR 0.152.
 */
package com.npcidletimer;

import com.npcidletimer.NPCIdleTimerConfig;
import com.npcidletimer.NPCIdleTimerPlugin;
import com.npcidletimer.WanderingNPC;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class NPCIdleTimerOverlay
extends Overlay {
    private final Client client;
    private final NPCIdleTimerPlugin plugin;
    private final NPCIdleTimerConfig config;
    NumberFormat format = new DecimalFormat("#");

    @Inject
    NPCIdleTimerOverlay(Client client, NPCIdleTimerPlugin plugin, NPCIdleTimerConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.isInInstancedRegion()) {
            return null;
        }
        if (this.config.showOverlay()) {
            this.plugin.getWanderingNPCs().forEach((id, npc) -> this.renderTimer((WanderingNPC)npc, graphics));
        }
        return null;
    }

    private void renderTimer(WanderingNPC npc, Graphics2D graphics) {
        Point canvasPoint;
        double maxDisplay = this.config.maxDisplay();
        if (this.config.customTimer()) {
            maxDisplay = this.config.customTiming();
        }
        double timeLeft = maxDisplay - (double)npc.getTimeWithoutMoving();
        double lowDisplay = this.config.lowDisplay();
        Color timerColor = this.config.normalTimerColor();
        if (timeLeft < 0.0) {
            timeLeft = 0.0;
        }
        if (timeLeft <= lowDisplay) {
            timerColor = this.config.lowTimerColor();
        }
        Object timeLeftString = String.valueOf(this.format.format(timeLeft));
        if (this.config.showTimingType()) {
            timeLeftString = this.config.showOverlayTicks() ? (String)timeLeftString + "T" : (String)timeLeftString + "S";
        }
        if ((canvasPoint = npc.getNpc().getCanvasTextLocation(graphics, (String)timeLeftString, npc.getNpc().getLogicalHeight() + this.config.timerHeight())) != null && maxDisplay >= timeLeft) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasPoint, (String)timeLeftString, (Color)timerColor);
        }
    }
}

