/*
 * Decompiled with CFR 0.152.
 */
package io.robrichardson.alchblocker;

import com.google.inject.Provides;
import io.robrichardson.alchblocker.AlchBlockerConfig;
import io.robrichardson.alchblocker.config.DisplayType;
import io.robrichardson.alchblocker.config.ListType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Alch Blocker")
public class AlchBlockerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AlchBlockerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private AlchBlockerConfig config;
    Set<String> itemList = new HashSet<String>();
    Set<Integer> hiddenItems = new HashSet<Integer>();
    boolean isAlching = false;

    protected void startUp() throws Exception {
        this.itemList = this.convertToListToSet();
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::showBlockedItems);
    }

    @Provides
    AlchBlockerConfig provideConfig(ConfigManager configManager) {
        return (AlchBlockerConfig)configManager.getConfig(AlchBlockerConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"AlchBlocker".equals(event.getGroup())) {
            return;
        }
        this.itemList = this.convertToListToSet();
        if (this.isAlching) {
            this.clientThread.invoke(this::showBlockedItems);
            this.clientThread.invoke(this::hideBlockedItems);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String menuTarget = Text.removeTags((String)event.getMenuTarget());
        boolean bl = this.isAlching = event.getMenuOption().contains("Alchemy") || event.getMenuOption().equals("Cast") && (Objects.equals(menuTarget, "High Level Alchemy") || Objects.equals(menuTarget, "Low Level Alchemy"));
        if (this.isAlching && this.hiddenItems.contains(event.getItemId())) {
            event.consume();
        }
        if (!this.isAlching) {
            this.showBlockedItems();
        }
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 6011 && this.isAlching) {
            this.hideBlockedItems();
        }
    }

    @Subscribe
    private void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 483) {
            this.hideBlockedItems();
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (!this.config.contextMenuEnabled()) {
            return;
        }
        MenuEntry[] entries = event.getMenuEntries();
        for (int idx = entries.length - 1; idx >= 0; --idx) {
            MenuEntry entry = entries[idx];
            Widget w = entry.getWidget();
            if (w == null || !entry.getOption().contains("-Alchemy") && (!entry.getOption().equals("Cast") || !entry.getTarget().contains("Level Alchemy"))) continue;
            if (this.hiddenItems.contains(w.getItemId()) && this.config.listType() == ListType.BLACKLIST || !this.hiddenItems.contains(w.getItemId()) && this.config.listType() == ListType.WHITELIST) {
                return;
            }
            String itemName = w.getName();
            this.client.createMenuEntry(idx).setOption(this.config.listType() == ListType.BLACKLIST ? "Blacklist Alchemy" : "Whitelist Alchemy").setTarget(itemName).setType(MenuAction.RUNELITE).onClick(e -> {
                this.configManager.setConfiguration("AlchBlocker", "itemList", this.config.itemList().concat("\n" + Text.removeTags((String)itemName)));
                this.showBlockedItems();
            });
        }
    }

    private void hideBlockedItems() {
        Widget inventory = this.client.getWidget(31653895);
        if (inventory == null && (inventory = this.client.getWidget(0x950000)) == null) {
            return;
        }
        for (Widget inventoryItem : Objects.requireNonNull(inventory.getChildren())) {
            String itemName = Text.removeTags((String)inventoryItem.getName()).toLowerCase();
            boolean isBlacklist = this.config.listType() != ListType.BLACKLIST;
            for (String blockedItem : this.itemList) {
                if (!WildcardMatcher.matches((String)blockedItem, (String)itemName)) continue;
                isBlacklist = this.config.listType() == ListType.BLACKLIST;
                break;
            }
            if (!isBlacklist) continue;
            if (this.config.displayType() == DisplayType.TRANSPARENT || 31653895 == inventory.getId()) {
                inventoryItem.setOpacity(200);
            } else {
                inventoryItem.setHidden(true);
            }
            this.hiddenItems.add(inventoryItem.getItemId());
        }
    }

    private void showBlockedItems() {
        if (this.hiddenItems.isEmpty()) {
            return;
        }
        Widget inventory = this.client.getWidget(31653895);
        if (inventory == null && (inventory = this.client.getWidget(0x950000)) == null) {
            return;
        }
        for (Widget inventoryItem : Objects.requireNonNull(inventory.getChildren())) {
            if (!this.hiddenItems.contains(inventoryItem.getItemId())) continue;
            if (this.config.displayType() == DisplayType.TRANSPARENT || 31653895 == inventory.getId()) {
                inventoryItem.setOpacity(0);
                continue;
            }
            inventoryItem.setHidden(false);
        }
        this.hiddenItems.clear();
        if (31653895 == inventory.getId()) {
            this.hideBlockedItems();
        }
    }

    private Set<String> convertToListToSet() {
        HashSet<String> newItems = new HashSet<String>();
        for (String listItem : this.config.itemList().split("\n")) {
            if (listItem.trim().equals("")) continue;
            if (listItem.contains(",")) {
                Set csvSet = Text.fromCSV((String)listItem).stream().map(String::toLowerCase).collect(Collectors.toSet());
                newItems.addAll(csvSet);
                continue;
            }
            newItems.add(listItem.toLowerCase().trim());
        }
        return newItems;
    }
}

