/*
 * Decompiled with CFR 0.152.
 */
package com.bank;

import com.bank.BankInterface;
import com.bank.RecentBankConfig;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bank.BankSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Recently Banked Items")
public class RecentBankPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RecentBankPlugin.class);
    public static final String CONFIG_GROUP_NAME = "RecentlyBankedItems";
    private static final String ON_RECENT = "Show Recent";
    private static final String OFF_RECENT = "Hide Recent";
    private static final String RECENT_ID_KEY = "recentlyBankedIds";
    private static final String LOCKED_ID_KEY = "lockedIds";
    private static final String AMOUNT_MAP_KEY = "idToAmount";
    private static final int ITEMS_PER_ROW = 8;
    private static final int ITEM_VERTICAL_SPACING = 36;
    private static final int ITEM_HORIZONTAL_SPACING = 48;
    private static final int ITEM_ROW_START = 51;
    private final List<Integer> recentIds = new LinkedList<Integer>();
    private final List<Integer> lockedIds = new LinkedList<Integer>();
    private final Map<Integer, Integer> bankItemsToAmount = new HashMap<Integer, Integer>();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RecentBankConfig config;
    @Inject
    private BankSearch bankSearch;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Gson gson;
    @Inject
    private ItemManager itemManager;
    @Inject
    private BankInterface bankInterface;
    private final KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            Widget bankContainer;
            if (RecentBankPlugin.this.config.toggleKeybind().matches(e)) {
                bankContainer = RecentBankPlugin.this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
                if (bankContainer == null || bankContainer.isSelfHidden()) {
                    return;
                }
                RecentBankPlugin.this.configManager.setConfiguration(RecentBankPlugin.CONFIG_GROUP_NAME, "viewToggle", (Object)(!RecentBankPlugin.this.config.recentViewToggled() ? 1 : 0));
                e.consume();
            }
            if (RecentBankPlugin.this.config.toggleLockKeybind().matches(e)) {
                bankContainer = RecentBankPlugin.this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
                if (bankContainer == null || bankContainer.isSelfHidden()) {
                    return;
                }
                RecentBankPlugin.this.configManager.setConfiguration(RecentBankPlugin.CONFIG_GROUP_NAME, "lockToggle", (Object)(!RecentBankPlugin.this.config.lockToggled() ? 1 : 0));
                e.consume();
            }
        }
    };

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener(this.keyListener);
        if (this.configManager.getRSProfileKey() != null) {
            this.load();
        }
        log.info("Recently Banked Items started!");
    }

    private void load() {
        String json = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, RECENT_ID_KEY);
        if (!Strings.isNullOrEmpty((String)json)) {
            this.recentIds.clear();
            this.recentIds.addAll((Collection)this.gson.fromJson(json, new TypeToken<List<Integer>>(){}.getType()));
        }
        if (!Strings.isNullOrEmpty((String)(json = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, LOCKED_ID_KEY)))) {
            this.lockedIds.clear();
            this.lockedIds.addAll((Collection)this.gson.fromJson(json, new TypeToken<List<Integer>>(){}.getType()));
        }
        if (!Strings.isNullOrEmpty((String)(json = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, AMOUNT_MAP_KEY)))) {
            this.bankItemsToAmount.clear();
            this.bankItemsToAmount.putAll((Map)this.gson.fromJson(json, new TypeToken<Map<Integer, Integer>>(){}.getType()));
        }
    }

    protected void shutDown() throws Exception {
        this.save();
        this.reset();
        this.keyManager.unregisterKeyListener(this.keyListener);
        this.clientThread.invokeLater(() -> this.bankSearch.reset(false));
        this.clientThread.invokeLater(this.bankInterface::destroy);
        log.info("Recently Banked Items stopped!");
    }

    public void reset() {
        this.recentIds.clear();
        this.lockedIds.clear();
        this.bankItemsToAmount.clear();
    }

    @Provides
    RecentBankConfig provideConfig(ConfigManager configManager) {
        return (RecentBankConfig)configManager.getConfig(RecentBankConfig.class);
    }

    private void toggleLock() {
        if (this.config.lockToggled()) {
            this.lockedIds.clear();
            this.lockedIds.addAll(this.recentIds);
        }
        this.clientThread.invokeLater(() -> this.bankSearch.layoutBank());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.save();
        }
        if (event.getGameState().equals((Object)GameState.LOGGED_IN) && this.configManager.getRSProfileKey() != null) {
            this.load();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.BANK.getId()) {
            return;
        }
        ItemContainer bank = event.getItemContainer();
        boolean setRecent = !this.bankItemsToAmount.isEmpty();
        boolean refresh = false;
        HashSet<Integer> missing = new HashSet<Integer>(this.bankItemsToAmount.keySet());
        for (Item item : bank.getItems()) {
            int id = this.getItemId(item.getId());
            if (id < 0) continue;
            boolean isPlaceholder = this.itemManager.getItemComposition(item.getId()).getPlaceholderTemplateId() != -1;
            int amount = isPlaceholder ? 0 : item.getQuantity();
            missing.remove(id);
            if (this.bankItemsToAmount.getOrDefault(id, -1) == amount) continue;
            if (setRecent) {
                this.recentIds.remove((Object)id);
                this.recentIds.add(0, id);
                refresh = true;
            }
            this.bankItemsToAmount.put(id, amount);
        }
        Iterator iterator = missing.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.bankItemsToAmount.remove(id);
            this.recentIds.remove((Object)id);
            this.recentIds.add(0, id);
            refresh = true;
        }
        if (refresh && this.config.recentViewToggled()) {
            this.bankSearch.layoutBank();
        }
    }

    private int getItemId(int itemId) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        boolean isPlaceholder = itemComposition.getPlaceholderTemplateId() != -1;
        return isPlaceholder ? itemComposition.getPlaceholderId() : itemComposition.getId();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.CC_OP.getId() || !event.getOption().equals("Show menu") || event.getActionParam1() >> 16 != 12) {
            return;
        }
        this.client.createMenuEntry(1).setOption(this.config.recentViewToggled() ? OFF_RECENT : ON_RECENT).setTarget("").setType(MenuAction.RUNELITE).setIdentifier(event.getIdentifier()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE && event.getParam1() >> 16 == 12 && (event.getMenuOption().equals(ON_RECENT) || event.getMenuOption().equals(OFF_RECENT))) {
            this.configManager.setConfiguration(CONFIG_GROUP_NAME, "viewToggle", (Object)(!this.config.recentViewToggled() ? 1 : 0));
            return;
        }
        if (this.config.recentViewToggled() && event.getParam1() >> 16 == 12 && (event.getMenuOption().equals("View tab") || event.getMenuOption().equals("View all items") || event.getMenuOption().equals("View tag tab"))) {
            this.configManager.setConfiguration(CONFIG_GROUP_NAME, "viewToggle", (Object)false);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("viewToggle".equals(event.getKey())) {
            this.clientThread.invokeLater(this::toggleView);
        }
        if ("lockToggle".equals(event.getKey())) {
            this.toggleLock();
        }
    }

    public void toggleView() {
        if (this.config.recentViewToggled()) {
            this.client.setVarbit(4150, 0);
        } else {
            this.bankInterface.destroy();
        }
        this.bankSearch.layoutBank();
        this.client.runScript(new Object[]{72, WidgetInfo.BANK_SCROLLBAR.getId(), WidgetInfo.BANK_ITEM_CONTAINER.getId(), 0});
    }

    public void updateBankTitle() {
        Widget bankTitle = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
        if (bankTitle != null && this.config.recentViewToggled()) {
            bankTitle.setText("Recent Items" + (this.config.lockToggled() ? " (locked)" : ""));
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 277 || !this.config.recentViewToggled()) {
            return;
        }
        this.updateBankTitle();
        this.bankInterface.destroy();
        this.bankInterface.init();
        Widget itemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (itemContainer == null) {
            return;
        }
        int items = 0;
        Widget[] containerChildren = itemContainer.getDynamicChildren();
        Arrays.sort(containerChildren, Comparator.comparingInt(Widget::getOriginalY).thenComparingInt(Widget::getOriginalX));
        for (Widget child : containerChildren) {
            if (child.getItemId() != -1 && !child.isHidden()) {
                int adjYOffset = items / 8 * 36;
                int adjXOffset = items % 8 * 48 + 51;
                if (child.getOriginalY() != adjYOffset || child.getOriginalX() != adjXOffset) {
                    child.setOriginalY(adjYOffset);
                    child.setOriginalX(adjXOffset);
                    child.revalidate();
                }
                ++items;
            }
            if (child.getSpriteId() != 897 && !child.getText().contains("Tab")) continue;
            child.setHidden(true);
        }
        List<Integer> targetIds = this.config.lockToggled() ? this.lockedIds : this.recentIds;
        for (Widget child : containerChildren) {
            if (child.getItemId() == -1 || child.isHidden() || targetIds.contains(this.getItemId(child.getItemId()))) continue;
            child.setHidden(true);
            child.revalidate();
        }
        items = 0;
        Iterator<Integer> iterator = targetIds.iterator();
        block2: while (iterator.hasNext()) {
            int itemId = (Integer)iterator.next();
            for (Widget child : containerChildren) {
                if (child.isHidden() || this.getItemId(child.getItemId()) != itemId) continue;
                int adjYOffset = items / 8 * 36;
                int adjXOffset = items % 8 * 48 + 51;
                if (child.getOriginalY() != adjYOffset || child.getOriginalX() != adjXOffset) {
                    child.setOriginalY(adjYOffset);
                    child.setOriginalX(adjXOffset);
                    child.revalidate();
                }
                ++items;
                continue block2;
            }
        }
        if (this.client.getVarbitValue(4150) != 0) {
            this.client.setVarbit(4150, 0);
            this.clientThread.invokeLater(() -> this.bankSearch.layoutBank());
        }
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(this::save);
        event.waitFor(future);
    }

    public void save() {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, RECENT_ID_KEY, (Object)this.gson.toJson(this.recentIds));
        if (this.config.lockToggled()) {
            this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, LOCKED_ID_KEY, (Object)this.gson.toJson(this.lockedIds));
        } else {
            this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP_NAME, LOCKED_ID_KEY);
        }
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, AMOUNT_MAP_KEY, (Object)this.gson.toJson(this.bankItemsToAmount));
    }

    public void clearButton() {
        this.recentIds.clear();
        this.lockedIds.clear();
        this.clientThread.invokeLater(() -> this.bankSearch.layoutBank());
    }
}

