/*
 * Decompiled with CFR 0.152.
 */
package com.bank;

import com.bank.RecentBankConfig;
import com.bank.RecentBankPlugin;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class BankInterface {
    private static final String CLEAR_RECENT = "Clear Recent";
    private Widget parent;
    private final RecentBankPlugin plugin;
    private final Client client;
    private final RecentBankConfig config;
    private Widget clearButtonWidget;
    private Widget clearButtonWidgetHover;

    @Inject
    public BankInterface(RecentBankPlugin plugin, Client client, RecentBankConfig config) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public void init() {
        if (this.isHidden()) {
            return;
        }
        this.parent = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (this.parent == null) {
            return;
        }
        int width = this.parent.getOriginalWidth() - 75;
        this.clearButtonWidget = this.createGraphic("", 535, -1, 26, 23, width, 6, true);
        this.clearButtonWidget.setAction(1, CLEAR_RECENT);
        this.clearButtonWidget.setOnMouseOverListener(new Object[]{event -> this.clearButtonWidgetHover.setHidden(false)});
        this.clearButtonWidget.setOnMouseLeaveListener(new Object[]{event -> this.clearButtonWidgetHover.setHidden(true)});
        this.clearButtonWidget.setOnOpListener(new Object[]{event -> this.plugin.clearButton()});
        this.clearButtonWidgetHover = this.createGraphic("", 536, -1, 26, 23, width, 6, false);
        this.clearButtonWidgetHover.setHidden(true);
    }

    public boolean isHidden() {
        Widget widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        return !this.config.recentViewToggled() || widget == null || widget.isHidden();
    }

    public void destroy() {
        this.parent = null;
        if (this.clearButtonWidget != null) {
            this.clearButtonWidget.setHidden(true);
        }
        if (this.clearButtonWidgetHover != null) {
            this.clearButtonWidgetHover.setHidden(true);
        }
    }

    private Widget createGraphic(Widget container, String name, int spriteId, int itemId, int width, int height, int x, int y, boolean hasListener) {
        Widget widget = container.createChild(-1, 5);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setSpriteId(spriteId);
        if (itemId > -1) {
            widget.setItemId(itemId);
            widget.setItemQuantity(-1);
            widget.setBorderType(1);
        }
        if (hasListener) {
            widget.setOnOpListener(new Object[]{10003});
            widget.setHasListener(true);
        }
        widget.setName(name);
        widget.revalidate();
        return widget;
    }

    private Widget createGraphic(String name, int spriteId, int itemId, int width, int height, int x, int y, boolean hasListener) {
        return this.createGraphic(this.parent, name, spriteId, itemId, width, height, x, y, hasListener);
    }

    public Widget getParent() {
        return this.parent;
    }

    public Widget getClearButtonWidget() {
        return this.clearButtonWidget;
    }
}

