/*
 * Decompiled with CFR 0.152.
 */
package com.portaguy;

import com.google.inject.Provides;
import com.portaguy.ThrallHelperConfig;
import com.portaguy.ThrallHelperOverlay;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Thrall Helper")
public class ThrallHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ThrallHelperPlugin.class);
    private static final String RESURRECT_THRALL_MESSAGE_START = ">You resurrect a ";
    private static final String RESURRECT_THRALL_MESSAGE_END = " thrall.</col>";
    private static final String RESURRECT_THRALL_DISAPPEAR_MESSAGE_START = ">Your ";
    private static final String RESURRECT_THRALL_DISAPPEAR_MESSAGE_END = " thrall returns to the grave.</col>";
    private static final String SPELL_TARGET_REGEX = "<col=00ff00>Resurrect (Greater|Superior|Lesser) (Skeleton|Ghost|Zombie)</col>";
    private static final Pattern SPELL_TARGET_PATTERN = Pattern.compile("<col=00ff00>Resurrect (Greater|Superior|Lesser) (Skeleton|Ghost|Zombie)</col>");
    private static final int SPELLBOOK_VARBIT = 4070;
    private static final int ARCEUUS_SPELLBOOK = 3;
    private static final Set<Integer> activeSpellSpriteIds = new HashSet<Integer>(Arrays.asList(2980, 2982, 2984, 2979, 2981, 2983, 1270, 1271, 1300));
    private Instant lastThrallExpiry;
    private boolean isSpellClicked = false;
    private Pattern reminderRegex;
    private Pattern hiderRegex;
    @Inject
    private Notifier notifier;
    @Inject
    private ThrallHelperOverlay overlay;
    @Inject
    private ThrallHelperConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    KeyManager keyManager;
    private final HotkeyListener hideReminderHotkeyListener = new HotkeyListener(() -> this.config.hideReminderHotkey()){

        public void hotkeyPressed() {
            ThrallHelperPlugin.this.overlayManager.remove((Overlay)ThrallHelperPlugin.this.overlay);
            ThrallHelperPlugin.this.lastThrallExpiry = null;
        }
    };

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hideReminderHotkeyListener);
        this.reminderRegex = !this.config.reminderRegex().isEmpty() ? this.compilePattern(this.config.reminderRegex()) : null;
        this.hiderRegex = !this.config.hiderRegex().isEmpty() ? this.compilePattern(this.config.hiderRegex()) : null;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.hideReminderHotkeyListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"thrallhelper".equals(event.getGroup())) {
            return;
        }
        if (event.getKey().equals("reminderRegex")) {
            if (event.getNewValue() != null && !event.getNewValue().isEmpty()) {
                this.reminderRegex = this.compilePattern(event.getNewValue());
                return;
            }
            this.reminderRegex = null;
        }
        if (event.getKey().equals("hiderRegex")) {
            this.hiderRegex = event.getNewValue() != null && !event.getNewValue().isEmpty() ? this.compilePattern(event.getNewValue()) : null;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.lastThrallExpiry != null) {
            Duration thrallOverlayTimeout = Duration.ofSeconds(this.config.thrallTimeoutSeconds());
            Duration sinceThrallExpiry = Duration.between(this.lastThrallExpiry, Instant.now());
            if (sinceThrallExpiry.compareTo(thrallOverlayTimeout) >= 0) {
                this.overlayManager.remove((Overlay)this.overlay);
                this.lastThrallExpiry = null;
            }
        }
        if (this.client.getVarbitValue(4070) != 3 && this.config.onlyArceuus()) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.lastThrallExpiry = null;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher hiderMatcher;
        Matcher reminderMatcher;
        String message = event.getMessage();
        if (this.reminderRegex != null && (!this.config.matchGameMessagesOnly() || event.getType() == ChatMessageType.GAMEMESSAGE) && (reminderMatcher = this.reminderRegex.matcher(message)).matches()) {
            this.overlayManager.add((Overlay)this.overlay);
            this.lastThrallExpiry = Instant.now();
            if (this.config.shouldNotify()) {
                this.notifier.notify("You need to summon a thrall!");
            }
        }
        if (this.hiderRegex != null && (!this.config.matchGameMessagesOnly() || event.getType() == ChatMessageType.GAMEMESSAGE) && (hiderMatcher = this.hiderRegex.matcher(message)).matches()) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.isSpellClicked = false;
        }
        if (message.contains(RESURRECT_THRALL_MESSAGE_START) && message.endsWith(RESURRECT_THRALL_MESSAGE_END)) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.isSpellClicked = false;
        }
        if (message.contains(RESURRECT_THRALL_DISAPPEAR_MESSAGE_START) && message.endsWith(RESURRECT_THRALL_DISAPPEAR_MESSAGE_END) && !this.isSpellClicked) {
            this.overlayManager.add((Overlay)this.overlay);
            this.lastThrallExpiry = Instant.now();
            if (this.config.shouldNotify()) {
                this.notifier.notify("You need to summon a thrall!");
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Matcher matcher = SPELL_TARGET_PATTERN.matcher(event.getMenuTarget());
        if (!matcher.matches()) {
            return;
        }
        if (!this.hasBookOfTheDead()) {
            return;
        }
        Widget widget = event.getWidget();
        if (widget == null) {
            return;
        }
        if (activeSpellSpriteIds.contains(widget.getSpriteId()) && widget.getOpacity() == 0) {
            this.isSpellClicked = true;
        }
    }

    private Pattern compilePattern(String pattern) {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private boolean hasBookOfTheDead() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (inventory == null || equipment == null) {
            return false;
        }
        return inventory.contains(25818) || equipment.contains(25818);
    }

    @Provides
    ThrallHelperConfig provideConfig(ConfigManager configManager) {
        return (ThrallHelperConfig)configManager.getConfig(ThrallHelperConfig.class);
    }
}

