/*
 * Decompiled with CFR 0.152.
 */
package com.tobhmtimer;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class TobTimer {
    private boolean active;
    private int ticksElapsed;
    private LocalDateTime lastElapsedTick;

    public Duration getGameTime() {
        return Duration.ofMillis(600 * this.ticksElapsed);
    }

    public Duration getRealTime() {
        if (this.active && this.lastElapsedTick != null) {
            long millisSinceTick = ChronoUnit.MILLIS.between(this.lastElapsedTick, LocalDateTime.now());
            return this.getGameTime().plus(Duration.ofMillis(millisSinceTick));
        }
        return this.getGameTime();
    }

    public void reset() {
        this.stop();
        this.ticksElapsed = 0;
        this.lastElapsedTick = null;
    }

    public void start() {
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public void tick() {
        if (this.active) {
            ++this.ticksElapsed;
            this.lastElapsedTick = LocalDateTime.now();
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

