/*
 * Decompiled with CFR 0.152.
 */
package com.tobhmtimer;

import com.google.inject.Provides;
import com.tobhmtimer.TobHmTimerConfig;
import com.tobhmtimer.TobHmTimerOverlay;
import com.tobhmtimer.TobTimer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TOB HM Timer")
public class TobHmTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobHmTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TobHmTimerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TobHmTimerOverlay overlay;
    private static final Pattern DIGIT_PATTERN = Pattern.compile("(\\d+)");
    private int tobVarbit = 0;
    private TobTimer timer = new TobTimer();
    private boolean showOverlay = false;
    private boolean raidSucceeded = false;
    private Duration timeToBeat = Duration.ZERO;
    private Duration splitMaiden;
    private Duration splitBloat;
    private Duration splitNylocas;
    private Duration splitSotetseg;
    private Duration splitXarpus;
    private Duration splitVerzik;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.reset();
        this.showOverlay = false;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        if (message.equals("You have left the lobby, so you have been removed from your party.")) {
            this.showOverlay = false;
            return;
        }
        if (message.startsWith("You enter the Theatre of Blood (Hard Mode)")) {
            this.showOverlay = true;
        } else if (message.startsWith("Time to beat:")) {
            Duration time = TobHmTimerPlugin.parseTime(message);
            if (time != null) {
                this.startRaid(time);
            }
            return;
        }
        if (!this.timer.isActive()) {
            return;
        }
        if (message.startsWith("Wave 'The Maiden of Sugadinti' (Hard Mode) complete!")) {
            this.splitMaiden = this.timer.getGameTime();
        } else if (message.startsWith("Wave 'The Pestilent Bloat' (Hard Mode) complete!")) {
            this.splitBloat = this.timer.getGameTime();
        } else if (message.startsWith("Wave 'The Nylocas' (Hard Mode) complete!")) {
            this.splitNylocas = this.timer.getGameTime();
        } else if (message.startsWith("Wave 'Sotetseg' (Hard Mode) complete!")) {
            this.splitSotetseg = this.timer.getGameTime();
        } else if (message.startsWith("Wave 'Xarpus' (Hard Mode) complete!")) {
            this.splitXarpus = this.timer.getGameTime();
        } else if (message.startsWith("Theatre of Blood total completion time:")) {
            this.splitVerzik = this.timer.getGameTime();
            this.completeRaid(true);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.timer.tick();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int nextTobVarBit = this.client.getVarbitValue(6440);
        if (this.tobVarbit != nextTobVarBit) {
            if (nextTobVarBit == 1 && this.timer.isActive()) {
                this.completeRaid(false);
            } else if (nextTobVarBit == 0) {
                this.showOverlay = false;
                this.reset();
            }
            this.tobVarbit = nextTobVarBit;
        }
    }

    @Provides
    TobHmTimerConfig provideConfig(ConfigManager configManager) {
        return (TobHmTimerConfig)configManager.getConfig(TobHmTimerConfig.class);
    }

    private void startRaid(Duration timeToBeat) {
        this.reset();
        this.timeToBeat = timeToBeat;
        this.timer.start();
    }

    private void completeRaid(boolean succeeded) {
        this.timer.stop();
        this.raidSucceeded = succeeded;
    }

    private void reset() {
        this.timer.reset();
        this.timeToBeat = Duration.ZERO;
        this.raidSucceeded = false;
        this.splitMaiden = null;
        this.splitBloat = null;
        this.splitNylocas = null;
        this.splitSotetseg = null;
        this.splitXarpus = null;
        this.splitVerzik = null;
    }

    private static Duration parseTime(String timeString) {
        Matcher digitMatcher = DIGIT_PATTERN.matcher(timeString);
        ArrayList<String> digits = new ArrayList<String>();
        while (digitMatcher.find()) {
            digits.add(digitMatcher.group());
        }
        if (digits.size() == 2) {
            return Duration.ofMinutes(Integer.parseInt((String)digits.get(0))).plus(Duration.ofSeconds(Integer.parseInt((String)digits.get(1))));
        }
        if (digits.size() == 3) {
            return Duration.ofHours(Integer.parseInt((String)digits.get(0))).plus(Duration.ofMinutes(Integer.parseInt((String)digits.get(1)))).plus(Duration.ofSeconds(Integer.parseInt((String)digits.get(2))));
        }
        return null;
    }

    public TobTimer getTimer() {
        return this.timer;
    }

    public boolean isShowOverlay() {
        return this.showOverlay;
    }

    public boolean isRaidSucceeded() {
        return this.raidSucceeded;
    }

    public Duration getTimeToBeat() {
        return this.timeToBeat;
    }

    public Duration getSplitMaiden() {
        return this.splitMaiden;
    }

    public Duration getSplitBloat() {
        return this.splitBloat;
    }

    public Duration getSplitNylocas() {
        return this.splitNylocas;
    }

    public Duration getSplitSotetseg() {
        return this.splitSotetseg;
    }

    public Duration getSplitXarpus() {
        return this.splitXarpus;
    }

    public Duration getSplitVerzik() {
        return this.splitVerzik;
    }
}

