/*
 * Decompiled with CFR 0.152.
 */
package com.tobhmtimer;

import com.tobhmtimer.TobHmTimerConfig;
import com.tobhmtimer.TobHmTimerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

class TobHmTimerOverlay
extends OverlayPanel {
    private final TobHmTimerPlugin plugin;
    private final TobHmTimerConfig config;
    private String longestString;

    @Inject
    private TobHmTimerOverlay(TobHmTimerPlugin plugin, TobHmTimerConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.CANVAS_TOP_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isShowOverlay() && !this.config.alwaysShow()) {
            return null;
        }
        this.longestString = "";
        Duration timeToBeat = this.plugin.getTimeToBeat();
        Duration elapsedTime = this.plugin.getTimer().getRealTime();
        Color timeColor = Color.WHITE;
        if (elapsedTime.compareTo(timeToBeat) >= 0 && !timeToBeat.isZero()) {
            timeColor = Color.RED;
        } else if (!this.plugin.getTimer().isActive() && this.plugin.isRaidSucceeded()) {
            timeColor = Color.GREEN;
        }
        if (this.config.showTimeToBeat()) {
            this.panelComponent.getChildren().add(this.createLineComponent("To beat", timeToBeat));
        }
        if (this.config.showTimeElapsed()) {
            this.panelComponent.getChildren().add(this.createLineComponent("Elapsed", elapsedTime, timeColor));
        }
        if (this.config.showTimeRemaining()) {
            Duration timeRemaining = timeToBeat.minus(elapsedTime);
            this.panelComponent.getChildren().add(this.createLineComponent("Remaining", timeRemaining, timeColor));
        }
        if (this.config.showSplits()) {
            if (this.config.showTimeToBeat() || this.config.showTimeElapsed() || this.config.showTimeRemaining()) {
                this.panelComponent.getChildren().add(LineComponent.builder().build());
            }
            this.panelComponent.getChildren().add(this.createLineComponent("Maiden", this.plugin.getSplitMaiden()));
            this.panelComponent.getChildren().add(this.createLineComponent("Bloat", this.plugin.getSplitBloat()));
            this.panelComponent.getChildren().add(this.createLineComponent("Nylocas", this.plugin.getSplitNylocas()));
            this.panelComponent.getChildren().add(this.createLineComponent("Sotetseg", this.plugin.getSplitSotetseg()));
            this.panelComponent.getChildren().add(this.createLineComponent("Xarpus", this.plugin.getSplitXarpus()));
            this.panelComponent.getChildren().add(this.createLineComponent("Verzik", this.plugin.getSplitVerzik()));
        }
        this.longestString = this.longestString.replaceAll("([0-8]|[ ]|[-])", "9");
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(this.longestString) + 6, 0));
        return super.render(graphics);
    }

    private LineComponent createLineComponent(String description, Duration time) {
        return this.createLineComponent(description, time, Color.WHITE);
    }

    private LineComponent createLineComponent(String description, Duration time, Color color) {
        LineComponent.LineComponentBuilder builder = LineComponent.builder();
        String timeString = TobHmTimerOverlay.createDurationString(time);
        if (this.config.showTimeDescription()) {
            description = " " + (String)description;
            builder.left(timeString).leftColor(color).right((String)description);
            this.setLongestString(timeString + (String)description);
        } else {
            builder.left(timeString).leftColor(color);
            this.setLongestString(timeString);
        }
        return builder.build();
    }

    private void setLongestString(String string) {
        if (this.longestString == null || string.length() > this.longestString.length()) {
            this.longestString = string;
        }
    }

    private static String createDurationString(Duration duration) {
        if (duration == null) {
            return "--:--.-";
        }
        long hours = Math.abs(duration.getSeconds() / 3600L);
        long minutes = Math.abs(duration.getSeconds() % 3600L / 60L);
        long seconds = Math.abs(duration.getSeconds() % 60L);
        long millis = Math.abs(duration.toMillis() - duration.getSeconds() * 1000L) / 100L;
        return (duration.isNegative() ? "-" : "") + (hours > 0L ? String.format("%1d:%02d:%02d.%1d", hours, minutes, seconds, millis) : String.format("%02d:%02d.%1d", minutes, seconds, millis));
    }
}

