/*
 * Decompiled with CFR 0.152.
 */
package com.NpcDialogue.node;

import com.NpcDialogue.node.MetaDialogueNode;
import com.NpcDialogue.node.OptionDialogueNode;
import java.util.ArrayList;
import java.util.List;

public class DialogueNode {
    String content;
    private DialogueNode parent;
    private List<DialogueNode> children = new ArrayList<DialogueNode>();

    public DialogueNode(String content) {
        this.content = content;
    }

    public DialogueNode findOption(String substring) {
        if (this.content.contains(substring)) {
            return this;
        }
        for (DialogueNode child : this.children) {
            DialogueNode downstream = child.findOption(substring);
            if (downstream == null) continue;
            return downstream;
        }
        return null;
    }

    public DialogueNode getParent() {
        return this.parent;
    }

    public void setParent(DialogueNode parent) {
        this.parent = parent;
    }

    public DialogueNode addChild(DialogueNode node) {
        if (node instanceof MetaDialogueNode) {
            if (this.children.size() > 0) {
                DialogueNode lastChild = this.children.get(this.children.size() - 1);
                if (node.content.equals(lastChild.content)) {
                    return lastChild;
                }
            }
        } else {
            if (this.content.equals(node.content)) {
                return this;
            }
            for (DialogueNode n : this.children) {
                if (!n.content.equals(node.content)) continue;
                return n;
            }
        }
        node.setParent(this);
        this.children.add(node);
        return node;
    }

    public List<DialogueNode> getChildren() {
        return this.children;
    }

    private void printDepth(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("*");
        }
    }

    private void printContent(StringBuilder sb) {
        sb.append(this.content);
    }

    public void print(StringBuilder sb, int depth) {
        if (this.content.length() > 0) {
            this.printDepth(sb, depth);
            this.printContent(sb);
            sb.append("\n");
        }
        if (this.children.size() > 0) {
            if (this instanceof OptionDialogueNode) {
                ++depth;
            }
            for (DialogueNode n : this.children) {
                n.print(sb, depth);
            }
            if (this.content.length() > 0 && this instanceof OptionDialogueNode && !(this.children.get(this.children.size() - 1) instanceof MetaDialogueNode)) {
                this.printDepth(sb, depth);
                sb.append("{{tact|end}}\n");
            }
        }
    }
}

