/*
 * Decompiled with CFR 0.152.
 */
package com.NpcDialogue;

import com.NpcDialogue.NpcDialoguePanel;
import com.NpcDialogue.node.DialogueNode;
import com.NpcDialogue.node.MetaDialogueNode;
import com.NpcDialogue.node.NPCDialogueNode;
import com.NpcDialogue.node.OptionDialogueNode;
import com.NpcDialogue.node.PlayerDialogueNode;
import com.NpcDialogue.node.SelectDialogueNode;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="NPC dialogue", description="Utility to make it easier to transcribe NPC dialogue for OSRS Wiki.")
public class NpcDialoguePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private String lastText = null;
    private Widget[] dialogueOptions;
    private NpcDialoguePanel panel;
    private NavigationButton navButton;
    private DialogueNode rootNode;
    private DialogueNode curParentNode = this.rootNode = new DialogueNode("");

    public void startUp() {
        this.panel = (NpcDialoguePanel)((Object)this.injector.getInstance(NpcDialoguePanel.class));
        this.panel.init(this);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"dialogue_icon.png");
        this.navButton = NavigationButton.builder().tooltip("NPC dialogue").icon(icon).priority(100).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        int actionParam;
        if (menuOptionClicked.getMenuAction() == MenuAction.WIDGET_CONTINUE && menuOptionClicked.getMenuOption().equals("Continue") && (actionParam = menuOptionClicked.getActionParam()) > 0 && actionParam < this.dialogueOptions.length) {
            this.curParentNode = this.curParentNode.findOption(this.dialogueOptions[actionParam].getText());
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget doubleSpriteTextWidget;
        Widget msgTextWidget;
        Widget spriteTextWidget;
        Widget playerDialogueOptionsWidget;
        Widget playerDialogueTextWidget;
        Widget npcDialogueTextWidget = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialogueTextWidget != null && !npcDialogueTextWidget.getText().equals(this.lastText)) {
            String npcText;
            this.lastText = npcText = npcDialogueTextWidget.getText();
            String npcName = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME).getText();
            this.curParentNode.addChild(new NPCDialogueNode(npcName, npcText));
            this.printTree();
        }
        if ((playerDialogueTextWidget = this.client.getWidget(WidgetInfo.DIALOG_PLAYER_TEXT)) != null && !playerDialogueTextWidget.getText().equals(this.lastText)) {
            String playerText;
            this.lastText = playerText = playerDialogueTextWidget.getText();
            this.curParentNode.addChild(new PlayerDialogueNode(playerText));
            this.printTree();
        }
        if ((playerDialogueOptionsWidget = this.client.getWidget(219, 1)) != null && playerDialogueOptionsWidget.getChildren() != this.dialogueOptions) {
            int i;
            this.dialogueOptions = playerDialogueOptionsWidget.getChildren();
            boolean loop = false;
            DialogueNode existingSelectNode = this.rootNode.findOption(this.dialogueOptions[0].getText());
            int totalOptions = this.dialogueOptions.length - 1;
            if (existingSelectNode != null) {
                int matchingOptions = 0;
                for (i = 0; i < this.dialogueOptions.length - 1; ++i) {
                    DialogueNode existingOption = existingSelectNode.findOption(this.dialogueOptions[i].getText());
                    if (existingOption == null) continue;
                    ++matchingOptions;
                }
                if (matchingOptions == totalOptions || matchingOptions == totalOptions - 1) {
                    this.curParentNode.addChild(new MetaDialogueNode("{{tact|a previous option menu is displayed}}"));
                    loop = true;
                }
            }
            if (loop) {
                this.curParentNode = existingSelectNode;
            } else {
                DialogueNode selectNode = new SelectDialogueNode(this.dialogueOptions[0].getText());
                selectNode = this.curParentNode.addChild(selectNode);
                this.curParentNode = selectNode;
                for (i = 1; i < this.dialogueOptions.length - 2; ++i) {
                    this.curParentNode.addChild(new OptionDialogueNode(this.dialogueOptions[i].getText()));
                }
            }
            this.printTree();
        }
        if ((spriteTextWidget = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT)) != null && !spriteTextWidget.getText().equals(this.lastText)) {
            String spriteText;
            this.lastText = spriteText = spriteTextWidget.getText();
            Widget spriteWidget = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_SPRITE);
            String itemName = "<!--Error-->";
            int itemid = -1;
            if (spriteWidget != null) {
                itemName = this.client.getItemDefinition(spriteWidget.getItemId()).getName();
                itemid = spriteWidget.getItemId();
            }
            this.curParentNode.addChild(new DialogueNode("{{tbox|<!--id: " + itemid + "-->pic=" + itemName + " detail.png|" + spriteText + "}}"));
            this.printTree();
        }
        if ((msgTextWidget = this.client.getWidget(229, 1)) != null && !msgTextWidget.getText().equals(this.lastText)) {
            String msgText;
            this.lastText = msgText = msgTextWidget.getText();
            this.curParentNode.addChild(new DialogueNode("{{tbox|" + msgText + "}}"));
            this.printTree();
        }
        if ((doubleSpriteTextWidget = this.client.getWidget(11, 2)) != null && !doubleSpriteTextWidget.getText().equals(this.lastText)) {
            String doubleSpriteText;
            this.lastText = doubleSpriteText = doubleSpriteTextWidget.getText();
            Widget widget1 = this.client.getWidget(11, 1);
            Widget widget2 = this.client.getWidget(11, 3);
            String itemName1 = "<!--Error-->";
            String itemName2 = "<!--Error-->";
            int itemid1 = -1;
            int itemid2 = -1;
            if (widget1 != null) {
                itemName1 = this.client.getItemDefinition(widget1.getItemId()).getName();
                itemid1 = widget1.getItemId();
            }
            if (widget2 != null) {
                itemName2 = this.client.getItemDefinition(widget2.getItemId()).getName();
                itemid2 = widget2.getItemId();
            }
            this.curParentNode.addChild(new DialogueNode("{{tbox|<!--id: " + itemid1 + "-->pic=" + itemName1 + " detail.png|<!--id: " + itemid2 + "-->pic2=" + itemName2 + " detail.png|" + doubleSpriteText + "}}"));
            this.printTree();
        }
        if (npcDialogueTextWidget == null && playerDialogueTextWidget == null && playerDialogueOptionsWidget == null && spriteTextWidget == null && msgTextWidget == null && doubleSpriteTextWidget == null && this.lastText != null) {
            this.printTree();
            this.curParentNode = this.rootNode;
            this.lastText = null;
        }
    }

    private void printTree() {
        StringBuilder sb = new StringBuilder();
        this.rootNode.print(sb, 1);
        String playerName = this.client.getLocalPlayer().getName();
        this.panel.setText(sb.toString().replaceAll(playerName, "[player name]"));
    }

    public void reset() {
        this.curParentNode = this.rootNode = new DialogueNode("");
        this.lastText = null;
        this.panel.setText("");
    }
}

