/*
 * Decompiled with CFR 0.152.
 */
package com.NpcDialogue;

import com.NpcDialogue.NpcDialoguePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NpcDialoguePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(NpcDialoguePanel.class);
    private final JTextArea notesEditor = new JTextArea();

    NpcDialoguePanel() {
    }

    void init(NpcDialoguePlugin plugin) {
        this.getParent().setLayout(new BorderLayout());
        this.getParent().add((Component)((Object)this), "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.notesEditor.setTabSize(2);
        this.notesEditor.setLineWrap(true);
        this.notesEditor.setWrapStyleWord(true);
        JPanel notesContainer = new JPanel();
        notesContainer.setLayout(new BorderLayout());
        notesContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.notesEditor.setOpaque(false);
        notesContainer.add((Component)this.notesEditor, "Center");
        notesContainer.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton resetButton = new JButton("RESET");
        resetButton.setSize(250, 25);
        resetButton.addActionListener(ev -> plugin.reset());
        this.add(resetButton, "Center");
        this.add(notesContainer, "Center");
    }

    void appendText(String data) {
        this.notesEditor.append(data.replaceAll("<br>", " ") + "\n");
    }

    void setText(String data) {
        this.notesEditor.setText(data.replaceAll("<br>", " ") + "\n");
    }
}

