/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory.data;

import com.bankmemory.data.BankItem;
import com.bankmemory.data.BankWorldType;
import com.bankmemory.data.SaferUsernameFunction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;

public final class BankSave {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss, d MMM uuuu");
    private static final SaferUsernameFunction SAFER_USERNAME = new SaferUsernameFunction();
    private static final long ID_BASE = System.currentTimeMillis();
    private static final AtomicInteger idIncrementer = new AtomicInteger();
    private static final int NULL_ITEM_ID = -1;
    private final long id = ID_BASE + (long)idIncrementer.incrementAndGet();
    private final BankWorldType worldType;
    private final String dateTimeString;
    private final String userName;
    @Nullable
    private final String saveName;
    private final ImmutableList<BankItem> itemData;

    @VisibleForTesting
    public BankSave(BankWorldType worldType, String userName, @Nullable String saveName, String dateTimeString, ImmutableList<BankItem> itemData) {
        this.worldType = worldType;
        this.userName = userName;
        this.saveName = saveName;
        this.dateTimeString = dateTimeString;
        this.itemData = itemData;
    }

    public BankWorldType getWorldType() {
        return this.worldType == null ? BankWorldType.DEFAULT : this.worldType;
    }

    public static BankSave fromCurrentBank(BankWorldType worldType, String userName, ItemContainer bank, ItemManager itemManager) {
        Objects.requireNonNull(bank);
        Item[] contents = bank.getItems();
        ImmutableList.Builder itemData = ImmutableList.builder();
        for (Item item : contents) {
            int canonId;
            int idInBank = item.getId();
            if (idInBank != (canonId = itemManager.canonicalize(idInBank)) || BankSave.isItemToClean(idInBank)) continue;
            itemData.add((Object)new BankItem(canonId, item.getQuantity()));
        }
        String timeString = DATE_FORMATTER.format(ZonedDateTime.now());
        return new BankSave(worldType, userName, null, timeString, (ImmutableList<BankItem>)itemData.build());
    }

    private static boolean isItemToClean(int itemId) {
        return itemId == -1 || itemId == 20594;
    }

    public static BankSave snapshotFromExistingBank(String newName, BankSave existingBank) {
        Objects.requireNonNull(newName);
        return new BankSave(existingBank.worldType, existingBank.userName, newName, existingBank.dateTimeString, existingBank.itemData);
    }

    public static BankSave cleanItemData(BankSave existingBank) {
        Objects.requireNonNull(existingBank);
        ImmutableList cleanItemData = (ImmutableList)existingBank.itemData.stream().filter(i -> !BankSave.isItemToClean(i.getItemId())).collect(ImmutableList.toImmutableList());
        return new BankSave(existingBank.worldType, existingBank.userName, existingBank.saveName, existingBank.dateTimeString, (ImmutableList<BankItem>)cleanItemData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("username", (Object)SAFER_USERNAME.from(this.userName)).add("dateTimeString", (Object)this.dateTimeString).add("saveName", (Object)this.saveName).add("itemData", this.itemData).toString();
    }

    public long getId() {
        return this.id;
    }

    public String getDateTimeString() {
        return this.dateTimeString;
    }

    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getSaveName() {
        return this.saveName;
    }

    public ImmutableList<BankItem> getItemData() {
        return this.itemData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankSave)) {
            return false;
        }
        BankSave other = (BankSave)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        BankWorldType this$worldType = this.getWorldType();
        BankWorldType other$worldType = other.getWorldType();
        if (this$worldType == null ? other$worldType != null : !((Object)((Object)this$worldType)).equals((Object)other$worldType)) {
            return false;
        }
        String this$dateTimeString = this.getDateTimeString();
        String other$dateTimeString = other.getDateTimeString();
        if (this$dateTimeString == null ? other$dateTimeString != null : !this$dateTimeString.equals(other$dateTimeString)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$saveName = this.getSaveName();
        String other$saveName = other.getSaveName();
        if (this$saveName == null ? other$saveName != null : !this$saveName.equals(other$saveName)) {
            return false;
        }
        ImmutableList<BankItem> this$itemData = this.getItemData();
        ImmutableList<BankItem> other$itemData = other.getItemData();
        return !(this$itemData == null ? other$itemData != null : !this$itemData.equals(other$itemData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        BankWorldType $worldType = this.getWorldType();
        result = result * 59 + ($worldType == null ? 43 : ((Object)((Object)$worldType)).hashCode());
        String $dateTimeString = this.getDateTimeString();
        result = result * 59 + ($dateTimeString == null ? 43 : $dateTimeString.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $saveName = this.getSaveName();
        result = result * 59 + ($saveName == null ? 43 : $saveName.hashCode());
        ImmutableList<BankItem> $itemData = this.getItemData();
        result = result * 59 + ($itemData == null ? 43 : $itemData.hashCode());
        return result;
    }
}

