/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory.bankview;

import java.math.RoundingMode;
import java.text.DecimalFormat;

class ValueFormatter {
    private final DecimalFormat formatter = new DecimalFormat();

    ValueFormatter() {
        this.formatter.setMaximumFractionDigits(2);
        this.formatter.setRoundingMode(RoundingMode.DOWN);
    }

    String format(long value) {
        return this.formatter.format(value);
    }

    String formatAbbreviated(long value) {
        String suffix;
        double divisor;
        long absolute = Math.abs(value);
        if (absolute < 10000L) {
            divisor = 1.0;
            suffix = "";
        } else if (absolute < 1000000L) {
            divisor = 1000.0;
            suffix = "K";
        } else if (absolute < 1000000000L) {
            divisor = 1000000.0;
            suffix = "M";
        } else {
            divisor = 1.0E9;
            suffix = "B";
        }
        StringBuilder str = new StringBuilder();
        String numStr = this.formatter.format((double)value / divisor);
        return str.append(numStr).append(suffix).toString();
    }

    void setShowPositiveSign(boolean show) {
        this.formatter.setPositivePrefix(show ? "+" : "");
    }
}

