/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory.bankview;

import com.bankmemory.bankview.ValueFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

class ValueDisplayPanel
extends JComponent {
    private static final String GE = "GE: ";
    private static final String HA = "HA: ";
    private final ValueFormatter formatter = new ValueFormatter();
    private long geValue;
    private long haValue;
    private boolean styliseForDiffs;

    ValueDisplayPanel() {
    }

    void setValues(long geValue, long haValue) {
        this.geValue = geValue;
        this.haValue = haValue;
        this.updateToolTip();
        this.repaint();
    }

    private void updateToolTip() {
        this.setToolTipText("<html><p> Grand Exchange value: " + this.formatter.format(this.geValue) + "gp</p></br><p>High Alchemy value: " + this.formatter.format(this.haValue) + "gp</p></html>");
    }

    void setStylisedForDiffs(boolean stylise) {
        this.formatter.setShowPositiveSign(stylise);
        this.styliseForDiffs = stylise;
        this.updateToolTip();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets i = this.getInsets();
        Graphics gInset = g.create(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
        Rectangle b = gInset.getClipBounds();
        this.paintValue(gInset.create(0, 0, b.width / 2, b.height), GE, this.geValue);
        this.paintValue(gInset.create(b.width / 2, 0, b.width / 2, b.height), HA, this.haValue);
        gInset.dispose();
    }

    private void paintValue(Graphics g, String name, long value) {
        FontMetrics fm = g.getFontMetrics();
        int fontH = fm.getHeight();
        int nameW = fm.stringWidth(name);
        String numText = this.formatter.formatAbbreviated(value);
        int start = g.getClipBounds().width / 2 - fm.stringWidth(name + numText) / 2;
        g.setColor(this.getForeground());
        g.drawString(name, start, fontH);
        if (this.styliseForDiffs) {
            g.setColor(Color.BLACK);
            g.drawString(numText, start + nameW + 1, fontH + 1);
            g.setColor(value == 0L ? this.getForeground() : (value > 0L ? Color.GREEN : Color.RED));
        }
        g.drawString(numText, start + nameW, fontH);
        g.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D strB = fm.getStringBounds(GE + this.formatter.formatAbbreviated(this.geValue) + " HA: " + this.formatter.formatAbbreviated(this.haValue), g);
        return new Dimension((int)Math.ceil(strB.getWidth()), (int)Math.ceil(strB.getHeight()));
    }
}

