/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory.bankview;

import com.bankmemory.bankview.ItemListEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class FilterableItemListModel
implements ListModel<ItemListEntry> {
    private List<ItemListEntry> rawListContents = new ArrayList<ItemListEntry>();
    private String lcFilterString = "";
    private List<Integer> postFilterIndexes = new ArrayList<Integer>();
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    FilterableItemListModel() {
    }

    public void setListContents(List<ItemListEntry> contents) {
        this.rawListContents = ImmutableList.copyOf(contents);
        this.applyFilterSilently(this.lcFilterString);
        this.fireListeners();
    }

    private static List<Integer> unfilteredIndexList(int numElements) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < numElements; ++i) {
            indexes.add(i);
        }
        return indexes;
    }

    private void fireListeners() {
        ListDataEvent evt = new ListDataEvent(this, 0, 0, this.getSize() - 1);
        this.listeners.forEach(l -> l.contentsChanged(evt));
    }

    public void clearList() {
        this.setListContents(new ArrayList<ItemListEntry>());
    }

    @Override
    public int getSize() {
        return this.postFilterIndexes.size();
    }

    @Override
    public ItemListEntry getElementAt(int index) {
        return this.rawListContents.get(this.postFilterIndexes.get(index));
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void applyFilter(String filterString) {
        List<Integer> oldIndexes = this.postFilterIndexes;
        this.applyFilterSilently(filterString);
        if (!oldIndexes.equals(this.postFilterIndexes)) {
            this.fireListeners();
        }
    }

    private void applyFilterSilently(String filterString) {
        this.lcFilterString = filterString.toLowerCase();
        if (filterString.isEmpty()) {
            this.postFilterIndexes = FilterableItemListModel.unfilteredIndexList(this.rawListContents.size());
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.rawListContents.size(); ++i) {
            if (!this.rawListContents.get(i).getItemName().toLowerCase().contains(this.lcFilterString)) continue;
            indexes.add(i);
        }
        this.postFilterIndexes = indexes;
    }

    public void clearFilter() {
        this.applyFilter("");
    }

    public int getAdjustedIndex(int rawIndex) {
        Preconditions.checkElementIndex((int)rawIndex, (int)this.rawListContents.size());
        return this.postFilterIndexes.indexOf(rawIndex);
    }
}

