/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory.bankview;

import com.bankmemory.bankview.FilterableItemListModel;
import com.bankmemory.bankview.ItemListEntry;
import com.bankmemory.bankview.ItemListRenderer;
import com.bankmemory.bankview.ValueDisplayPanel;
import com.bankmemory.util.OnAnyChangeDocumentListener;
import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;

public class BankViewPanel
extends JPanel {
    private DisplayState state;
    private final JLabel syncTimeLabel;
    private final JPanel northPanel;
    private final IconTextField filterField;
    private final ValueDisplayPanel valueDisplay;
    private final ItemList itemsList;
    private final JScrollPane itemsScrollPane;
    private final PluginErrorPanel errorPanel;

    public BankViewPanel() {
        super(false);
        this.setLayout(new BorderLayout(0, 8));
        this.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        this.northPanel = new JPanel(new BorderLayout(0, 4));
        this.valueDisplay = new ValueDisplayPanel();
        this.northPanel.add((Component)this.valueDisplay, "North");
        this.filterField = new IconTextField();
        this.northPanel.add((Component)this.filterField, "South");
        this.itemsList = new ItemList();
        this.itemsList.setCellRenderer(new ItemListRenderer());
        this.itemsScrollPane = new JScrollPane(this.itemsList);
        this.filterField.setIcon(IconTextField.Icon.SEARCH);
        this.filterField.setPreferredSize(new Dimension(205, 30));
        this.filterField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.filterField.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.filterField.getDocument().addDocumentListener(new OnAnyChangeDocumentListener(){

            @Override
            public void onChange(DocumentEvent e) {
                BankViewPanel.this.itemsScrollPane.getViewport().setViewPosition(new Point(0, 0));
                BankViewPanel.this.itemsList.getModel().applyFilter(BankViewPanel.this.filterField.getText());
            }
        });
        this.syncTimeLabel = new JLabel();
        this.syncTimeLabel.setFont(FontManager.getRunescapeSmallFont());
        this.errorPanel = new PluginErrorPanel();
        this.errorPanel.setContent("Bank Memory", "Log in to a character and open a bank window to populate bank data for that character.");
        this.displayNoDataMessage();
    }

    public void displayNoDataMessage() {
        Preconditions.checkState((boolean)SwingUtilities.isEventDispatchThread());
        this.reset();
        this.add((Component)this.errorPanel, "North");
        this.state = DisplayState.SHOWING_NO_DATA;
        this.repaint();
    }

    public void reset() {
        Preconditions.checkState((boolean)SwingUtilities.isEventDispatchThread());
        this.itemsList.getModel().clearList();
        this.itemsList.getModel().clearFilter();
        this.filterField.setText("");
        this.resetScrolling();
        this.removeAll();
        this.state = DisplayState.RESET;
    }

    private void resetScrolling() {
        this.itemsScrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    public void updateTimeDisplay(String timeString) {
        Preconditions.checkState((boolean)SwingUtilities.isEventDispatchThread());
        this.syncTimeLabel.setText("Data from: " + timeString);
    }

    public void displayItemListings(List<ItemListEntry> items, boolean preserveScrollPos) {
        Preconditions.checkState((boolean)SwingUtilities.isEventDispatchThread());
        this.ensureDisplayIsInItemListState();
        Point scrollPosition = this.itemsScrollPane.getViewport().getViewPosition();
        long geValue = 0L;
        long haValue = 0L;
        for (int i = 0; i < items.size(); ++i) {
            AsyncBufferedImage img = items.get(i).getImage();
            int unfilteredRow = i;
            img.onLoaded(() -> this.repaintItemEntryIfRowVisible(unfilteredRow));
            geValue += (long)items.get(i).getGeValue();
            haValue += (long)items.get(i).getHaValue();
        }
        this.valueDisplay.setValues(geValue, haValue);
        FilterableItemListModel listModel = this.itemsList.getModel();
        listModel.setListContents(items);
        if (preserveScrollPos) {
            this.itemsScrollPane.getViewport().setViewPosition(scrollPosition);
        } else {
            this.itemsScrollPane.getViewport().setViewPosition(new Point(0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void ensureDisplayIsInItemListState() {
        if (this.state == DisplayState.SHOWING_ITEM_LIST) {
            return;
        }
        this.removeAll();
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.itemsScrollPane, "Center");
        this.add((Component)this.syncTimeLabel, "South");
        this.state = DisplayState.SHOWING_ITEM_LIST;
    }

    private void repaintItemEntryIfRowVisible(int unfilteredIndex) {
        int adjustedIndex = this.itemsList.getModel().getAdjustedIndex(unfilteredIndex);
        if (adjustedIndex < 0) {
            return;
        }
        if (this.itemsList.getFirstVisibleIndex() <= unfilteredIndex && unfilteredIndex <= this.itemsList.getLastVisibleIndex()) {
            this.itemsList.repaint(this.itemsList.getCellBounds(adjustedIndex, adjustedIndex));
        }
    }

    public void setItemsListRenderer(ListCellRenderer<ItemListEntry> renderer) {
        this.itemsList.setCellRenderer(renderer);
    }

    public void setStyliseTotalValuesForDiffs(boolean show) {
        this.valueDisplay.setStylisedForDiffs(show);
    }

    public void setItemListPopupMenuAction(Action action) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(action);
        this.itemsList.setComponentPopupMenu(menu);
    }

    private static class ItemList
    extends JList<ItemListEntry> {
        ItemList() {
            super(new FilterableItemListModel());
        }

        @Override
        public void setModel(ListModel<ItemListEntry> model) {
            Preconditions.checkNotNull(model);
            Preconditions.checkArgument((boolean)(model instanceof FilterableItemListModel), (Object)("Incorrect class: " + model.getClass()));
            super.setModel(model);
        }

        public FilterableItemListModel getModel() {
            return (FilterableItemListModel)super.getModel();
        }
    }

    private static enum DisplayState {
        RESET,
        SHOWING_NO_DATA,
        SHOWING_ITEM_LIST;

    }
}

