/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BankSavesTopPanel;
import com.bankmemory.BanksListEntry;
import com.bankmemory.BanksListInteractionListener;
import com.bankmemory.CopyItemsToClipboardAction;
import com.bankmemory.bankview.ItemListEntry;
import com.bankmemory.data.BankItem;
import com.bankmemory.data.BankSave;
import com.bankmemory.data.DataStoreUpdateListener;
import com.bankmemory.data.DisplayNameMapper;
import com.bankmemory.data.PluginDataStore;
import com.bankmemory.util.ClipboardActions;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavedBanksPanelController {
    private static final Logger log = LoggerFactory.getLogger(SavedBanksPanelController.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginDataStore dataStore;
    private BankSavesTopPanel topPanel;
    private ImageIcon casketIcon;
    private ImageIcon notedCasketIcon;
    private final AtomicBoolean workingToOpenBank = new AtomicBoolean();
    private DataStoreListener dataStoreListener;
    @Nullable
    BankSave bankForClipboardAction;

    public void startUp(BankSavesTopPanel topPanel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.topPanel = topPanel;
        topPanel.setBanksListInteractionListener(new BanksListInteractionListenerImpl());
        this.casketIcon = new ImageIcon((Image)this.itemManager.getImage(405));
        this.notedCasketIcon = new ImageIcon((Image)this.itemManager.getImage(406));
        topPanel.displayBanksListPanel();
        this.updateCurrentBanksList();
        this.setPopupMenuActionOnBankView();
        this.dataStoreListener = new DataStoreListener();
        this.dataStore.addListener(this.dataStoreListener);
    }

    private void updateCurrentBanksList() {
        String displayName;
        ArrayList<BanksListEntry> saves = new ArrayList<BanksListEntry>();
        DisplayNameMapper nameMapper = this.dataStore.getDisplayNameMapper();
        for (BankSave save : this.dataStore.getCurrentBanksList()) {
            displayName = nameMapper.map(save.getUserName());
            saves.add(new BanksListEntry(save.getId(), this.casketIcon, save.getWorldType(), "Current bank", displayName, save.getDateTimeString()));
        }
        for (BankSave save : this.dataStore.getSnapshotBanksList()) {
            displayName = nameMapper.map(save.getUserName());
            saves.add(new BanksListEntry(save.getId(), this.notedCasketIcon, save.getWorldType(), save.getSaveName(), displayName, save.getDateTimeString()));
        }
        Runnable updateList = () -> this.topPanel.updateBanksList(saves);
        if (SwingUtilities.isEventDispatchThread()) {
            updateList.run();
        } else {
            SwingUtilities.invokeLater(updateList);
        }
    }

    private void setPopupMenuActionOnBankView() {
        this.topPanel.getBankViewPanel().setItemListPopupMenuAction(new CopyItemsToClipboardAction(this.clientThread, this.itemManager){

            @Override
            @Nullable
            public BankSave getBankItemData() {
                if (SavedBanksPanelController.this.bankForClipboardAction == null) {
                    log.error("Tried to copy CSV data to clipboard before any bank save has been opened");
                }
                return SavedBanksPanelController.this.bankForClipboardAction;
            }
        });
    }

    private void openSavedBank(BanksListEntry selected) {
        assert (this.client.isClientThread());
        Optional<BankSave> save = this.dataStore.getBankSaveWithId(selected.getSaveId());
        if (!save.isPresent()) {
            log.error("Selected missing bank save: {}", (Object)selected);
            this.workingToOpenBank.set(false);
            return;
        }
        BankSave foundSave = save.get();
        ArrayList<ItemListEntry> items = new ArrayList<ItemListEntry>();
        for (BankItem i : foundSave.getItemData()) {
            ItemComposition ic = this.itemManager.getItemComposition(i.getItemId());
            AsyncBufferedImage icon = this.itemManager.getImage(i.getItemId(), i.getQuantity(), i.getQuantity() > 1);
            int geValue = this.itemManager.getItemPrice(i.getItemId()) * i.getQuantity();
            int haValue = ic.getHaPrice() * i.getQuantity();
            items.add(new ItemListEntry(ic.getName(), i.getQuantity(), icon, geValue, haValue));
        }
        SwingUtilities.invokeLater(() -> {
            this.workingToOpenBank.set(false);
            this.bankForClipboardAction = foundSave;
            this.topPanel.displaySavedBankData(selected.getSaveName(), items, foundSave.getDateTimeString());
        });
    }

    public void shutDown() {
        this.dataStore.removeListener(this.dataStoreListener);
    }

    private class DataStoreListener
    implements DataStoreUpdateListener {
        private DataStoreListener() {
        }

        @Override
        public void currentBanksListChanged() {
            SavedBanksPanelController.this.updateCurrentBanksList();
        }

        @Override
        public void snapshotBanksListChanged() {
            SavedBanksPanelController.this.updateCurrentBanksList();
        }

        @Override
        public void displayNameMapUpdated() {
            SavedBanksPanelController.this.updateCurrentBanksList();
        }
    }

    private class BanksListInteractionListenerImpl
    implements BanksListInteractionListener {
        private BanksListInteractionListenerImpl() {
        }

        @Override
        public void selectedToOpen(BanksListEntry save) {
            if (SavedBanksPanelController.this.workingToOpenBank.get()) {
                return;
            }
            SavedBanksPanelController.this.workingToOpenBank.set(true);
            SavedBanksPanelController.this.clientThread.invokeLater(() -> SavedBanksPanelController.this.openSavedBank(save));
        }

        @Override
        public void selectedToDelete(BanksListEntry save) {
            SavedBanksPanelController.this.dataStore.deleteBankSaveWithId(save.getSaveId());
        }

        @Override
        public void saveBankAs(BanksListEntry save, String saveName) {
            Optional<BankSave> existingSave = SavedBanksPanelController.this.dataStore.getBankSaveWithId(save.getSaveId());
            if (existingSave.isPresent()) {
                SavedBanksPanelController.this.dataStore.saveAsSnapshotBank(saveName, existingSave.get());
            } else {
                log.error("Tried to 'Save As' missing bank save: {}", (Object)save);
            }
        }

        @Override
        public void copyBankSaveItemDataToClipboard(BanksListEntry save) {
            Optional<BankSave> existingSave = SavedBanksPanelController.this.dataStore.getBankSaveWithId(save.getSaveId());
            if (existingSave.isPresent()) {
                ClipboardActions.copyItemDataAsTsvToClipboardOnClientThread(SavedBanksPanelController.this.clientThread, SavedBanksPanelController.this.itemManager, existingSave.get().getItemData());
            } else {
                log.error("Tried to copy CSV data to clipboard for missing bank save: {}", (Object)save);
            }
        }

        @Override
        public void openBanksDiffPanel() {
            SavedBanksPanelController.this.topPanel.showBankDiffPanel();
        }
    }
}

