/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.bankview.ItemListEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.LineMetrics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.runelite.client.ui.FontManager;

public class DiffItemListRenderer
extends JLabel
implements ListCellRenderer<ItemListEntry> {
    @Override
    public Component getListCellRendererComponent(JList<? extends ItemListEntry> list, ItemListEntry value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value.getItemName());
        this.setIcon(new IconWithQuantity((Image)value.getImage(), value.getQuantity()));
        return this;
    }

    private static class IconWithQuantity
    extends ImageIcon {
        private static final int LEFT_PAD = 43;
        private final int quantity;

        public IconWithQuantity(Image image, int quantity) {
            super(image);
            this.quantity = quantity;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            Object displayNum;
            Color numColour;
            super.paintIcon(c, g, x + 43, y);
            if (this.quantity < 0) {
                numColour = Color.RED;
                displayNum = Integer.toString(this.quantity);
            } else {
                numColour = Color.GREEN;
                displayNum = "+" + this.quantity;
            }
            Graphics g2 = g.create();
            Font font = FontManager.getRunescapeFont();
            g2.setFont(font);
            LineMetrics lm = font.getLineMetrics((String)displayNum, g2.getFontMetrics().getFontRenderContext());
            int height = (int)Math.ceil(lm.getHeight());
            g2.setColor(Color.BLACK);
            g2.drawString((String)displayNum, 1, height + 1);
            g2.setColor(numColour);
            g2.drawString((String)displayNum, 0, height);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return super.getIconWidth() + 43;
        }
    }
}

