/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.CopyItemsToClipboardAction;
import com.bankmemory.bankview.BankViewPanel;
import com.bankmemory.bankview.ItemListEntry;
import com.bankmemory.data.BankItem;
import com.bankmemory.data.BankSave;
import com.bankmemory.data.BankWorldType;
import com.bankmemory.data.PluginDataStore;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentBankPanelController {
    private static final Logger log = LoggerFactory.getLogger(CurrentBankPanelController.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginDataStore dataStore;
    private BankViewPanel panel;
    @Nullable
    private BankSave latestDisplayedData = null;

    public void startUp(BankViewPanel panel) {
        assert (this.client.isClientThread());
        this.panel = panel;
        SwingUtilities.invokeLater(this::setPopupMenuActionOnBankView);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.updateDisplayForCurrentAccount();
        } else {
            SwingUtilities.invokeLater(panel::displayNoDataMessage);
        }
    }

    private void setPopupMenuActionOnBankView() {
        this.panel.setItemListPopupMenuAction(new CopyItemsToClipboardAction(this.clientThread, this.itemManager){

            @Override
            @Nullable
            public BankSave getBankItemData() {
                if (CurrentBankPanelController.this.latestDisplayedData == null) {
                    log.error("Tried to copy CSV data to clipboard before any current bank shown");
                }
                return CurrentBankPanelController.this.latestDisplayedData;
            }
        });
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        assert (this.client.isClientThread());
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.updateDisplayForCurrentAccount();
    }

    private void updateDisplayForCurrentAccount() {
        BankWorldType worldType = BankWorldType.forWorld(this.client.getWorldType());
        Optional<BankSave> existingSave = this.dataStore.getDataForCurrentBank(worldType, this.client.getUsername());
        if (existingSave.isPresent()) {
            this.handleBankSave(existingSave.get());
        } else {
            this.latestDisplayedData = null;
            SwingUtilities.invokeLater(this.panel::displayNoDataMessage);
        }
    }

    public void handleBankSave(BankSave newSave) {
        assert (this.client.isClientThread());
        this.dataStore.saveAsCurrentBank(newSave);
        boolean shouldReset = this.isBankIdentityDifferentToLastDisplayed(newSave);
        boolean shouldUpdateItemsDisplay = shouldReset || this.isItemDataNew(newSave);
        ArrayList<ItemListEntry> items = new ArrayList<ItemListEntry>();
        if (shouldUpdateItemsDisplay) {
            for (BankItem i : newSave.getItemData()) {
                ItemComposition ic = this.itemManager.getItemComposition(i.getItemId());
                AsyncBufferedImage icon = this.itemManager.getImage(i.getItemId(), i.getQuantity(), i.getQuantity() > 1);
                int geValue = this.itemManager.getItemPrice(i.getItemId()) * i.getQuantity();
                int haValue = ic.getHaPrice() * i.getQuantity();
                items.add(new ItemListEntry(ic.getName(), i.getQuantity(), icon, geValue, haValue));
            }
        }
        SwingUtilities.invokeLater(() -> {
            if (shouldReset) {
                this.panel.reset();
            }
            this.panel.updateTimeDisplay(newSave.getDateTimeString());
            if (shouldUpdateItemsDisplay) {
                this.panel.displayItemListings(items, true);
            }
        });
        this.latestDisplayedData = newSave;
    }

    private boolean isBankIdentityDifferentToLastDisplayed(BankSave newSave) {
        if (this.latestDisplayedData == null) {
            return true;
        }
        boolean userNamesSame = this.latestDisplayedData.getUserName().equalsIgnoreCase(newSave.getUserName());
        boolean worldTypesSame = this.latestDisplayedData.getWorldType() == newSave.getWorldType();
        return !userNamesSame || !worldTypesSame;
    }

    private boolean isItemDataNew(BankSave newSave) {
        return this.latestDisplayedData == null || !this.latestDisplayedData.getItemData().equals(newSave.getItemData());
    }
}

