/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BanksListEntry;
import com.bankmemory.BanksListInteractionListener;
import com.bankmemory.data.BankWorldType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.PluginErrorPanel;

public class BanksListPanel
extends JPanel {
    private static final String DELETE_SAVE = "Delete save...";
    private static final String SAVE_SNAPSHOT = "Save snapshot...";
    private final PluginErrorPanel noDataMessage;
    private final JPanel listPanel;
    private final JPopupMenu bankEntryContextMenu;
    private final ListEntryMouseListener mouseListener = new ListEntryMouseListener();
    private BanksListInteractionListener interactionListener;

    public BanksListPanel() {
        this.bankEntryContextMenu = this.createContextMenu();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        this.noDataMessage = new PluginErrorPanel();
        this.noDataMessage.setContent("No bank saves", "You currently do not have any bank saves.");
        this.add((Component)this.noDataMessage, "North");
        this.listPanel = new JPanel(new GridBagLayout());
        JPanel listWrapper = new JPanel(new BorderLayout());
        listWrapper.add((Component)this.listPanel, "North");
        JScrollPane scrollPane = new JScrollPane(listWrapper);
        this.add((Component)scrollPane, "Center");
        JButton compareBanks = new JButton("Compare bank saves");
        compareBanks.addActionListener(a -> this.interactionListener.openBanksDiffPanel());
        this.add((Component)compareBanks, "South");
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createMenuSaveAsAction(menu));
        menu.add(this.createMenuCopyItemDataToClipboardAction(menu));
        menu.add(this.createMenuDeleteAction(menu));
        return menu;
    }

    private Action createMenuSaveAsAction(final JPopupMenu menu) {
        return new AbstractAction(SAVE_SNAPSHOT){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputName;
                do {
                    if ((inputName = JOptionPane.showInputDialog(BanksListPanel.this, "Enter name for new bank snapshot:", "Save Snapshot As", -1)) != null) continue;
                    return;
                } while ((inputName = inputName.trim()).isEmpty());
                BanksListEntry save = ((EntryPanel)menu.getInvoker()).entry;
                BanksListPanel.this.interactionListener.saveBankAs(save, inputName);
            }
        };
    }

    private Action createMenuCopyItemDataToClipboardAction(final JPopupMenu menu) {
        return new AbstractAction("Copy item data to clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BanksListEntry save = ((EntryPanel)menu.getInvoker()).entry;
                BanksListPanel.this.interactionListener.copyBankSaveItemDataToClipboard(save);
            }
        };
    }

    private Action createMenuDeleteAction(final JPopupMenu menu) {
        return new AbstractAction(DELETE_SAVE){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = "Are you sure you want to delete this save?";
                int result = JOptionPane.showConfirmDialog(BanksListPanel.this, message, "Bank Memory", 0);
                if (result == 0) {
                    BanksListEntry save = ((EntryPanel)menu.getInvoker()).entry;
                    BanksListPanel.this.interactionListener.selectedToDelete(save);
                }
            }
        };
    }

    public void setInteractionListener(BanksListInteractionListener listener) {
        this.interactionListener = listener;
    }

    public void updateBanksList(List<BanksListEntry> entries) {
        this.listPanel.removeAll();
        this.noDataMessage.setVisible(entries.isEmpty());
        if (!entries.isEmpty()) {
            this.displayListOfBanks(entries);
        }
        this.revalidate();
        this.repaint();
    }

    private void displayListOfBanks(List<BanksListEntry> entries) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        for (BanksListEntry entry : entries) {
            JPanel entriesGapPad = new JPanel(new BorderLayout());
            entriesGapPad.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            entriesGapPad.add((Component)new EntryPanel(entry), "North");
            this.listPanel.add((Component)entriesGapPad, c);
            ++c.gridy;
        }
    }

    private class ListEntryMouseListener
    extends MouseAdapter {
        private final Color normalBgColour = ColorScheme.DARKER_GRAY_COLOR;
        private final Color hoverBgColour = ColorScheme.DARKER_GRAY_HOVER_COLOR;

        private ListEntryMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.getComponent().setBackground(this.hoverBgColour);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.getComponent().setBackground(this.normalBgColour);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                BanksListEntry entryClicked = ((EntryPanel)e.getComponent()).entry;
                BanksListPanel.this.interactionListener.selectedToOpen(entryClicked);
                if (!e.getComponent().contains(MouseInfo.getPointerInfo().getLocation())) {
                    this.mouseExited(e);
                }
            }
        }
    }

    private class EntryPanel
    extends JPanel {
        final BanksListEntry entry;

        public EntryPanel(BanksListEntry entry) {
            this.entry = entry;
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText(entry.getDateTime());
            this.setComponentPopupMenu(BanksListPanel.this.bankEntryContextMenu);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.gridheight = 2;
            this.add((Component)new JLabel(entry.getIcon()), c);
            c.fill = 2;
            c.gridx = 1;
            c.weightx = 1.0;
            c.gridheight = 1;
            this.add((Component)new JLabel(entry.getSaveName()), c);
            c.gridy = 1;
            Object subText = entry.getAccountDisplayName();
            if (entry.getWorldType() != BankWorldType.DEFAULT) {
                subText = (String)subText + " (" + entry.getWorldType().getDisplayString() + ")";
            }
            JLabel subLabel = new JLabel((String)subText);
            subLabel.setFont(FontManager.getRunescapeSmallFont());
            this.add((Component)subLabel, c);
            this.addMouseListener(BanksListPanel.this.mouseListener);
        }
    }
}

