/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BankDiffPanel;
import com.bankmemory.BanksListEntry;
import com.bankmemory.BanksListInteractionListener;
import com.bankmemory.BanksListPanel;
import com.bankmemory.bankview.BankViewPanel;
import com.bankmemory.bankview.ItemListEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class BankSavesTopPanel
extends JPanel {
    private static final Icon BACK_ICON;
    private static final Icon BACK_ICON_HOVER;
    private final BanksListPanel banksListPanel = new BanksListPanel();
    private final BankViewPanel bankViewPanel = new BankViewPanel();
    private final BankDiffPanel bankDiffPanel = new BankDiffPanel();
    private final JPanel backButtonAndTitle = new JPanel();
    private final JLabel subUiTitle = new JLabel();

    public BankSavesTopPanel() {
        this.setLayout(new BorderLayout());
        this.backButtonAndTitle.setLayout(new BoxLayout(this.backButtonAndTitle, 2));
        JButton backButton = new JButton(BACK_ICON);
        SwingUtil.removeButtonDecorations((AbstractButton)backButton);
        backButton.setRolloverIcon(BACK_ICON_HOVER);
        backButton.addActionListener(e -> this.displayBanksListPanel());
        this.backButtonAndTitle.add(backButton);
        this.backButtonAndTitle.add(this.subUiTitle);
    }

    void setBanksListInteractionListener(BanksListInteractionListener listener) {
        this.banksListPanel.setInteractionListener(listener);
    }

    void displayBanksListPanel() {
        this.bankViewPanel.reset();
        this.removeAll();
        this.add((Component)this.banksListPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    void updateBanksList(List<BanksListEntry> entries) {
        this.banksListPanel.updateBanksList(entries);
    }

    void displaySavedBankData(String saveName, List<ItemListEntry> items, String timeString) {
        this.removeAll();
        this.subUiTitle.setText(saveName);
        this.add((Component)this.backButtonAndTitle, "North");
        this.add((Component)this.bankViewPanel, "Center");
        this.bankViewPanel.updateTimeDisplay(timeString);
        this.bankViewPanel.displayItemListings(items, false);
        this.revalidate();
        this.repaint();
    }

    public BankViewPanel getBankViewPanel() {
        return this.bankViewPanel;
    }

    public BankDiffPanel getDiffPanel() {
        return this.bankDiffPanel;
    }

    void showBankDiffPanel() {
        this.removeAll();
        this.subUiTitle.setText("Bank comparison");
        this.add((Component)this.backButtonAndTitle, "North");
        this.add((Component)this.bankDiffPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    static {
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(BankSavesTopPanel.class, (String)"back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (int)-100));
    }
}

