/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BankDiffPanelController;
import com.bankmemory.BankMemoryPluginPanel;
import com.bankmemory.CurrentBankPanelController;
import com.bankmemory.SavedBanksPanelController;
import com.bankmemory.bankview.BankViewPanel;
import com.bankmemory.data.BankSave;
import com.bankmemory.data.BankWorldType;
import com.bankmemory.data.PluginDataStore;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Bank Memory", description="A searchable record of what's in your bank")
public class BankMemoryPlugin
extends Plugin {
    private static final String ICON = "bank_memory_icon.png";
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginDataStore dataStore;
    private CurrentBankPanelController currentBankPanelController;
    private SavedBanksPanelController savedBanksPanelController;
    private BankDiffPanelController diffPanelController;
    private NavigationButton navButton;
    private boolean displayNameRegistered = false;

    protected void startUp() throws Exception {
        assert (SwingUtilities.isEventDispatchThread());
        BankMemoryPluginPanel pluginPanel = (BankMemoryPluginPanel)((Object)this.injector.getInstance(BankMemoryPluginPanel.class));
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)ICON);
        this.navButton = NavigationButton.builder().tooltip("Bank Memory").icon(icon).priority(7).panel((PluginPanel)pluginPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.currentBankPanelController = (CurrentBankPanelController)this.injector.getInstance(CurrentBankPanelController.class);
        BankViewPanel currentBankView = pluginPanel.getCurrentBankViewPanel();
        this.clientThread.invokeLater(() -> this.currentBankPanelController.startUp(currentBankView));
        this.savedBanksPanelController = (SavedBanksPanelController)this.injector.getInstance(SavedBanksPanelController.class);
        this.savedBanksPanelController.startUp(pluginPanel.getSavedBanksTopPanel());
        this.diffPanelController = (BankDiffPanelController)this.injector.getInstance(BankDiffPanelController.class);
        this.diffPanelController.startUp(pluginPanel.getSavedBanksTopPanel().getDiffPanel());
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.savedBanksPanelController.shutDown();
        this.diffPanelController.shutDown();
        this.currentBankPanelController = null;
        this.savedBanksPanelController = null;
        this.diffPanelController = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.currentBankPanelController.onGameStateChanged(gameStateChanged);
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.displayNameRegistered = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.displayNameRegistered) {
            String charName;
            Player player = this.client.getLocalPlayer();
            String string = charName = player == null ? null : player.getName();
            if (charName != null) {
                this.displayNameRegistered = true;
                this.dataStore.registerDisplayNameForLogin(this.client.getUsername(), charName);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.BANK.getId()) {
            return;
        }
        BankWorldType worldType = BankWorldType.forWorld(this.client.getWorldType());
        ItemContainer bank = event.getItemContainer();
        this.currentBankPanelController.handleBankSave(BankSave.fromCurrentBank(worldType, this.client.getUsername(), bank, this.itemManager));
    }
}

