/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BankDiffListOption;
import com.bankmemory.BankDiffPanel;
import com.bankmemory.ItemListDiffGenerator;
import com.bankmemory.bankview.ItemListEntry;
import com.bankmemory.data.BankItem;
import com.bankmemory.data.BankSave;
import com.bankmemory.data.DataStoreUpdateListener;
import com.bankmemory.data.DisplayNameMapper;
import com.bankmemory.data.PluginDataStore;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankDiffPanelController {
    private static final Logger log = LoggerFactory.getLogger(BankDiffPanelController.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginDataStore dataStore;
    @Inject
    private ItemListDiffGenerator diffGenerator;
    private BankDiffPanel diffPanel;
    private DataUpdateListener dataListener;
    private BankDiffListOption lastBeforeSelection;
    private BankDiffListOption lastAfterSelection;

    public void startUp(BankDiffPanel diffPanel) {
        this.diffPanel = diffPanel;
        this.dataListener = new DataUpdateListener();
        diffPanel.setInteractionListener(this::userSelectedBankSaves);
        diffPanel.addHierarchyListener(e -> diffPanel.resetSelectionsAndItemList());
        this.dataStore.addListener(this.dataListener);
        this.updateForLatestBankData(true);
    }

    private void updateForLatestBankData(boolean currentBanksChanged) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<BankDiffListOption> currentBanks = new ArrayList<BankDiffListOption>();
        ArrayList<BankDiffListOption> snapshotBanks = new ArrayList<BankDiffListOption>();
        DisplayNameMapper nameMapper = this.dataStore.getDisplayNameMapper();
        for (BankSave save : this.dataStore.getCurrentBanksList()) {
            String displayName = nameMapper.map(save.getUserName());
            currentBanks.add(new BankDiffListOption(displayName, BankDiffListOption.Type.CURRENT, save));
        }
        for (BankSave save : this.dataStore.getSnapshotBanksList()) {
            snapshotBanks.add(new BankDiffListOption(save.getSaveName(), BankDiffListOption.Type.SNAPSHOT, save));
        }
        this.diffPanel.displayBankOptions(currentBanks, snapshotBanks);
        BankDiffListOption equivalentBefore = this.findEquivalent(this.lastBeforeSelection, currentBanks, snapshotBanks);
        BankDiffListOption equivalentAfter = this.findEquivalent(this.lastAfterSelection, currentBanks, snapshotBanks);
        if (equivalentBefore != null && equivalentAfter != null) {
            this.diffPanel.setSelections(equivalentBefore, equivalentAfter);
            if (currentBanksChanged && (equivalentBefore.getBankType() == BankDiffListOption.Type.CURRENT || equivalentAfter.getBankType() == BankDiffListOption.Type.CURRENT)) {
                this.displayDiffOfSaves(equivalentBefore, equivalentAfter, true);
            }
        }
    }

    private BankDiffListOption findEquivalent(BankDiffListOption old, List<BankDiffListOption> currentBanks, List<BankDiffListOption> snapshots) {
        if (old == null) {
            return null;
        }
        switch (old.getBankType()) {
            case CURRENT: {
                return currentBanks.stream().filter(b -> old.getSave().getUserName().equalsIgnoreCase(b.getSave().getUserName())).findAny().orElse(null);
            }
            case SNAPSHOT: {
                return snapshots.stream().filter(b -> old.getSave().getId() == b.getSave().getId()).findAny().orElse(null);
            }
        }
        throw new AssertionError();
    }

    private void userSelectedBankSaves(BankDiffListOption before, BankDiffListOption after) {
        assert (SwingUtilities.isEventDispatchThread());
        this.lastBeforeSelection = before;
        this.lastAfterSelection = after;
        this.displayDiffOfSaves(before, after, false);
    }

    private void displayDiffOfSaves(BankDiffListOption before, BankDiffListOption after, boolean keepListPosition) {
        assert (SwingUtilities.isEventDispatchThread());
        List<BankItem> differences = this.diffGenerator.findDifferencesBetween((List<BankItem>)before.getSave().getItemData(), (List<BankItem>)after.getSave().getItemData());
        this.clientThread.invokeLater(() -> this.gatherItemDataToDisplay(differences, keepListPosition));
    }

    private void gatherItemDataToDisplay(List<BankItem> differences, boolean keepListPosition) {
        assert (this.client.isClientThread());
        ArrayList<ItemListEntry> items = new ArrayList<ItemListEntry>();
        for (BankItem i : differences) {
            ItemComposition ic = this.itemManager.getItemComposition(i.getItemId());
            AsyncBufferedImage icon = this.itemManager.getImage(i.getItemId(), i.getQuantity(), false);
            int geValue = this.itemManager.getItemPrice(i.getItemId()) * i.getQuantity();
            int haValue = ic.getHaPrice() * i.getQuantity();
            items.add(new ItemListEntry(ic.getName(), i.getQuantity(), icon, geValue, haValue));
        }
        SwingUtilities.invokeLater(() -> this.diffPanel.displayItems(items, keepListPosition));
    }

    public void shutDown() {
        this.dataStore.removeListener(this.dataListener);
        this.lastBeforeSelection = null;
        this.lastAfterSelection = null;
    }

    private class DataUpdateListener
    implements DataStoreUpdateListener {
        private DataUpdateListener() {
        }

        @Override
        public void currentBanksListChanged() {
            SwingUtilities.invokeLater(() -> BankDiffPanelController.this.updateForLatestBankData(true));
        }

        @Override
        public void snapshotBanksListChanged() {
            SwingUtilities.invokeLater(() -> BankDiffPanelController.this.updateForLatestBankData(false));
        }

        @Override
        public void displayNameMapUpdated() {
            SwingUtilities.invokeLater(() -> BankDiffPanelController.this.updateForLatestBankData(false));
        }
    }
}

