/*
 * Decompiled with CFR 0.152.
 */
package com.bankmemory;

import com.bankmemory.BankDiffListOption;
import com.bankmemory.BankDiffPanelInteractionListener;
import com.bankmemory.DiffItemListRenderer;
import com.bankmemory.bankview.BankViewPanel;
import com.bankmemory.bankview.ItemListEntry;
import com.bankmemory.data.BankWorldType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class BankDiffPanel
extends JPanel {
    private static final Icon REVERSE_ICON;
    private static final Icon REVERSE_ICON_HOVER;
    private static final String CURRENT_BANKS = "- Current banks -";
    private static final String SNAPSHOT_BANKS = "- Snapshots -";
    private final BankViewPanel itemsList = new BankViewPanel();
    private final OptionsListModel beforeOptionsModel = new OptionsListModel();
    private final OptionsListModel afterOptionsModel = new OptionsListModel();
    private BankDiffPanelInteractionListener interactionListener;
    private boolean disableSelectionListener = false;

    BankDiffPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.itemsList, "Center");
        this.itemsList.setItemsListRenderer(new DiffItemListRenderer());
        this.itemsList.setStyliseTotalValuesForDiffs(true);
        this.itemsList.reset();
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        topPanel.add((Component)new JLabel("Before"), c);
        c.gridy = 1;
        topPanel.add((Component)new JLabel("After"), c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        topPanel.add(this.createComboBox(this.beforeOptionsModel), c);
        c.gridy = 1;
        topPanel.add(this.createComboBox(this.afterOptionsModel), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 2;
        JButton reverseButton = new JButton(REVERSE_ICON);
        reverseButton.setRolloverIcon(REVERSE_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)reverseButton);
        reverseButton.addActionListener(a -> this.reverseBankChoices());
        topPanel.add((Component)reverseButton, c);
        this.add((Component)topPanel, "North");
    }

    private JComboBox<Object> createComboBox(OptionsListModel listModel) {
        JComboBox<Object> comboBox = new JComboBox<Object>(listModel);
        comboBox.setRenderer(new OptionsListRenderer());
        comboBox.addActionListener(a -> this.comboBoxSelectionChanged());
        return comboBox;
    }

    void setInteractionListener(BankDiffPanelInteractionListener listener) {
        this.interactionListener = listener;
    }

    private void comboBoxSelectionChanged() {
        if (this.disableSelectionListener) {
            return;
        }
        BankDiffListOption before = this.beforeOptionsModel.getSelectedItem();
        BankDiffListOption after = this.afterOptionsModel.getSelectedItem();
        if (before != null && after != null) {
            this.interactionListener.userSelectedSavesToDiff(before, after);
        }
    }

    private void reverseBankChoices() {
        this.disableSelectionListener = true;
        BankDiffListOption swap = this.beforeOptionsModel.getSelectedItem();
        this.beforeOptionsModel.setSelectedItem(this.afterOptionsModel.getSelectedItem());
        this.afterOptionsModel.setSelectedItem(swap);
        this.disableSelectionListener = false;
        this.comboBoxSelectionChanged();
    }

    void displayBankOptions(List<BankDiffListOption> currentBanks, List<BankDiffListOption> snapshotBanks) {
        ArrayList<Object> options = new ArrayList<Object>();
        if (!currentBanks.isEmpty()) {
            options.add(CURRENT_BANKS);
            options.addAll(this.listWithWorldSeparators(currentBanks));
        }
        if (!snapshotBanks.isEmpty()) {
            options.add(SNAPSHOT_BANKS);
            options.addAll(this.listWithWorldSeparators(snapshotBanks));
        }
        this.disableSelectionListener = true;
        this.beforeOptionsModel.removeAllElements();
        this.afterOptionsModel.removeAllElements();
        options.forEach(o -> {
            this.beforeOptionsModel.addElement(o);
            this.afterOptionsModel.addElement(o);
        });
        this.disableSelectionListener = false;
    }

    private List<Object> listWithWorldSeparators(List<BankDiffListOption> options) {
        ArrayListMultimap optionsByWorldType = ArrayListMultimap.create();
        options.forEach(arg_0 -> BankDiffPanel.lambda$listWithWorldSeparators$3((ListMultimap)optionsByWorldType, arg_0));
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (BankWorldType type : BankWorldType.values()) {
            if (!optionsByWorldType.containsKey((Object)type)) continue;
            if (type != BankWorldType.DEFAULT) {
                resultList.add(type.getDisplayString());
            }
            resultList.addAll(optionsByWorldType.get((Object)type));
        }
        return resultList;
    }

    void setSelections(BankDiffListOption before, BankDiffListOption after) {
        this.disableSelectionListener = true;
        this.beforeOptionsModel.setSelectedItem(before);
        this.afterOptionsModel.setSelectedItem(after);
        this.disableSelectionListener = false;
    }

    void displayItems(List<ItemListEntry> items, boolean keepListPosition) {
        this.itemsList.displayItemListings(items, keepListPosition);
    }

    public void resetSelectionsAndItemList() {
        this.beforeOptionsModel.setSelectedItem(null);
        this.afterOptionsModel.setSelectedItem(null);
        this.itemsList.reset();
        this.revalidate();
        this.repaint();
    }

    private static /* synthetic */ void lambda$listWithWorldSeparators$3(ListMultimap optionsByWorldType, BankDiffListOption o) {
        optionsByWorldType.put((Object)o.getSave().getWorldType(), (Object)o);
    }

    static {
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(BankDiffPanel.class, (String)"reverse_icon.png");
        REVERSE_ICON = new ImageIcon(backIcon);
        REVERSE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (int)-100));
    }

    private static class OptionsListRenderer
    implements ListCellRenderer<Object> {
        private final ComboBoxListRenderer wrapped = new ComboBoxListRenderer();

        private OptionsListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object valToRender;
            Object object = valToRender = value == null ? "" : value;
            if (value instanceof BankDiffListOption) {
                valToRender = ((BankDiffListOption)value).getListText();
            }
            Component comp = this.wrapped.getListCellRendererComponent(list, valToRender, index, isSelected, cellHasFocus);
            Font font = FontManager.getRunescapeFont();
            Color fgColour = comp.getForeground();
            if (!(value instanceof BankDiffListOption)) {
                font = value == BankDiffPanel.CURRENT_BANKS || value == BankDiffPanel.SNAPSHOT_BANKS ? FontManager.getRunescapeBoldFont() : FontManager.getRunescapeSmallFont().deriveFont(2);
                fgColour = ColorScheme.BRAND_ORANGE;
            }
            comp.setFont(font);
            comp.setForeground(fgColour);
            return comp;
        }
    }

    private static class OptionsListModel
    extends DefaultComboBoxModel<Object> {
        private OptionsListModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof BankDiffListOption || anObject == null) {
                super.setSelectedItem(anObject);
            }
        }

        @Override
        public BankDiffListOption getSelectedItem() {
            Object selected = super.getSelectedItem();
            return selected instanceof BankDiffListOption ? (BankDiffListOption)selected : null;
        }
    }
}

