/*
 * Decompiled with CFR 0.152.
 */
package mmdts.trackhealers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.inject.Inject;
import mmdts.trackhealers.Role;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Track Healers", description="Just a quick plugin to track healers.", tags={"minigame", "tick", "logger", "tracker", "healer"})
public class TrackHealersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TrackHealersPlugin.class);
    private static final int BA_WAVE_NUM_INDEX = 2;
    @Inject
    private Client client;
    private String currentWave = "0";
    private long waveTickCount = 0L;
    private boolean inWave = false;
    private char role = '\u0000';
    private PrintWriter out;
    private BufferedWriter bw;
    private FileWriter fw;

    protected void startUp() throws Exception {
        File logFile = new File(RuneLite.LOGS_DIR, "track_healers.log");
        this.fw = new FileWriter(logFile, true);
        this.bw = new BufferedWriter(this.fw);
        this.out = new PrintWriter(this.bw);
    }

    protected void shutDown() throws Exception {
        this.shutDownActions();
        this.out.close();
        this.bw.close();
        this.fw.close();
    }

    private void shutDownActions() throws IOException {
        this.out.flush();
        this.bw.flush();
        this.fw.flush();
        this.currentWave = "0";
        this.waveTickCount = 0L;
        this.inWave = false;
        this.role = '\u0000';
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 485: {
                this.role = (char)97;
                break;
            }
            case 487: {
                this.role = (char)100;
                break;
            }
            case 488: {
                this.role = (char)104;
                break;
            }
            case 486: {
                this.role = (char)99;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) throws IOException {
        NPC[] npcs;
        Player[] players;
        if (!this.inWave || this.role != 'h' && this.role != 'd') {
            return;
        }
        if (!this.client.isInInstancedRegion()) {
            this.shutDownActions();
        }
        ++this.waveTickCount;
        StringBuilder str = new StringBuilder();
        str.append(this.currentWave).append(",").append(this.waveTickCount).append("|");
        for (Player player : players = this.client.getCachedPlayers()) {
            if (player == null) continue;
            WorldPoint loc = player.getWorldLocation();
            if (player.getWorldLocation() == null) continue;
            char playerRole = Role.getRoleFromJawId(player.getPlayerComposition().getEquipmentId(KitType.JAW));
            if (playerRole == '\u0000') {
                this.shutDownActions();
            }
            str.append("|").append(playerRole).append(",").append(Long.toString(loc.getRegionX())).append(",").append(Long.toString(loc.getRegionY()));
        }
        str.append("|");
        for (NPC npc : npcs = this.client.getCachedNPCs()) {
            if (npc == null || !Objects.equals(npc.getName(), "Penance Healer") || npc.getWorldLocation() == null) continue;
            WorldPoint loc = npc.getWorldLocation();
            Actor interacting = npc.getInteracting();
            char firstText = '_';
            str.append("|").append(npc.getIndex()).append(",").append(Long.toString(loc.getRegionX())).append(",").append(Long.toString(loc.getRegionY()));
            if (interacting instanceof Player) {
                firstText = Role.getRoleFromJawId(((Player)interacting).getPlayerComposition().getEquipmentId(KitType.JAW));
                loc = interacting.getWorldLocation();
            }
            if (interacting instanceof NPC) {
                firstText = 'r';
                loc = interacting.getWorldLocation();
            }
            str.append(">").append(firstText);
            if (firstText != '_') {
                str.append(",").append(Long.toString(loc.getRegionX())).append(",").append(Long.toString(loc.getRegionY()));
                continue;
            }
            str.append(",_,_");
        }
        this.out.println(str);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getMessage().startsWith("---- Wave:")) {
            this.currentWave = event.getMessage().split(" ")[2];
            this.inWave = true;
            this.waveTickCount = 0L;
        }
    }
}

