/*
 * Decompiled with CFR 0.152.
 */
package com.QSRAutoSplitter;

import com.QSRAutoSplitter.Pair;
import com.QSRAutoSplitter.QSRAutoSplitterConfig;
import com.QSRAutoSplitter.QSRAutoSplitterPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="QSR Auto Splitter", description="Sends split signals through LiveSplit server to automatically track splits for quest speedruns")
public class QSRAutoSplitterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(QSRAutoSplitterPlugin.class);
    private static final Logger logger = LoggerFactory.getLogger(QSRAutoSplitterPlugin.class);
    private int questsComplete;
    private int ticks;
    PrintWriter writer;
    BufferedReader reader;
    @Inject
    private Client client;
    @Inject
    private QSRAutoSplitterConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private QSRAutoSplitterPanel panel;
    private boolean started = false;
    private boolean paused = false;
    private List<Pair<Integer, Integer>> itemList;
    private List<Pair<Integer, Integer>> varbList;
    private List<Pair<Integer, Integer>> varpList;

    @Provides
    QSRAutoSplitterConfig provideConfig(ConfigManager configManager) {
        return (QSRAutoSplitterConfig)configManager.getConfig(QSRAutoSplitterConfig.class);
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/qsr_auto_splitter_icon.png");
        this.panel = new QSRAutoSplitterPanel(this.client, this.writer, this.reader, this.config, this);
        this.navButton = NavigationButton.builder().tooltip("Quest Speedrunning Auto Splitter").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.itemList = new ArrayList<Pair<Integer, Integer>>();
        this.varbList = new ArrayList<Pair<Integer, Integer>>();
        this.varpList = new ArrayList<Pair<Integer, Integer>>();
        this.panel.startPanel();
    }

    protected void shutDown() {
        this.sendMessage("pause");
        this.itemList = null;
        this.varbList = null;
        this.varpList = null;
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel.disconnect();
    }

    private void setupSplits(String configStr) {
        String[] configList;
        this.itemList = new ArrayList<Pair<Integer, Integer>>();
        this.varbList = new ArrayList<Pair<Integer, Integer>>();
        this.varpList = new ArrayList<Pair<Integer, Integer>>();
        for (String line : configList = configStr.split("\n")) {
            String[] args = line.split(",");
            try {
                Pair<Integer, Integer> pair;
                int type = Integer.parseInt(args[1]);
                if (type == 0) {
                    pair = args.length < 4 ? new Pair<Integer, Integer>(Integer.parseInt(args[2]), 1) : new Pair<Integer, Integer>(Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                    this.itemList.add(pair);
                    continue;
                }
                if (type == 1) {
                    pair = new Pair<Integer, Integer>(Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                    this.varbList.add(pair);
                    continue;
                }
                if (type == 2) {
                    pair = new Pair<Integer, Integer>(Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                    this.varpList.add(pair);
                    continue;
                }
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "QSR: could not parse line: " + line, null);
            }
            catch (Exception e) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "QSR: could not parse line: " + line, null);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.started && this.isInSpeedrun()) {
            String configStr;
            this.started = true;
            this.sendMessage("reset");
            this.sendMessage("initgametime");
            this.sendMessage("starttimer");
            this.questsComplete = this.client.getVarbitValue(6347);
            int currQuest = this.client.getVarbitValue(13627);
            switch (currQuest) {
                case 1: {
                    configStr = this.config.caList();
                    break;
                }
                case 2: {
                    configStr = this.config.dsList();
                    break;
                }
                case 7: {
                    configStr = this.config.etcList();
                    break;
                }
                case 10: {
                    configStr = this.config.parList();
                    break;
                }
                case 12: {
                    configStr = this.config.bkfList();
                    break;
                }
                case 8: {
                    configStr = this.config.vsList();
                    break;
                }
                case 17: {
                    configStr = this.config.dsiList();
                    break;
                }
                case 148: {
                    configStr = this.config.dsiiList();
                    break;
                }
                case 150: {
                    configStr = this.config.tohList();
                    break;
                }
                case 154: {
                    configStr = this.config.xmsList();
                    break;
                }
                case 158: {
                    configStr = this.config.sotfList();
                    break;
                }
                case 162: {
                    configStr = this.config.bimList();
                    break;
                }
                case 164: {
                    configStr = this.config.akdList();
                    break;
                }
                case 168: {
                    configStr = this.config.toeList();
                    break;
                }
                case 169: {
                    configStr = this.config.bcsList();
                    break;
                }
                default: {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "QSR: quest not found; plugin needs to be updated", null);
                    configStr = "";
                }
            }
            this.setupSplits(configStr);
        } else if (this.started && !this.isInSpeedrun()) {
            this.started = false;
            this.sendMessage("getcurrenttimerphase");
            switch (this.receiveMessage()) {
                case "Running": {
                    this.sendMessage("pause");
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        ScriptEvent scriptEvent = event.getScriptEvent();
        if (scriptEvent == null || scriptEvent.getSource() != null) {
            return;
        }
        Object[] arguments = scriptEvent.getArguments();
        int scriptId = (Integer)arguments[0];
        if (scriptId == 5879) {
            this.ticks = (Integer)arguments[1];
            this.sendMessage("setgametime " + (double)this.ticks * 0.6);
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (this.started) {
            if (event.getGameState() == GameState.LOADING || event.getGameState() == GameState.LOGGED_IN || event.getGameState() == GameState.CONNECTION_LOST) {
                if (this.paused) {
                    this.sendMessage("resume");
                    this.paused = false;
                }
            } else if (!this.paused) {
                this.sendMessage("pause");
                this.paused = true;
            }
        }
    }

    public void completeRun() {
        this.started = false;
        this.sendMessage("getcurrenttimerphase");
        String msg = this.receiveMessage();
        while (!msg.equals("ERROR")) {
            switch (msg) {
                case "Running": {
                    this.sendMessage("getsplitindex");
                    String i = this.receiveMessage();
                    this.sendMessage("skipsplit");
                    this.sendMessage("getsplitindex");
                    String j = this.receiveMessage();
                    if (!i.equals(j)) break;
                    this.split();
                    return;
                }
                case "Paused": {
                    this.sendMessage("resume");
                    break;
                }
                case "Ended": {
                    this.sendMessage("unsplit");
                    break;
                }
                case "NotRunning": {
                    return;
                }
            }
            this.sendMessage("getcurrenttimerphase");
            msg = this.receiveMessage();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer itemContainer = event.getItemContainer();
        if (itemContainer != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        for (Pair<Integer, Integer> pair : this.itemList) {
            if (itemContainer.count(((Integer)pair.first).intValue()) < (Integer)pair.second) continue;
            this.split();
            this.itemList.remove(pair);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.started && this.client.getVarbitValue(6347) > this.questsComplete) {
            this.completeRun();
        }
        for (Pair<Integer, Integer> pair : this.varbList) {
            if (this.client.getVarbitValue(((Integer)pair.first).intValue()) != ((Integer)pair.second).intValue()) continue;
            this.split();
            this.varbList.remove(pair);
        }
        for (Pair<Integer, Integer> pair : this.varpList) {
            if (this.client.getVarpValue(((Integer)pair.first).intValue()) != ((Integer)pair.second).intValue()) continue;
            this.split();
            this.varpList.remove(pair);
        }
    }

    public boolean isInSpeedrun() {
        return this.client.getVarbitValue(12395) == 5;
    }

    private void sendMessage(String message) {
        if (this.writer != null) {
            this.writer.write(message + "\r\n");
            this.writer.flush();
        }
    }

    private String receiveMessage() {
        if (this.reader != null) {
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                return "ERROR";
            }
        }
        return "ERROR";
    }

    public void split() {
        this.sendMessage("pausegametime");
        this.sendMessage("setgametime " + BigDecimal.valueOf((double)(this.ticks + 1) * 0.6).setScale(1, RoundingMode.HALF_UP));
        this.sendMessage("split");
        this.sendMessage("unpausegametime");
    }
}

