/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.monkeybusiness;

import com.google.inject.Provides;
import com.krazune.monkeybusiness.BusinessManager;
import com.krazune.monkeybusiness.MonkeyBusinessPluginConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Monkey Business", description="This plugin lets you do your monkey business, when wielding a cursed banana.", tags={"monkey", "business", "cursed", "banana", "poop"})
public class MonkeyBusinessPlugin
extends Plugin {
    private final int CURSED_BANANA_ID = 25500;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BusinessManager businessManager;
    private Queue<WorldPoint> worldPointsQueue;
    private int worldPointsToBeProcessedNext = 0;

    @Subscribe
    public void onGameTick(GameTick tick) {
        List players = this.client.getPlayers();
        this.processWorldPointsQueue();
        for (int i = 0; i < players.size(); ++i) {
            Player currentPlayer = (Player)players.get(i);
            if (!this.playerHasCursedBanana(currentPlayer)) continue;
            this.worldPointsQueue.add(currentPlayer.getWorldLocation());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState newState = gameStateChanged.getGameState();
        if (newState != GameState.LOGIN_SCREEN && newState != GameState.HOPPING) {
            return;
        }
        this.businessManager.clearAll();
        this.worldPointsQueue.clear();
    }

    protected void startUp() {
        this.worldPointsQueue = new LinkedList<WorldPoint>();
    }

    protected void shutDown() {
        this.worldPointsQueue = null;
        this.businessManager.clearAll();
    }

    @Provides
    MonkeyBusinessPluginConfig provideConfig(ConfigManager configManager) {
        return (MonkeyBusinessPluginConfig)configManager.getConfig(MonkeyBusinessPluginConfig.class);
    }

    private boolean playerHasCursedBanana(Player player) {
        if (player == null) {
            return false;
        }
        PlayerComposition playerComposition = player.getPlayerComposition();
        if (playerComposition == null) {
            return false;
        }
        return playerComposition.getEquipmentId(KitType.WEAPON) == 25500;
    }

    private void processWorldPointsQueue() {
        if (this.worldPointsQueue.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.worldPointsToBeProcessedNext; ++i) {
            this.businessManager.doBusiness(this.worldPointsQueue.remove());
        }
        this.worldPointsToBeProcessedNext = this.worldPointsQueue.size();
    }
}

