/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.monkeybusiness;

import com.krazune.monkeybusiness.Business;
import com.krazune.monkeybusiness.BusinessType;
import com.krazune.monkeybusiness.MonkeyBusinessPluginConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

public class BusinessManager {
    private final Client client;
    private final ClientThread clientThread;
    private final EventBus eventBus;
    private final MonkeyBusinessPluginConfig config;
    private final Duration BUSINESS_DURATION = Duration.ofMinutes(1L);
    private Map<WorldPoint, Business> businessLocations;
    private Map<Business, Instant> businessSpawnInstants;

    @Inject
    public BusinessManager(Client client, ClientThread clientThread, EventBus eventBus, MonkeyBusinessPluginConfig config) {
        this.client = client;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.config = config;
        this.eventBus.register((Object)this);
        this.businessLocations = new HashMap<WorldPoint, Business>();
        this.businessSpawnInstants = new HashMap<Business, Instant>();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.removeOldBusiness();
    }

    public void doBusiness(WorldPoint worldPoint) {
        Business existentBusiness = this.businessLocations.get(worldPoint);
        if (existentBusiness != null) {
            this.addBusinessInstant(existentBusiness);
            return;
        }
        Business newBusiness = this.createRandomBusiness(worldPoint);
        if (newBusiness == null) {
            return;
        }
        newBusiness.setActive(true);
        this.businessLocations.put(newBusiness.getLocation(), newBusiness);
        this.addBusinessInstant(newBusiness);
    }

    public void activateAll() {
        for (Business business : this.businessLocations.values()) {
            business.setActive(true);
        }
    }

    public void deactivateAll() {
        for (Business business : this.businessLocations.values()) {
            business.setActive(false);
        }
    }

    public void clearAll() {
        this.deactivateAll();
        this.businessLocations = new HashMap<WorldPoint, Business>();
        this.businessSpawnInstants = new HashMap<Business, Instant>();
    }

    private Business createRandomBusiness(WorldPoint worldPoint) {
        BusinessType newBusinessType = this.getRandomBusinessTypeOrNull(worldPoint);
        if (newBusinessType == null) {
            if (!this.config.continuousBusiness()) {
                return null;
            }
            newBusinessType = BusinessType.FLOOR_MARKS;
        }
        return new Business(this.client, this.clientThread, this.eventBus, worldPoint, newBusinessType);
    }

    private BusinessType getRandomBusinessTypeOrNull(WorldPoint worldPoint) {
        Random random = new Random(this.getRandomSeed(worldPoint));
        int continueRandom = random.nextInt(3);
        if (continueRandom != 0) {
            return null;
        }
        int businessTypeRandom = random.nextInt(100);
        if (businessTypeRandom == 0) {
            return BusinessType.GIGANTIC_PILE;
        }
        if (businessTypeRandom <= 15) {
            return BusinessType.SMALL_PILE;
        }
        if (businessTypeRandom <= 30) {
            return BusinessType.MEDIUM_PEBBLES;
        }
        if (businessTypeRandom <= 60) {
            return BusinessType.SMALL_PEBBLES;
        }
        return BusinessType.FLOOR_MARKS;
    }

    private int getRandomSeed(WorldPoint worldPoint) {
        String worldPointString = "w" + this.client.getWorld() + "x" + worldPoint.getX() + "y" + worldPoint.getY() + "p" + worldPoint.getPlane();
        return worldPointString.hashCode();
    }

    private void addBusinessInstant(Business business) {
        this.businessSpawnInstants.put(business, Instant.now());
    }

    private void removeOldBusiness() {
        Iterator<Business> i = this.businessSpawnInstants.keySet().iterator();
        while (i.hasNext()) {
            Business currentBusiness = i.next();
            if (!this.isOldBusiness(this.businessSpawnInstants.get(currentBusiness))) continue;
            i.remove();
            this.removeBusiness(currentBusiness);
        }
    }

    private void removeBusiness(Business business) {
        WorldPoint businessLocation = business.getLocation();
        Business cachedBusiness = this.businessLocations.get(businessLocation);
        if (cachedBusiness == null) {
            return;
        }
        if (business != cachedBusiness) {
            return;
        }
        business.setActive(false);
        this.businessLocations.remove(businessLocation);
    }

    private boolean isOldBusiness(Instant spawnInstant) {
        return Duration.between(spawnInstant, Instant.now()).compareTo(this.BUSINESS_DURATION) >= 0;
    }
}

