/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.monkeybusiness;

import com.krazune.monkeybusiness.BusinessType;
import java.time.Duration;
import java.time.Instant;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

public class Business {
    private final Duration MODEL_LOAD_TIMEOUT_DURATION = Duration.ofSeconds(1L);
    private final WorldPoint location;
    private final BusinessType type;
    private final Client client;
    private final ClientThread clientThread;
    private final EventBus eventBus;
    private boolean isActive;
    private RuneLiteObject object;
    private int lastTickPlaneId;

    public Business(Client client, ClientThread clientThread, EventBus eventBus, WorldPoint location, BusinessType type) {
        this.client = client;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.location = location;
        this.type = type;
        this.lastTickPlaneId = client.getPlane();
    }

    public WorldPoint getLocation() {
        return this.location;
    }

    public BusinessType getType() {
        return this.type;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        if (isActive) {
            this.activate();
            return;
        }
        this.deactivate();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.isActive && this.lastTickPlaneId != this.client.getPlane()) {
            this.spawn();
        }
        this.lastTickPlaneId = this.client.getPlane();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOADING: {
                this.despawn();
                break;
            }
            case LOGGED_IN: {
                this.spawn();
            }
        }
    }

    private void activate() {
        this.isActive = true;
        this.spawn();
        this.eventBus.register((Object)this);
    }

    private void deactivate() {
        this.isActive = false;
        this.despawn();
        this.eventBus.unregister((Object)this);
    }

    private void spawn() {
        this.despawn();
        LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.location);
        if (localLocation == null) {
            return;
        }
        RuneLiteObject newObject = this.client.createRuneLiteObject();
        Model newModel = this.client.loadModel(this.type.getValue());
        if (newModel == null) {
            this.repeatingModelLoading(newObject, this.type.getValue());
        } else {
            newObject.setModel(newModel);
        }
        newObject.setLocation(localLocation, this.location.getPlane());
        if (this.client.isClientThread()) {
            newObject.setActive(true);
        } else {
            this.clientThread.invokeLater(() -> newObject.setActive(true));
        }
        this.object = newObject;
    }

    private void despawn() {
        if (this.object == null) {
            return;
        }
        if (this.client.isClientThread()) {
            this.object.setActive(false);
        } else {
            RuneLiteObject objectToBeDisabled = this.object;
            this.clientThread.invokeLater(() -> objectToBeDisabled.setActive(false));
        }
        this.object = null;
    }

    private void repeatingModelLoading(RuneLiteObject object, int modelId) {
        Instant loadTimeoutInstant = Instant.now().plus(this.MODEL_LOAD_TIMEOUT_DURATION);
        this.clientThread.invokeLater(() -> {
            if (Instant.now().isAfter(loadTimeoutInstant)) {
                return true;
            }
            Model newModel = this.client.loadModel(modelId);
            if (newModel == null) {
                return false;
            }
            object.setModel(newModel);
            return true;
        });
    }
}

