/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.view;

import com.ericversteeg.view.RSAnchorType;
import com.ericversteeg.view.RSTextView;
import com.ericversteeg.view.RSView;
import com.ericversteeg.view.RSViewGroup;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;

public class RSViewOverlay
extends Overlay {
    private List<ViewInfo> viewInfo = new ArrayList<ViewInfo>();

    public Dimension render(Graphics2D graphics) {
        long start = Instant.now().toEpochMilli();
        for (ViewInfo info : this.viewInfo) {
            Client client = info.getClient();
            RSViewGroup view = info.getView();
            RSAnchorType anchorType = info.getAnchorType();
            int anchorX = info.getAnchorX();
            int anchorY = info.getAnchorY();
            this.applyFonts(view, graphics);
            view.layout();
            if (anchorType != null) {
                Widget viewportWidget = this.getViewportWidget(client);
                view.setX(anchorX);
                view.setY(anchorY);
                if (anchorType == RSAnchorType.TOP_RIGHT || anchorType == RSAnchorType.BOTTOM_RIGHT) {
                    view.setX(viewportWidget.getCanvasLocation().getX() + viewportWidget.getWidth() + 28 - anchorX - view.getW());
                }
                if (anchorType == RSAnchorType.BOTTOM_LEFT || anchorType == RSAnchorType.BOTTOM_RIGHT) {
                    view.setY(viewportWidget.getCanvasLocation().getY() + viewportWidget.getHeight() + 41 - anchorY - view.getH());
                }
                if (anchorType == RSAnchorType.TOP_CENTER) {
                    view.setX((viewportWidget.getCanvasLocation().getX() + viewportWidget.getWidth() + 28 - view.getW()) / 2 + anchorX);
                }
                if (anchorType == RSAnchorType.LEFT_CENTER) {
                    view.setY((viewportWidget.getCanvasLocation().getY() + viewportWidget.getHeight() + 41 - view.getH()) / 2 + anchorY);
                }
            }
            view.render(graphics, new Point(0, 0));
        }
        return new Dimension(0, 0);
    }

    public void addViewInfo(ViewInfo viewInfo) {
        this.viewInfo.add(viewInfo);
    }

    public void clearViewInfo() {
        this.viewInfo.clear();
    }

    private void applyFonts(RSView view, Graphics2D graphics) {
        if (view instanceof RSViewGroup) {
            for (RSView sView : ((RSViewGroup)view).subviews) {
                this.applyFonts(sView, graphics);
            }
        }
        if (view instanceof RSTextView) {
            ((RSTextView)view).setFontMetrics(graphics);
        }
    }

    private Widget getViewportWidget(Client client) {
        Widget widget = client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = client.getWidget(WidgetInfo.FIXED_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        return client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
    }

    public static class ViewInfo {
        private Client client;
        private RSViewGroup view;
        private RSAnchorType anchorType;
        private int anchorX;
        private int anchorY;

        public ViewInfo(Client client, RSViewGroup view, RSAnchorType anchorType, int anchorX, int anchorY) {
            this.client = client;
            this.view = view;
            this.anchorType = anchorType;
            this.anchorX = anchorX;
            this.anchorY = anchorY;
        }

        public Client getClient() {
            return this.client;
        }

        public RSViewGroup getView() {
            return this.view;
        }

        public RSAnchorType getAnchorType() {
            return this.anchorType;
        }

        public int getAnchorX() {
            return this.anchorX;
        }

        public int getAnchorY() {
            return this.anchorY;
        }
    }
}

