/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.ProximityPromptConfig;
import com.ericversteeg.ProximityPromptOverlay;
import com.ericversteeg.model.Prompt;
import com.ericversteeg.model.config.Location;
import com.ericversteeg.model.config.Sound;
import com.ericversteeg.model.config.TextSize;
import com.ericversteeg.model.config.TimeUnit;
import com.ericversteeg.view.RSAnchorType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import java.awt.Color;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Fun Reminders", description="Create reminders.")
public class ProximityPromptPlugin
extends Plugin {
    @Inject
    private ProximityPromptOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private ProximityPromptConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private Provider<ClientThread> clientThreadProvider;
    List<Prompt> prompts = new ArrayList<Prompt>();
    List<Prompt> activePrompts = new ArrayList<Prompt>();
    List<Prompt> inactivePrompts = new ArrayList<Prompt>();
    LocalDateTime dateTime = LocalDateTime.now(ZoneId.systemDefault());
    long startTime = 0L;
    int regionId = 0;
    int lastRegionId = 0;
    WorldPoint worldPos = new WorldPoint(0, 0, 0);
    List<NPC> npcs = new ArrayList<NPC>();
    List<ChatMessage> chatMessages = new ArrayList<ChatMessage>();
    List<ItemComposition> items = new ArrayList<ItemComposition>();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.prompts = this.getAllPrompts();
        this.activePrompts = this.getActivePrompts(this.prompts);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    ProximityPromptConfig provideConfig(ConfigManager configManager) {
        return (ProximityPromptConfig)configManager.getConfig(ProximityPromptConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged config) {
        if (config.getGroup().equals("proximity_prompt")) {
            int soundId;
            this.prompts = this.getAllPrompts();
            this.activePrompts = this.getActivePrompts(this.prompts);
            if (config.getKey().matches("^.*?Sound$") && (soundId = Sound.valueOf(config.getNewValue()).getId()) > 0) {
                ((ClientThread)this.clientThreadProvider.get()).invoke(() -> this.client.playSoundEffect(soundId, 127));
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Item[] inventoryItems;
        if (this.startTime == 0L) {
            this.startTime = Instant.now().toEpochMilli();
        }
        this.dateTime = LocalDateTime.now(ZoneId.systemDefault());
        this.activePrompts = this.getActivePrompts(this.prompts);
        this.items.clear();
        this.lastRegionId = this.regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        this.worldPos = this.client.getLocalPlayer().getWorldLocation();
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return;
        }
        for (Item item : inventoryItems = itemContainer.getItems()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
            if (this.itemsContainsId(itemComposition.getId())) continue;
            this.items.add(itemComposition);
        }
        List<ItemComposition> equipmentItems = this.getEquipment();
        for (ItemComposition itemComposition : equipmentItems) {
            if (this.itemsContainsId(itemComposition.getId())) continue;
            this.items.add(itemComposition);
        }
    }

    @Subscribe(priority=-1.0f)
    private void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        this.npcs.add(npc);
    }

    @Subscribe(priority=-1.0f)
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.npcs.remove(npc);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        this.chatMessages.add(chatMessage);
    }

    private boolean npcsContainsName(String name) {
        for (NPC npc : this.npcs) {
            if (!name.equals(npc.getName())) continue;
            return true;
        }
        return false;
    }

    private List<Prompt> getAllPrompts() {
        long start = Instant.now().toEpochMilli();
        ArrayList<Prompt> prompts = new ArrayList<Prompt>();
        for (int i = 1; i <= 100; ++i) {
            Prompt prompt = new Prompt();
            prompt.id = i;
            prompt.enable = this.isEnable(i);
            prompt.force = this.isForceShow(i);
            prompt.text = this.getText(i);
            prompt.color = this.getColor(i);
            prompt.duration = this.getDuration(i);
            prompt.cooldown = this.getCooldown(i);
            prompt.timeUnit = this.getTimeUnit(i).getType();
            prompt.notify = this.isNotify(i);
            prompt.location = this.getLocation(i).ordinal();
            prompt.anchorType = this.getPanelAnchorType(i).ordinal();
            prompt.anchorX = this.getPanelAnchorX(i);
            prompt.anchorY = this.getPanelAnchorY(i);
            prompt.width = this.getPanelWidth(i);
            prompt.hasBorder = this.isPanelBorder(i);
            prompt.bgColor = this.getPanelColor(i);
            prompt.textSize = this.getPanelTextSize(i).ordinal();
            prompt.sound = this.getSound(i).ordinal();
            prompt.imageId = this.getImageId(i);
            prompt.imageOffset = this.getImageOffset(i);
            prompt.isOffsetNegative = this.isImageOffsetNegative(i);
            prompt.times = this.getTimes(i);
            prompt.days = this.getDaysOfWeek(i);
            prompt.dates = this.getDates(i);
            prompt.coordinates = this.getCoordinates(i);
            prompt.radius = this.getRadius(i);
            prompt.geoFences = this.getGeofences(i);
            prompt.regionIds = this.getRegionIds(i);
            prompt.npcIds = this.getNpcIds(i);
            prompt.itemIds = this.getItemIds(i);
            prompt.chatPatterns = this.getChatPatterns(i);
            prompts.add(prompt);
        }
        try {
            JsonArray jsonArray = (JsonArray)this.gson.fromJson(this.config.customReminders(), JsonArray.class);
            int i = 1;
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Prompt prompt = new Prompt();
                prompt.id = 100 + i;
                prompt.enable = true;
                if (jsonObject.has("force")) {
                    prompt.force = jsonObject.get("force").getAsBoolean();
                }
                if (jsonObject.has("text")) {
                    prompt.text = jsonObject.get("text").getAsString();
                }
                if (jsonObject.has("color")) {
                    prompt.colorStr = jsonObject.get("color").getAsString();
                    prompt.color = Color.decode(prompt.colorStr);
                }
                if (jsonObject.has("duration")) {
                    prompt.duration = jsonObject.get("duration").getAsInt();
                }
                if (jsonObject.has("cd")) {
                    prompt.cooldown = jsonObject.get("cd").getAsInt();
                }
                if (jsonObject.has("cooldown")) {
                    prompt.cooldown = jsonObject.get("cooldown").getAsInt();
                }
                if (jsonObject.has("unit")) {
                    prompt.timeUnit = jsonObject.get("unit").getAsInt();
                }
                if (jsonObject.has("notify")) {
                    prompt.notify = jsonObject.get("notify").getAsBoolean();
                }
                if (jsonObject.has("location")) {
                    prompt.location = jsonObject.get("location").getAsInt();
                }
                if (jsonObject.has("anchor")) {
                    prompt.anchorType = jsonObject.get("anchor").getAsInt();
                }
                if (jsonObject.has("x")) {
                    prompt.anchorX = jsonObject.get("x").getAsInt();
                }
                if (jsonObject.has("y")) {
                    prompt.anchorY = jsonObject.get("y").getAsInt();
                }
                if (jsonObject.has("width")) {
                    prompt.width = jsonObject.get("width").getAsInt();
                }
                if (jsonObject.has("border")) {
                    prompt.hasBorder = jsonObject.get("border").getAsBoolean();
                }
                if (jsonObject.has("bg")) {
                    prompt.bgColorStr = jsonObject.get("bg").getAsString();
                    prompt.bgColor = Color.decode(prompt.bgColorStr);
                }
                if (jsonObject.has("tsize")) {
                    prompt.textSize = jsonObject.get("tsize").getAsInt();
                }
                if (jsonObject.has("sound")) {
                    prompt.sound = jsonObject.get("sound").getAsInt();
                }
                if (jsonObject.has("image")) {
                    prompt.imageId = jsonObject.get("image").getAsInt();
                }
                if (jsonObject.has("offset")) {
                    prompt.imageOffset = jsonObject.get("offset").getAsInt();
                }
                if (jsonObject.has("noffset")) {
                    prompt.isOffsetNegative = jsonObject.get("noffset").getAsBoolean();
                }
                if (jsonObject.has("coords")) {
                    prompt.coordinates = this.toCsv(jsonObject.get("coords").getAsJsonArray());
                }
                if (jsonObject.has("radius")) {
                    prompt.radius = jsonObject.get("radius").getAsInt();
                }
                if (jsonObject.has("geofences")) {
                    prompt.geoFences = this.toCsv(jsonObject.get("geofences").getAsJsonArray());
                }
                if (jsonObject.has("regions")) {
                    prompt.regionIds = this.toCsv(jsonObject.get("regions").getAsJsonArray());
                }
                if (jsonObject.has("npcs")) {
                    prompt.npcIds = this.toCsv(jsonObject.get("npcs").getAsJsonArray());
                }
                if (jsonObject.has("items")) {
                    prompt.itemIds = this.toCsv(jsonObject.get("items").getAsJsonArray());
                }
                if (jsonObject.has("messages")) {
                    prompt.chatPatterns = this.toCsv(jsonObject.get("messages").getAsJsonArray());
                }
                if (jsonObject.has("times")) {
                    prompt.times = this.toCsv(jsonObject.get("times").getAsJsonArray());
                }
                if (jsonObject.has("days")) {
                    prompt.days = this.toCsv(jsonObject.get("days").getAsJsonArray());
                }
                if (jsonObject.has("dates")) {
                    prompt.dates = this.toCsv(jsonObject.get("dates").getAsJsonArray());
                }
                prompts.add(prompt);
                ++i;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return prompts;
        }
        return prompts;
    }

    private List<Prompt> getActivePrompts(List<Prompt> prompts) {
        long start = Instant.now().toEpochMilli();
        ArrayList<Prompt> activeList = new ArrayList<Prompt>();
        this.activePrompts.addAll(this.inactivePrompts);
        this.inactivePrompts.clear();
        for (Prompt prompt : prompts) {
            if (!prompt.force) continue;
            activeList.add(prompt);
        }
        for (Prompt prompt : prompts) {
            if (!prompt.enable || prompt.force) continue;
            if (!(this.checkTimes(prompt.times) && !this.matchesTimes(prompt.times) || this.checkDaysOfWeek(prompt.days) && !this.matchesDaysOfWeek(prompt.days) || this.checkDates(prompt.dates) && !this.matchesDates(prompt.dates) || this.checkCoordinates(prompt.coordinates) && !this.matchesCoordinates(prompt.coordinates, prompt.radius) || this.checkGeoFences(prompt.geoFences) && !this.matchesGeoFences(prompt.geoFences) || this.checkRegions(prompt.regionIds) && !this.matchesRegions(prompt.regionIds) || this.checkNpcIds(prompt.npcIds) && !this.matchesNpcIds(prompt.npcIds) || this.checkItemIds(prompt.itemIds) && !this.matchesItemIds(prompt.itemIds) || this.checkChatPatterns(prompt.chatPatterns) && !this.matchesChatPatterns(prompt.chatPatterns))) {
                Prompt currentActive = this.currentActivePrompt(prompt.id);
                if (currentActive != null) {
                    prompt.posted = currentActive.posted;
                    prompt.active = currentActive.active;
                } else {
                    prompt.posted = Instant.now().toEpochMilli();
                    prompt.active = true;
                    this.playSound(prompt.sound);
                    if (prompt.notify && prompt.lastNotified <= Instant.now().toEpochMilli() - 30000L) {
                        this.notifier.notify(prompt.text);
                        prompt.lastNotified = Instant.now().toEpochMilli();
                    }
                }
                if (Instant.now().toEpochMilli() >= prompt.posted + prompt.getDurationMillis() + prompt.getCooldownMillis()) {
                    prompt.active = true;
                    prompt.posted = Instant.now().toEpochMilli();
                    if (prompt.cooldown > 0) {
                        this.playSound(prompt.sound);
                    }
                    if (prompt.notify && prompt.lastNotified <= Instant.now().toEpochMilli() - 30000L) {
                        this.notifier.notify(prompt.text);
                        prompt.lastNotified = Instant.now().toEpochMilli();
                    }
                    activeList.add(prompt);
                    continue;
                }
            }
            if (prompt.posted <= 0L || Instant.now().toEpochMilli() >= prompt.posted + prompt.getDurationMillis() + prompt.getCooldownMillis()) continue;
            boolean bl = prompt.active = Instant.now().toEpochMilli() < prompt.posted + prompt.getDurationMillis();
            if (prompt.active) {
                activeList.add(prompt);
                continue;
            }
            this.inactivePrompts.add(prompt);
        }
        this.chatMessages.clear();
        return activeList;
    }

    private Prompt currentActivePrompt(int id) {
        for (Prompt prompt : this.activePrompts) {
            if (prompt.id != id) continue;
            return prompt;
        }
        return null;
    }

    private void playSound(int sound) {
        if (Instant.now().toEpochMilli() - this.startTime < 5000L || sound == 0) {
            return;
        }
        ((ClientThread)this.clientThreadProvider.get()).invoke(() -> this.client.playSoundEffect(Sound.values()[sound].getId(), 127));
    }

    private List<ItemComposition> getEquipment() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return new ArrayList<ItemComposition>();
        }
        Item ring = itemContainer.getItem(EquipmentInventorySlot.RING.getSlotIdx());
        Item ammo = itemContainer.getItem(EquipmentInventorySlot.AMMO.getSlotIdx());
        Player player = this.client.getLocalPlayer();
        int[] ids = player.getPlayerComposition().getEquipmentIds();
        ArrayList<Integer> eIds = new ArrayList<Integer>();
        for (int id : ids) {
            if (id < 512) continue;
            eIds.add(id - 512);
        }
        if (ring != null) {
            eIds.add(ring.getId());
        }
        if (ammo != null) {
            eIds.add(ammo.getId());
        }
        return eIds.stream().map(arg_0 -> ((ItemManager)this.itemManager).getItemComposition(arg_0)).collect(Collectors.toList());
    }

    private boolean itemsContainsId(int id) {
        for (ItemComposition item : this.items) {
            if (id != item.getId()) continue;
            return true;
        }
        return false;
    }

    private String toCsv(JsonArray jsonArray) {
        StringBuilder sb = new StringBuilder();
        for (JsonElement jsonElement : jsonArray) {
            sb.append(jsonElement.getAsString());
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean checkTimes(String times) {
        return !times.isEmpty();
    }

    private boolean matchesTimes(String times) {
        try {
            String[] timeRanges;
            for (String timeRangeStr : timeRanges = times.split(",")) {
                LocalDateTime endDateTime;
                LocalDateTime startDateTime;
                if (!timeRangeStr.contains("-")) {
                    startDateTime = this.toLocalDateTime(timeRangeStr);
                    endDateTime = startDateTime.plusMinutes(30L);
                } else {
                    String[] timeRangeParts = timeRangeStr.split("-");
                    startDateTime = this.toLocalDateTime(timeRangeParts[0]);
                    endDateTime = this.toLocalDateTime(timeRangeParts[1]);
                }
                if (!this.dateTime.isAfter(startDateTime) || !this.dateTime.isBefore(endDateTime)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private LocalDateTime toLocalDateTime(String amPmTime) {
        String[] timeParts = amPmTime.split(":");
        int h = Integer.parseInt(timeParts[0].trim());
        String ma = timeParts[1].toLowerCase().trim();
        int m = Integer.parseInt(ma.replace("am", "").replace("pm", ""));
        String aStr = ma.substring(ma.length() - 2);
        if (aStr.equals("pm")) {
            if (h != 12) {
                h += 12;
            }
        } else if (h == 12) {
            h = 0;
        }
        return LocalDate.now(ZoneId.systemDefault()).atTime(h, m);
    }

    private boolean checkDaysOfWeek(String daysOfWeek) {
        return !daysOfWeek.isEmpty();
    }

    private boolean matchesDaysOfWeek(String daysOfWeekStr) {
        try {
            String[] daysOfWeek;
            for (String dayOfWeek : daysOfWeek = daysOfWeekStr.split(",")) {
                boolean matches;
                String lcDayOfWeek = dayOfWeek.toLowerCase();
                int d = 0;
                if (lcDayOfWeek.startsWith("mo")) {
                    d = 1;
                } else if (lcDayOfWeek.startsWith("tu")) {
                    d = 2;
                } else if (lcDayOfWeek.startsWith("we")) {
                    d = 3;
                } else if (lcDayOfWeek.startsWith("th")) {
                    d = 4;
                } else if (lcDayOfWeek.startsWith("fr")) {
                    d = 5;
                } else if (lcDayOfWeek.startsWith("sa")) {
                    d = 6;
                } else if (lcDayOfWeek.startsWith("su")) {
                    d = 7;
                }
                boolean bl = matches = this.dateTime.get(ChronoField.DAY_OF_WEEK) == d;
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private boolean checkDates(String dates) {
        return !dates.isEmpty();
    }

    private boolean matchesDates(String datesStr) {
        try {
            String[] dateRanges;
            for (String dateRangeOrStr : dateRanges = datesStr.split(",")) {
                LocalDate endLocalDate;
                LocalDate startLocalDate;
                if (dateRangeOrStr.contains("-")) {
                    String[] dateRangeParts = dateRangeOrStr.split("-");
                    startLocalDate = this.toLocalDate(dateRangeParts[0]);
                    endLocalDate = this.toLocalDate(dateRangeParts[1]);
                } else {
                    startLocalDate = this.toLocalDate(dateRangeOrStr);
                    endLocalDate = this.toLocalDate(dateRangeOrStr);
                }
                if (!startLocalDate.atStartOfDay().isBefore(this.dateTime) || !endLocalDate.plusDays(1L).atStartOfDay().isAfter(this.dateTime)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private LocalDate toLocalDate(String dateStr) {
        String[] dateParts = dateStr.split("/");
        int m = Integer.parseInt(dateParts[0].trim());
        int d = Integer.parseInt(dateParts[1].trim());
        if (dateParts.length > 2) {
            int y = Integer.parseInt(dateParts[2].trim());
            return LocalDate.of(y + 2000, m, d);
        }
        return LocalDate.of(this.dateTime.getYear(), m, d);
    }

    private boolean checkCoordinates(String coordinates) {
        return !coordinates.isEmpty();
    }

    private boolean matchesCoordinates(String coordinatesStr, int radius) {
        try {
            String[] coordinates = coordinatesStr.split(",");
            int x = 0;
            for (int i = 0; i < coordinates.length; ++i) {
                boolean matches;
                String xOrY = coordinates[i].replace("(", "").replace(")", "").trim();
                if (i % 2 == 0) {
                    x = Integer.parseInt(xOrY);
                    continue;
                }
                int y = Integer.parseInt(xOrY);
                double distance = Math.sqrt(Math.pow(x - this.worldPos.getX(), 2.0) + Math.pow(y - this.worldPos.getY(), 2.0));
                boolean bl = matches = distance <= (double)radius;
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private boolean checkGeoFences(String geoFences) {
        return !geoFences.isEmpty();
    }

    private boolean matchesGeoFences(String geoFences) {
        try {
            String[] coordinates = geoFences.split(",");
            int left = 0;
            int top = 0;
            int right = 0;
            for (int i = 0; i < coordinates.length; ++i) {
                boolean matches;
                String side = coordinates[i].replace("(", "").replace(")", "").trim();
                if (i % 4 == 0) {
                    left = Integer.parseInt(side);
                    continue;
                }
                if (i % 4 == 1) {
                    top = Integer.parseInt(side);
                    continue;
                }
                if (i % 4 == 2) {
                    right = Integer.parseInt(side);
                    continue;
                }
                int bottom = Integer.parseInt(side);
                boolean bl = matches = this.worldPos.getX() >= left && this.worldPos.getX() <= right && this.worldPos.getY() >= bottom && this.worldPos.getY() <= top;
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private boolean checkRegions(String regionIds) {
        return !regionIds.isEmpty();
    }

    private boolean matchesRegions(String regionIds) {
        try {
            String[] ids;
            for (String idStr : ids = regionIds.split(",")) {
                boolean matches;
                int id = Integer.parseInt(idStr.trim());
                boolean bl = matches = this.regionId == id;
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkNpcIds(String npcIds) {
        return !npcIds.isEmpty();
    }

    private boolean matchesNpcIds(String npcIdsStr) {
        try {
            String[] npcIds;
            for (String npcIdStr : npcIds = npcIdsStr.split(",")) {
                int npcId = Integer.parseInt(npcIdStr.trim());
                boolean matches = false;
                for (NPC npc : this.npcs) {
                    if (npc.getId() != npcId) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkItemIds(String itemIds) {
        return !itemIds.isEmpty();
    }

    private boolean matchesItemIds(String itemIdsStr) {
        try {
            String[] itemIds;
            for (String itemIdStr : itemIds = itemIdsStr.split(",")) {
                int itemId = Integer.parseInt(itemIdStr.trim());
                boolean matches = false;
                for (ItemComposition item : this.items) {
                    if (item.getId() != itemId) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkChatPatterns(String chatPatterns) {
        return !chatPatterns.isEmpty();
    }

    private boolean matchesChatPatterns(String chatPatternsStr) {
        try {
            String[] chatPatterns;
            for (String chatPattern : chatPatterns = chatPatternsStr.split(",")) {
                chatPattern = chatPattern.trim();
                for (ChatMessage chatMessage : this.chatMessages) {
                    Matcher matcher = Pattern.compile(chatPattern).matcher(chatMessage.getMessage());
                    if (!matcher.find()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isEnable(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Enable();
        }
        if (promptId == 2) {
            return this.config.reminder2Enable();
        }
        if (promptId == 3) {
            return this.config.reminder3Enable();
        }
        if (promptId == 4) {
            return this.config.reminder4Enable();
        }
        if (promptId == 5) {
            return this.config.reminder5Enable();
        }
        if (promptId == 6) {
            return this.config.reminder6Enable();
        }
        if (promptId == 7) {
            return this.config.reminder7Enable();
        }
        if (promptId == 8) {
            return this.config.reminder8Enable();
        }
        if (promptId == 9) {
            return this.config.reminder9Enable();
        }
        if (promptId == 10) {
            return this.config.reminder10Enable();
        }
        return false;
    }

    String getText(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Text();
        }
        if (promptId == 2) {
            return this.config.reminder2Text();
        }
        if (promptId == 3) {
            return this.config.reminder3Text();
        }
        if (promptId == 4) {
            return this.config.reminder4Text();
        }
        if (promptId == 5) {
            return this.config.reminder5Text();
        }
        if (promptId == 6) {
            return this.config.reminder6Text();
        }
        if (promptId == 7) {
            return this.config.reminder7Text();
        }
        if (promptId == 8) {
            return this.config.reminder8Text();
        }
        if (promptId == 9) {
            return this.config.reminder9Text();
        }
        if (promptId == 10) {
            return this.config.reminder10Text();
        }
        return "";
    }

    Color getColor(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Color();
        }
        if (promptId == 2) {
            return this.config.reminder2Color();
        }
        if (promptId == 3) {
            return this.config.reminder3Color();
        }
        if (promptId == 4) {
            return this.config.reminder4Color();
        }
        if (promptId == 5) {
            return this.config.reminder5Color();
        }
        if (promptId == 6) {
            return this.config.reminder6Color();
        }
        if (promptId == 7) {
            return this.config.reminder7Color();
        }
        if (promptId == 8) {
            return this.config.reminder8Color();
        }
        if (promptId == 9) {
            return this.config.reminder9Color();
        }
        if (promptId == 10) {
            return this.config.reminder10Color();
        }
        return Color.WHITE;
    }

    int getDuration(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Duration();
        }
        if (promptId == 2) {
            return this.config.reminder2Duration();
        }
        if (promptId == 3) {
            return this.config.reminder3Duration();
        }
        if (promptId == 4) {
            return this.config.reminder4Duration();
        }
        if (promptId == 5) {
            return this.config.reminder5Duration();
        }
        if (promptId == 6) {
            return this.config.reminder6Duration();
        }
        if (promptId == 7) {
            return this.config.reminder7Duration();
        }
        if (promptId == 8) {
            return this.config.reminder8Duration();
        }
        if (promptId == 9) {
            return this.config.reminder9Duration();
        }
        if (promptId == 10) {
            return this.config.reminder10Duration();
        }
        return 0;
    }

    int getCooldown(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Cooldown();
        }
        if (promptId == 2) {
            return this.config.reminder2Cooldown();
        }
        if (promptId == 3) {
            return this.config.reminder3Cooldown();
        }
        if (promptId == 4) {
            return this.config.reminder4Cooldown();
        }
        if (promptId == 5) {
            return this.config.reminder5Cooldown();
        }
        if (promptId == 6) {
            return this.config.reminder6Cooldown();
        }
        if (promptId == 7) {
            return this.config.reminder7Cooldown();
        }
        if (promptId == 8) {
            return this.config.reminder8Cooldown();
        }
        if (promptId == 9) {
            return this.config.reminder9Cooldown();
        }
        if (promptId == 10) {
            return this.config.reminder10Cooldown();
        }
        return 0;
    }

    TimeUnit getTimeUnit(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1TimeUnit();
        }
        if (promptId == 2) {
            return this.config.reminder2TimeUnit();
        }
        if (promptId == 3) {
            return this.config.reminder3TimeUnit();
        }
        if (promptId == 4) {
            return this.config.reminder4TimeUnit();
        }
        if (promptId == 5) {
            return this.config.reminder5TimeUnit();
        }
        if (promptId == 6) {
            return this.config.reminder6TimeUnit();
        }
        if (promptId == 7) {
            return this.config.reminder7TimeUnit();
        }
        if (promptId == 8) {
            return this.config.reminder8TimeUnit();
        }
        if (promptId == 9) {
            return this.config.reminder9TimeUnit();
        }
        if (promptId == 10) {
            return this.config.reminder10TimeUnit();
        }
        return TimeUnit.SECONDS;
    }

    boolean isNotify(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Notify();
        }
        if (promptId == 2) {
            return this.config.reminder2Notify();
        }
        if (promptId == 3) {
            return this.config.reminder3Notify();
        }
        if (promptId == 4) {
            return this.config.reminder4Notify();
        }
        if (promptId == 5) {
            return this.config.reminder5Notify();
        }
        if (promptId == 6) {
            return this.config.reminder6Notify();
        }
        if (promptId == 7) {
            return this.config.reminder7Notify();
        }
        if (promptId == 8) {
            return this.config.reminder8Notify();
        }
        if (promptId == 9) {
            return this.config.reminder9Notify();
        }
        if (promptId == 10) {
            return this.config.reminder10Notify();
        }
        return false;
    }

    String getTimes(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Times();
        }
        if (promptId == 2) {
            return this.config.reminder2Times();
        }
        if (promptId == 3) {
            return this.config.reminder3Times();
        }
        if (promptId == 4) {
            return this.config.reminder4Times();
        }
        if (promptId == 5) {
            return this.config.reminder5Times();
        }
        if (promptId == 6) {
            return this.config.reminder6Times();
        }
        if (promptId == 7) {
            return this.config.reminder7Times();
        }
        if (promptId == 8) {
            return this.config.reminder8Times();
        }
        if (promptId == 9) {
            return this.config.reminder9Times();
        }
        if (promptId == 10) {
            return this.config.reminder10Times();
        }
        return "";
    }

    String getDaysOfWeek(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1DaysOfWeek();
        }
        if (promptId == 2) {
            return this.config.reminder2DaysOfWeek();
        }
        if (promptId == 3) {
            return this.config.reminder3DaysOfWeek();
        }
        if (promptId == 4) {
            return this.config.reminder4DaysOfWeek();
        }
        if (promptId == 5) {
            return this.config.reminder5DaysOfWeek();
        }
        if (promptId == 6) {
            return this.config.reminder6DaysOfWeek();
        }
        if (promptId == 7) {
            return this.config.reminder7DaysOfWeek();
        }
        if (promptId == 8) {
            return this.config.reminder8DaysOfWeek();
        }
        if (promptId == 9) {
            return this.config.reminder9DaysOfWeek();
        }
        if (promptId == 10) {
            return this.config.reminder10DaysOfWeek();
        }
        return "";
    }

    String getDates(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Dates();
        }
        if (promptId == 2) {
            return this.config.reminder2Dates();
        }
        if (promptId == 3) {
            return this.config.reminder3Dates();
        }
        if (promptId == 4) {
            return this.config.reminder4Dates();
        }
        if (promptId == 5) {
            return this.config.reminder5Dates();
        }
        if (promptId == 6) {
            return this.config.reminder6Dates();
        }
        if (promptId == 7) {
            return this.config.reminder7Dates();
        }
        if (promptId == 8) {
            return this.config.reminder8Dates();
        }
        if (promptId == 9) {
            return this.config.reminder9Dates();
        }
        if (promptId == 10) {
            return this.config.reminder10Dates();
        }
        return "";
    }

    String getCoordinates(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Coordinates();
        }
        if (promptId == 2) {
            return this.config.reminder2Coordinates();
        }
        if (promptId == 3) {
            return this.config.reminder3Coordinates();
        }
        if (promptId == 4) {
            return this.config.reminder4Coordinates();
        }
        if (promptId == 5) {
            return this.config.reminder5Coordinates();
        }
        if (promptId == 6) {
            return this.config.reminder6Coordinates();
        }
        if (promptId == 7) {
            return this.config.reminder7Coordinates();
        }
        if (promptId == 8) {
            return this.config.reminder8Coordinates();
        }
        if (promptId == 9) {
            return this.config.reminder9Coordinates();
        }
        if (promptId == 10) {
            return this.config.reminder10Coordinates();
        }
        return "";
    }

    int getRadius(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Radius();
        }
        if (promptId == 2) {
            return this.config.reminder2Radius();
        }
        if (promptId == 3) {
            return this.config.reminder3Radius();
        }
        if (promptId == 4) {
            return this.config.reminder4Radius();
        }
        if (promptId == 5) {
            return this.config.reminder5Radius();
        }
        if (promptId == 6) {
            return this.config.reminder6Radius();
        }
        if (promptId == 7) {
            return this.config.reminder7Radius();
        }
        if (promptId == 8) {
            return this.config.reminder8Radius();
        }
        if (promptId == 9) {
            return this.config.reminder9Radius();
        }
        if (promptId == 10) {
            return this.config.reminder10Radius();
        }
        return 0;
    }

    String getGeofences(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Geofences();
        }
        if (promptId == 2) {
            return this.config.reminder2Geofences();
        }
        if (promptId == 3) {
            return this.config.reminder3Geofences();
        }
        if (promptId == 4) {
            return this.config.reminder4Geofences();
        }
        if (promptId == 5) {
            return this.config.reminder5Geofences();
        }
        if (promptId == 6) {
            return this.config.reminder6Geofences();
        }
        if (promptId == 7) {
            return this.config.reminder7Geofences();
        }
        if (promptId == 8) {
            return this.config.reminder8Geofences();
        }
        if (promptId == 9) {
            return this.config.reminder9Geofences();
        }
        if (promptId == 10) {
            return this.config.reminder10Geofences();
        }
        return "";
    }

    String getRegionIds(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1RegionIds();
        }
        if (promptId == 2) {
            return this.config.reminder2RegionIds();
        }
        if (promptId == 3) {
            return this.config.reminder3RegionIds();
        }
        if (promptId == 4) {
            return this.config.reminder4RegionIds();
        }
        if (promptId == 5) {
            return this.config.reminder5RegionIds();
        }
        if (promptId == 6) {
            return this.config.reminder6RegionIds();
        }
        if (promptId == 7) {
            return this.config.reminder7RegionIds();
        }
        if (promptId == 8) {
            return this.config.reminder8RegionIds();
        }
        if (promptId == 9) {
            return this.config.reminder9RegionIds();
        }
        if (promptId == 10) {
            return this.config.reminder10RegionIds();
        }
        return "";
    }

    String getNpcIds(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1NpcIds();
        }
        if (promptId == 2) {
            return this.config.reminder2NpcIds();
        }
        if (promptId == 3) {
            return this.config.reminder3NpcIds();
        }
        if (promptId == 4) {
            return this.config.reminder4NpcIds();
        }
        if (promptId == 5) {
            return this.config.reminder5NpcIds();
        }
        if (promptId == 6) {
            return this.config.reminder6NpcIds();
        }
        if (promptId == 7) {
            return this.config.reminder7NpcIds();
        }
        if (promptId == 8) {
            return this.config.reminder8NpcIds();
        }
        if (promptId == 9) {
            return this.config.reminder9NpcIds();
        }
        if (promptId == 10) {
            return this.config.reminder10NpcIds();
        }
        return "";
    }

    String getItemIds(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ItemIds();
        }
        if (promptId == 2) {
            return this.config.reminder2ItemIds();
        }
        if (promptId == 3) {
            return this.config.reminder3ItemIds();
        }
        if (promptId == 4) {
            return this.config.reminder4ItemIds();
        }
        if (promptId == 5) {
            return this.config.reminder5ItemIds();
        }
        if (promptId == 6) {
            return this.config.reminder6ItemIds();
        }
        if (promptId == 7) {
            return this.config.reminder7ItemIds();
        }
        if (promptId == 8) {
            return this.config.reminder8ItemIds();
        }
        if (promptId == 9) {
            return this.config.reminder9ItemIds();
        }
        if (promptId == 10) {
            return this.config.reminder10ItemIds();
        }
        return "";
    }

    String getChatPatterns(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ChatPatterns();
        }
        if (promptId == 2) {
            return this.config.reminder2ChatPatterns();
        }
        if (promptId == 3) {
            return this.config.reminder3ChatPatterns();
        }
        if (promptId == 4) {
            return this.config.reminder4ChatPatterns();
        }
        if (promptId == 5) {
            return this.config.reminder5ChatPatterns();
        }
        if (promptId == 6) {
            return this.config.reminder6ChatPatterns();
        }
        if (promptId == 7) {
            return this.config.reminder7ChatPatterns();
        }
        if (promptId == 8) {
            return this.config.reminder8ChatPatterns();
        }
        if (promptId == 9) {
            return this.config.reminder9ChatPatterns();
        }
        if (promptId == 10) {
            return this.config.reminder10ChatPatterns();
        }
        return "";
    }

    Location getLocation(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Location();
        }
        if (promptId == 2) {
            return this.config.reminder2Location();
        }
        if (promptId == 3) {
            return this.config.reminder3Location();
        }
        if (promptId == 4) {
            return this.config.reminder4Location();
        }
        if (promptId == 5) {
            return this.config.reminder5Location();
        }
        if (promptId == 6) {
            return this.config.reminder6Location();
        }
        if (promptId == 7) {
            return this.config.reminder7Location();
        }
        if (promptId == 8) {
            return this.config.reminder8Location();
        }
        if (promptId == 9) {
            return this.config.reminder9Location();
        }
        if (promptId == 10) {
            return this.config.reminder10Location();
        }
        return Location.IN_LIST;
    }

    RSAnchorType getPanelAnchorType(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelAnchorType();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelAnchorType();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelAnchorType();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelAnchorType();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelAnchorType();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelAnchorType();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelAnchorType();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelAnchorType();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelAnchorType();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelAnchorType();
        }
        return RSAnchorType.TOP_LEFT;
    }

    int getPanelAnchorX(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelAnchorX();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelAnchorX();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelAnchorX();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelAnchorX();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelAnchorX();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelAnchorX();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelAnchorX();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelAnchorX();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelAnchorX();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelAnchorX();
        }
        return 0;
    }

    int getPanelAnchorY(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelAnchorY();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelAnchorY();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelAnchorY();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelAnchorY();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelAnchorY();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelAnchorY();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelAnchorY();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelAnchorY();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelAnchorY();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelAnchorY();
        }
        return 0;
    }

    int getImageId(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ImageId();
        }
        if (promptId == 2) {
            return this.config.reminder2ImageId();
        }
        if (promptId == 3) {
            return this.config.reminder3ImageId();
        }
        if (promptId == 4) {
            return this.config.reminder4ImageId();
        }
        if (promptId == 5) {
            return this.config.reminder5ImageId();
        }
        if (promptId == 6) {
            return this.config.reminder6ImageId();
        }
        if (promptId == 7) {
            return this.config.reminder7ImageId();
        }
        if (promptId == 8) {
            return this.config.reminder8ImageId();
        }
        if (promptId == 9) {
            return this.config.reminder9ImageId();
        }
        if (promptId == 10) {
            return this.config.reminder10ImageId();
        }
        return 0;
    }

    int getPanelWidth(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelWidth();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelWidth();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelWidth();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelWidth();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelWidth();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelWidth();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelWidth();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelWidth();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelWidth();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelWidth();
        }
        return 0;
    }

    TextSize getPanelTextSize(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelTextSize();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelTextSize();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelTextSize();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelTextSize();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelTextSize();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelTextSize();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelTextSize();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelTextSize();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelTextSize();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelTextSize();
        }
        return TextSize.SMALL;
    }

    Color getPanelColor(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelColor();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelColor();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelColor();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelColor();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelColor();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelColor();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelColor();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelColor();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelColor();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelColor();
        }
        return Color.WHITE;
    }

    boolean isPanelBorder(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1PanelBorder();
        }
        if (promptId == 2) {
            return this.config.reminder2PanelBorder();
        }
        if (promptId == 3) {
            return this.config.reminder3PanelBorder();
        }
        if (promptId == 4) {
            return this.config.reminder4PanelBorder();
        }
        if (promptId == 5) {
            return this.config.reminder5PanelBorder();
        }
        if (promptId == 6) {
            return this.config.reminder6PanelBorder();
        }
        if (promptId == 7) {
            return this.config.reminder7PanelBorder();
        }
        if (promptId == 8) {
            return this.config.reminder8PanelBorder();
        }
        if (promptId == 9) {
            return this.config.reminder9PanelBorder();
        }
        if (promptId == 10) {
            return this.config.reminder10PanelBorder();
        }
        return false;
    }

    boolean isForceShow(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ForceShow();
        }
        if (promptId == 2) {
            return this.config.reminder2ForceShow();
        }
        if (promptId == 3) {
            return this.config.reminder3ForceShow();
        }
        if (promptId == 4) {
            return this.config.reminder4ForceShow();
        }
        if (promptId == 5) {
            return this.config.reminder5ForceShow();
        }
        if (promptId == 6) {
            return this.config.reminder6ForceShow();
        }
        if (promptId == 7) {
            return this.config.reminder7ForceShow();
        }
        if (promptId == 8) {
            return this.config.reminder8ForceShow();
        }
        if (promptId == 9) {
            return this.config.reminder9ForceShow();
        }
        if (promptId == 10) {
            return this.config.reminder10ForceShow();
        }
        return false;
    }

    int getImageOffset(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ImageOffset();
        }
        if (promptId == 2) {
            return this.config.reminder2ImageOffset();
        }
        if (promptId == 3) {
            return this.config.reminder3ImageOffset();
        }
        if (promptId == 4) {
            return this.config.reminder4ImageOffset();
        }
        if (promptId == 5) {
            return this.config.reminder5ImageOffset();
        }
        if (promptId == 6) {
            return this.config.reminder6ImageOffset();
        }
        if (promptId == 7) {
            return this.config.reminder7ImageOffset();
        }
        if (promptId == 8) {
            return this.config.reminder8ImageOffset();
        }
        if (promptId == 9) {
            return this.config.reminder9ImageOffset();
        }
        if (promptId == 10) {
            return this.config.reminder10ImageOffset();
        }
        return 0;
    }

    boolean isImageOffsetNegative(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1ImageOffsetNegative();
        }
        if (promptId == 2) {
            return this.config.reminder2ImageOffsetNegative();
        }
        if (promptId == 3) {
            return this.config.reminder3ImageOffsetNegative();
        }
        if (promptId == 4) {
            return this.config.reminder4ImageOffsetNegative();
        }
        if (promptId == 5) {
            return this.config.reminder5ImageOffsetNegative();
        }
        if (promptId == 6) {
            return this.config.reminder6ImageOffsetNegative();
        }
        if (promptId == 7) {
            return this.config.reminder7ImageOffsetNegative();
        }
        if (promptId == 8) {
            return this.config.reminder8ImageOffsetNegative();
        }
        if (promptId == 9) {
            return this.config.reminder9ImageOffsetNegative();
        }
        if (promptId == 10) {
            return this.config.reminder10ImageOffsetNegative();
        }
        return false;
    }

    Sound getSound(int promptId) {
        if (promptId == 1) {
            return this.config.reminder1Sound();
        }
        if (promptId == 2) {
            return this.config.reminder2Sound();
        }
        if (promptId == 3) {
            return this.config.reminder3Sound();
        }
        if (promptId == 4) {
            return this.config.reminder4Sound();
        }
        if (promptId == 5) {
            return this.config.reminder5Sound();
        }
        if (promptId == 6) {
            return this.config.reminder6Sound();
        }
        if (promptId == 7) {
            return this.config.reminder7Sound();
        }
        if (promptId == 8) {
            return this.config.reminder8Sound();
        }
        if (promptId == 9) {
            return this.config.reminder9Sound();
        }
        if (promptId == 10) {
            return this.config.reminder10Sound();
        }
        return Sound.NONE;
    }
}

