/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.ProximityPromptConfig;
import com.ericversteeg.ProximityPromptPlugin;
import com.ericversteeg.model.Prompt;
import com.ericversteeg.model.config.Location;
import com.ericversteeg.model.config.TextSize;
import com.ericversteeg.view.RSAnchorType;
import com.ericversteeg.view.RSBox;
import com.ericversteeg.view.RSColumn;
import com.ericversteeg.view.RSImageView;
import com.ericversteeg.view.RSRow;
import com.ericversteeg.view.RSTextView;
import com.ericversteeg.view.RSView;
import com.ericversteeg.view.RSViewGroup;
import com.ericversteeg.view.RSViewOverlay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.NPC;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.util.ImageUtil;

class ProximityPromptOverlay
extends RSViewOverlay {
    private final Client client;
    private final ItemManager itemManager;
    private final ProximityPromptPlugin plugin;
    private final ProximityPromptConfig config;
    private Font font;
    private final Color panelBackgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private final Color outerBorderColor = new Color(57, 41, 13, 124);
    private final Color innerBorderColor = new Color(147, 141, 130, 37);

    @Inject
    private ProximityPromptOverlay(Client client, ItemManager itemManager, ProximityPromptPlugin plugin, ProximityPromptConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            InputStream inRunescapeSmall = FontManager.class.getResourceAsStream("runescape_small.ttf");
            Font smallFont = Font.createFont(0, inRunescapeSmall).deriveFont(0, 12.0f);
            ge.registerFont(smallFont);
            this.font = smallFont;
        }
        catch (Exception e) {
            this.font = FontManager.getRunescapeSmallFont();
        }
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    void updateViews() {
        this.clearViewInfo();
        this.font = this.fontForTextSize(this.config.textSize().ordinal());
        int minWidth = 140;
        if (this.font == FontManager.getRunescapeBoldFont()) {
            minWidth = 160;
        }
        int panelWidth = Math.max(this.config.width(), minWidth);
        RSColumn panel = new RSColumn(10, 120, panelWidth, RSView.WRAP_CONTENT);
        panel.setBgColor(this.panelBackgroundColor);
        panel.addBorder(this.innerBorderColor, this.outerBorderColor);
        panel.setPadding(4);
        List listPrompts = this.plugin.activePrompts.stream().sorted((o1, o2) -> (int)(o2.posted - o1.posted)).filter(obj -> obj.location == Location.IN_LIST.ordinal()).filter(obj -> !obj.text.trim().isEmpty()).collect(Collectors.toList());
        for (Prompt prompt : listPrompts) {
            Object image;
            Color color;
            String text = prompt.text;
            if (text.trim().isEmpty()) continue;
            if (prompt.color != null) {
                color = prompt.color;
            } else {
                try {
                    color = Color.decode(prompt.colorStr);
                }
                catch (Exception exception) {
                    color = Color.WHITE;
                }
            }
            RSRow row = new RSRow(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT);
            if (listPrompts.indexOf(prompt) + 1 < listPrompts.size()) {
                row.setMarginBottom(5);
            }
            RSTextView leftText = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
            leftText.setTextColor(color);
            leftText.setText("\u2022");
            leftText.setMarginEnd(3);
            row.addView(leftText);
            RSTextView rightText = new RSTextView(0, 0, 0, RSView.WRAP_CONTENT, this.font);
            rightText.setTextColor(color);
            rightText.setText(text);
            rightText.setWeight(Float.valueOf(1.0f));
            int imageId = prompt.imageId;
            if (imageId > 0 && (image = this.itemManager.getImage(imageId)) != null) {
                int imageWidth = this.config.textSize() == TextSize.SMALL ? 24 : 32;
                image = ImageUtil.resizeImage((BufferedImage)image, (int)imageWidth, (int)imageWidth, (boolean)true);
                rightText.setImage((BufferedImage)image, imageWidth, imageWidth, RSViewGroup.Gravity.TOP_START);
                rightText.setImageOffset(prompt.imageOffset, prompt.isOffsetNegative);
            }
            row.addView(rightText);
            panel.addView(row);
        }
        List panelPrompts = this.plugin.activePrompts.stream().sorted((o1, o2) -> (int)(o2.posted - o1.posted)).filter(obj -> obj.location != Location.IN_LIST.ordinal()).filter(obj -> !obj.text.trim().isEmpty()).collect(Collectors.toList());
        for (Prompt prompt : panelPrompts) {
            String text = prompt.text;
            if (text.trim().isEmpty()) continue;
            if (prompt.location == Location.WORD_WRAP.ordinal()) {
                this.renderPromptWordWrapPanel(prompt);
                continue;
            }
            if (prompt.location != Location.SINGLE_LINE.ordinal()) continue;
            this.renderPromptSingleLinePanel(prompt);
        }
        if (this.config.idFinder()) {
            this.renderIds(panel);
        } else if (listPrompts.isEmpty()) {
            return;
        }
        this.addViewInfo(new RSViewOverlay.ViewInfo(this.client, panel, this.config.anchorType(), this.config.anchorX(), this.config.anchorY()));
    }

    private void renderPromptWordWrapPanel(Prompt prompt) {
        Object image;
        String text = prompt.text;
        Color color = prompt.color;
        Color panelColor = prompt.bgColor;
        RSRow panel = new RSRow(10, 120, Math.max(prompt.width, 50), RSView.WRAP_CONTENT);
        panel.setBgColor(new Color(panelColor.getRed(), panelColor.getGreen(), panelColor.getBlue(), 156));
        if (prompt.hasBorder) {
            panel.addBorder(panelColor);
        }
        panel.setPadding(4);
        RSTextView textView = new RSTextView(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT, this.fontForTextSize(prompt.textSize));
        textView.setTextColor(color);
        textView.setText(text);
        int imageId = prompt.imageId;
        if (imageId > 0 && (image = this.itemManager.getImage(imageId)) != null) {
            int imageWidth = prompt.textSize == TextSize.SMALL.ordinal() ? 24 : 32;
            image = ImageUtil.resizeImage((BufferedImage)image, (int)imageWidth, (int)imageWidth, (boolean)true);
            textView.setImage((BufferedImage)image, imageWidth, imageWidth, RSViewGroup.Gravity.TOP_START);
            textView.setImageOffset(prompt.imageOffset, prompt.isOffsetNegative);
        }
        panel.addView(textView);
        this.addViewInfo(new RSViewOverlay.ViewInfo(this.client, panel, RSAnchorType.values()[prompt.anchorType], prompt.anchorX, prompt.anchorY));
    }

    private void renderPromptSingleLinePanel(Prompt prompt) {
        Object image;
        String text = prompt.text;
        Color color = prompt.color;
        RSImageView imageView = new RSImageView(RSView.WRAP_CONTENT, RSView.WRAP_CONTENT);
        int imageId = prompt.imageId;
        int imageWidth = 0;
        if (imageId > 0 && (image = this.itemManager.getImage(imageId)) != null) {
            imageWidth = prompt.textSize == TextSize.SMALL.ordinal() ? 24 : 32;
            image = ImageUtil.resizeImage((BufferedImage)image, (int)imageWidth, (int)imageWidth, (boolean)true);
            imageView.setImage((BufferedImage)image);
            imageView.setOffset(prompt.imageOffset, prompt.isOffsetNegative);
        }
        Color panelColor = prompt.bgColor;
        int panelHeight = RSView.WRAP_CONTENT;
        if (imageWidth > 0) {
            panelHeight = imageWidth;
        }
        RSRow panel = new RSRow(10, 120, RSView.WRAP_CONTENT, panelHeight);
        panel.setBgColor(new Color(panelColor.getRed(), panelColor.getGreen(), panelColor.getBlue(), 156));
        if (prompt.hasBorder) {
            panel.addBorder(panelColor);
        }
        panel.setPadding(4);
        panel.addView(imageView);
        RSTextView textView = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.fontForTextSize(prompt.textSize));
        if (imageWidth > 0) {
            textView.setLayoutGravity(RSViewGroup.Gravity.START);
        }
        textView.setTextColor(color);
        textView.setText(text);
        panel.addView(textView);
        this.addViewInfo(new RSViewOverlay.ViewInfo(this.client, panel, RSAnchorType.values()[prompt.anchorType], prompt.anchorX, prompt.anchorY));
    }

    private void renderIds(RSColumn panel) {
        RSRow row;
        RSBox box = new RSBox(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT);
        RSTextView left = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
        left.setTextColor(Color.GREEN);
        left.setText("Location");
        left.setLayoutGravity(RSViewGroup.Gravity.START);
        RSTextView right = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
        right.setText(String.format("(%d, %d)", this.plugin.worldPos.getX(), this.plugin.worldPos.getY()));
        right.setLayoutGravity(RSViewGroup.Gravity.END);
        box.addView(left);
        box.addView(right);
        panel.addView(box);
        box = new RSBox(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT);
        left = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
        left.setTextColor(Color.GREEN);
        left.setText("Region");
        left.setLayoutGravity(RSViewGroup.Gravity.START);
        right = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
        right.setText(String.valueOf(this.plugin.regionId));
        right.setLayoutGravity(RSViewGroup.Gravity.END);
        box.addView(left);
        box.addView(right);
        panel.addView(box);
        ArrayList<Integer> npcIds = new ArrayList<Integer>();
        for (NPC npc : this.plugin.npcs) {
            if (npc.getId() == -1 || npcIds.contains(npc.getId())) continue;
            row = new RSRow(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT);
            left = new RSTextView(0, 0, 0, RSView.WRAP_CONTENT, this.font);
            left.setTextColor(Color.CYAN);
            left.setText(npc.getName());
            left.setWeight(Float.valueOf(1.0f));
            right = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
            right.setText(String.valueOf(npc.getId()));
            right.setMarginStart(10);
            row.addView(left);
            row.addView(right);
            panel.addView(row);
            npcIds.add(npc.getId());
        }
        for (ItemComposition item : this.plugin.items) {
            if (item.getId() == -1) continue;
            row = new RSRow(0, 0, RSView.MATCH_PARENT, RSView.WRAP_CONTENT);
            left = new RSTextView(0, 0, 0, RSView.WRAP_CONTENT, this.font);
            left.setTextColor(Color.YELLOW);
            left.setText(item.getName());
            left.setWeight(Float.valueOf(1.0f));
            right = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.font);
            right.setText(String.valueOf(item.getId()));
            right.setMarginStart(10);
            row.addView(left);
            row.addView(right);
            panel.addView(row);
        }
    }

    private Font fontForTextSize(int textSize) {
        Font font = textSize == TextSize.SMALL.ordinal() ? FontManager.getRunescapeSmallFont() : (textSize == TextSize.LARGE.ordinal() ? FontManager.getRunescapeFont() : FontManager.getRunescapeBoldFont());
        return font;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        this.updateViews();
        return super.render(graphics);
    }
}

