/*
 * Decompiled with CFR 0.152.
 */
package com.combatroll;

import com.combatroll.AttackStyle;
import com.combatroll.CombatRoll;
import com.combatroll.WeaponType;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Combat Roll", description="Player attack and defence roll")
public class CombatRollPlugin
extends Plugin {
    private static final int EQUIPMENT_STATS_BANK_WIDGET_GROUP_ID = 12;
    private static final int EQUIPMENT_STATS_BANK_WIDGET_CHILD_OFFSET = 66;
    private static final int EQUIPMENT_STATS_WIDGET_GROUP_ID = 84;
    private static final int ATTACK_HEADER = 22;
    private static final int ATTACK_STAB = 23;
    private static final int ATTACK_SLASH = 24;
    private static final int ATTACK_CRUSH = 25;
    private static final int ATTACK_MAGIC = 26;
    private static final int ATTACK_RANGED = 27;
    private static final int DEFENCE_HEADER = 28;
    private static final int DEFENCE_STAB = 29;
    private static final int DEFENCE_SLASH = 30;
    private static final int DEFENCE_CRUSH = 31;
    private static final int DEFENCE_MAGIC = 32;
    private static final int DEFENCE_RANGED = 33;
    private static final List<Integer> EQUIPMENT_STATS_WIDGET_CHILD_IDS = Arrays.asList(23, 24, 25, 26, 27, 29, 30, 31, 32, 33);
    private Map<Integer, Integer> combatBonuses = new HashMap<Integer, Integer>();
    private Map<Integer, String> original = new HashMap<Integer, String>();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
        this.clientThread.invokeLater(() -> {
            this.updateInfo(84, 0);
            this.updateInfo(12, 66);
        });
    }

    protected void shutDown() {
        this.updateEquipmentStats(this.client.getWidget(84, 0), 0, true);
        this.updateEquipmentStats(this.client.getWidget(12, 0), 66, true);
        this.setInfo(84, 0, 22, " ", "bonus");
        this.setInfo(84, 0, 28, " ", "bonus");
        this.setInfo(12, 66, 22, " ", "bonus");
        this.setInfo(12, 66, 28, " ", "bonus");
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() == 545 && event.getScriptEvent() != null) {
            Widget widget = event.getScriptEvent().getSource();
            int groupId = WidgetInfo.TO_GROUP((int)widget.getId());
            int childId = WidgetInfo.TO_CHILD((int)widget.getId());
            int indexSlotHelm = 10;
            if (groupId == 84 && childId == indexSlotHelm) {
                this.updateInfo(84, 0);
            } else if (groupId == 12 && childId == indexSlotHelm + 66) {
                this.updateInfo(12, 66);
            }
        }
    }

    private boolean hasEquipment(int ... ids) {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null) {
            for (int id : ids) {
                if (!equipment.contains(id)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateInfo(int widgetId, int offset) {
        Widget equipmentScreen = this.client.getWidget(widgetId, 0);
        if (equipmentScreen == null || equipmentScreen.isHidden()) {
            return;
        }
        this.updateEquipmentStats(equipmentScreen, offset, false);
        this.setInfo(widgetId, offset, 22, " ", "roll");
        this.showRoll(widgetId, offset, 23, this.calculateRoll(this.combatBonuses.getOrDefault(23, 0), CombatRoll.OFFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 24, this.calculateRoll(this.combatBonuses.getOrDefault(24, 0), CombatRoll.OFFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 25, this.calculateRoll(this.combatBonuses.getOrDefault(25, 0), CombatRoll.OFFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 26, this.calculateRoll(this.combatBonuses.getOrDefault(26, 0), CombatRoll.OFFENSIVE_MAGIC));
        this.showRoll(widgetId, offset, 27, this.calculateRoll(this.combatBonuses.getOrDefault(27, 0), CombatRoll.OFFENSIVE_RANGED));
        this.setInfo(widgetId, offset, 28, " ", "roll");
        this.showRoll(widgetId, offset, 29, this.calculateRoll(this.combatBonuses.getOrDefault(29, 0), CombatRoll.DEFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 30, this.calculateRoll(this.combatBonuses.getOrDefault(30, 0), CombatRoll.DEFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 31, this.calculateRoll(this.combatBonuses.getOrDefault(31, 0), CombatRoll.DEFENSIVE_MELEE));
        this.showRoll(widgetId, offset, 32, this.calculateRoll(this.combatBonuses.getOrDefault(32, 0), CombatRoll.DEFENSIVE_MAGIC));
        this.showRoll(widgetId, offset, 33, this.calculateRoll(this.combatBonuses.getOrDefault(33, 0), CombatRoll.DEFENSIVE_RANGED));
    }

    private void setInfo(int widgetId, int offset, int displayIndex, String delim, String roll) {
        Widget widget = this.client.getWidget(widgetId, offset + displayIndex);
        if (widget != null) {
            widget.setText(widget.getText().split(delim)[0] + delim + roll);
        }
    }

    private void showRoll(int widgetId, int offset, int displayIndex, int roll) {
        this.setInfo(widgetId, offset, displayIndex, ": ", Integer.toString(roll));
    }

    private int calculateRoll(int equipmentBonus, CombatRoll rollType) {
        int weaponTypeValue = this.client.getVarbitValue(357);
        int attackStyleValue = this.client.getVarpValue(43) + this.client.getVarbitValue(2668);
        AttackStyle attackStyle = WeaponType.getAttackStyle(weaponTypeValue, attackStyleValue);
        boolean isMagicDefenceRoll = CombatRoll.DEFENSIVE_MAGIC.equals((Object)rollType);
        if (isMagicDefenceRoll) {
            rollType = CombatRoll.DEFENSIVE_MELEE;
        }
        int effectiveLevel = this.getSkillLevel(rollType);
        effectiveLevel = this.applyPrayerBoost(effectiveLevel, rollType);
        effectiveLevel = this.applyStanceBonus(effectiveLevel, rollType, attackStyle);
        effectiveLevel = this.applyAdjustmentConstant(effectiveLevel, isMagicDefenceRoll);
        effectiveLevel = this.applyVoidBoost(effectiveLevel, rollType);
        if (isMagicDefenceRoll) {
            rollType = CombatRoll.DEFENSIVE_MAGIC;
            int effectiveLevelDefence = effectiveLevel * 30 / 100;
            int effectiveLevelMagic = this.getSkillLevel(rollType);
            effectiveLevelMagic = this.applyPrayerBoost(effectiveLevelMagic, rollType);
            effectiveLevelMagic = this.applyStanceBonus(effectiveLevelMagic, rollType, attackStyle);
            effectiveLevelMagic = this.applyAdjustmentConstant(effectiveLevelMagic, isMagicDefenceRoll);
            effectiveLevelMagic = this.applyVoidBoost(effectiveLevelMagic, rollType);
            effectiveLevelMagic = effectiveLevelMagic * 70 / 100;
            effectiveLevel = effectiveLevelDefence + effectiveLevelMagic;
        }
        int roll = effectiveLevel * (equipmentBonus + 64);
        roll = Math.max(this.applySlayerBoost(roll, rollType), this.applySalveBoost(roll, rollType));
        return roll;
    }

    private int getSkillLevel(CombatRoll rollType) {
        Skill skill = null;
        switch (rollType) {
            case OFFENSIVE_MELEE: {
                skill = Skill.ATTACK;
                break;
            }
            case OFFENSIVE_RANGED: {
                skill = Skill.RANGED;
                break;
            }
            case OFFENSIVE_MAGIC: 
            case DEFENSIVE_MAGIC: {
                skill = Skill.MAGIC;
                break;
            }
            case DEFENSIVE_MELEE: 
            case DEFENSIVE_RANGED: {
                skill = Skill.DEFENCE;
            }
        }
        return this.client.getBoostedSkillLevel(skill);
    }

    private int applyPrayerBoost(int level, CombatRoll rollType) {
        int SCALE = 100;
        int boost = 100;
        switch (rollType) {
            case OFFENSIVE_MELEE: {
                boost = this.client.isPrayerActive(Prayer.CLARITY_OF_THOUGHT) ? 105 : boost;
                boost = this.client.isPrayerActive(Prayer.IMPROVED_REFLEXES) ? 110 : boost;
                boost = this.client.isPrayerActive(Prayer.INCREDIBLE_REFLEXES) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.CHIVALRY) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.PIETY) ? 120 : boost;
                break;
            }
            case OFFENSIVE_RANGED: {
                boost = this.client.isPrayerActive(Prayer.SHARP_EYE) ? 105 : boost;
                boost = this.client.isPrayerActive(Prayer.HAWK_EYE) ? 110 : boost;
                boost = this.client.isPrayerActive(Prayer.EAGLE_EYE) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.RIGOUR) ? 120 : boost;
                break;
            }
            case OFFENSIVE_MAGIC: {
                boost = this.client.isPrayerActive(Prayer.MYSTIC_WILL) ? 105 : boost;
                boost = this.client.isPrayerActive(Prayer.MYSTIC_LORE) ? 110 : boost;
                boost = this.client.isPrayerActive(Prayer.MYSTIC_MIGHT) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.AUGURY) ? 125 : boost;
                break;
            }
            case DEFENSIVE_MAGIC: 
            case DEFENSIVE_MELEE: 
            case DEFENSIVE_RANGED: {
                boost = this.client.isPrayerActive(Prayer.MYSTIC_WILL) ? 105 : boost;
                boost = this.client.isPrayerActive(Prayer.MYSTIC_LORE) ? 110 : boost;
                boost = this.client.isPrayerActive(Prayer.MYSTIC_MIGHT) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.THICK_SKIN) ? 105 : boost;
                boost = this.client.isPrayerActive(Prayer.ROCK_SKIN) ? 110 : boost;
                boost = this.client.isPrayerActive(Prayer.STEEL_SKIN) ? 115 : boost;
                boost = this.client.isPrayerActive(Prayer.CHIVALRY) ? 120 : boost;
                boost = this.client.isPrayerActive(Prayer.PIETY) ? 125 : boost;
                boost = this.client.isPrayerActive(Prayer.RIGOUR) ? 125 : boost;
                boost = this.client.isPrayerActive(Prayer.AUGURY) ? 125 : boost;
            }
        }
        return level * boost / 100;
    }

    private int applyStanceBonus(int level, CombatRoll rollType, AttackStyle attackStyle) {
        int bonus = 0;
        switch (rollType) {
            case OFFENSIVE_MELEE: {
                bonus = AttackStyle.ACCURATE.equals((Object)attackStyle) ? 3 : bonus;
                bonus = AttackStyle.CONTROLLED.equals((Object)attackStyle) ? 1 : bonus;
                break;
            }
            case OFFENSIVE_RANGED: {
                bonus = AttackStyle.ACCURATE.equals((Object)attackStyle) ? 3 : bonus;
                bonus = AttackStyle.SHORT_FUSE.equals((Object)attackStyle) ? 3 : bonus;
                break;
            }
            case OFFENSIVE_MAGIC: {
                bonus = AttackStyle.ACCURATE.equals((Object)attackStyle) ? 3 : bonus;
                bonus = AttackStyle.LONGRANGE.equals((Object)attackStyle) ? 1 : bonus;
                break;
            }
            case DEFENSIVE_MELEE: {
                bonus = AttackStyle.CONTROLLED.equals((Object)attackStyle) ? 1 : bonus;
                bonus = AttackStyle.DEFENSIVE.equals((Object)attackStyle) ? 3 : bonus;
                bonus = AttackStyle.LONGRANGE.equals((Object)attackStyle) ? 3 : bonus;
            }
        }
        return level + bonus;
    }

    private int applyAdjustmentConstant(int level, boolean isMagicDefenceRoll) {
        int ADJUSTMENT_CONSTANT = 8;
        if (isMagicDefenceRoll) {
            ADJUSTMENT_CONSTANT = 0;
        }
        return level + ADJUSTMENT_CONSTANT;
    }

    private int applyVoidBoost(int level, CombatRoll rollType) {
        boolean set;
        int SCALE = 100;
        int boost = 100;
        boolean gloves = this.hasEquipment(8842, 24182, 27002, 26467);
        boolean legs = this.hasEquipment(8840, 24179, 27001, 26465);
        boolean eliteLegs = this.hasEquipment(13073, 24180, 27004, 26471);
        boolean body = this.hasEquipment(8839, 24177, 27000, 26463);
        boolean eliteBody = this.hasEquipment(13072, 24178, 27003, 26469);
        boolean helmMelee = this.hasEquipment(11665, 24185, 27007, 26477);
        boolean helmRanged = this.hasEquipment(11664, 24184, 27006, 26475);
        boolean helmMagic = this.hasEquipment(11663, 24183, 27005, 26473);
        boolean bl = set = !(!gloves || !legs && !eliteLegs || !body && !eliteBody || !helmMelee && !helmRanged && !helmMagic);
        if (set) {
            switch (rollType) {
                case OFFENSIVE_MELEE: 
                case OFFENSIVE_RANGED: {
                    boost = helmMelee || helmRanged ? 110 : boost;
                    break;
                }
                case OFFENSIVE_MAGIC: {
                    boost = helmMagic ? 145 : boost;
                }
            }
        }
        return level * boost / 100;
    }

    private int applySlayerBoost(int roll, CombatRoll rollType) {
        int SCALE = 60;
        int boost = 60;
        boolean helm = this.hasEquipment(11864, 19639, 19643, 23073, 21264, 19647, 21888, 24370, 25910, 25898, 25904);
        boolean helmImbued = this.hasEquipment(11865, 25177, 26674, 19641, 25179, 26675, 19645, 25181, 26676, 23075, 25189, 26680, 21266, 25185, 26678, 19649, 25183, 26677, 21890, 25187, 26679, 24444, 25191, 26681, 25912, 25914, 26684, 25900, 25902, 26682, 25906, 25908, 26683);
        boolean mask = this.hasEquipment(8921, 8919, 8917, 8915, 8913, 8911, 8909, 8907, 8905, 8903, 8901);
        boolean maskImbued = this.hasEquipment(11784, 25276, 26781, 11783, 25275, 26780, 11782, 25274, 26779, 11781, 25273, 26778, 11780, 25272, 26777, 11779, 25271, 26776, 11778, 25270, 26775, 11777, 25269, 26774, 11776, 25268, 26773, 11775, 25267, 26772, 11774, 25266, 26771);
        switch (rollType) {
            case OFFENSIVE_MELEE: {
                boost = helm || helmImbued || mask || maskImbued ? 70 : boost;
                break;
            }
            case OFFENSIVE_RANGED: 
            case OFFENSIVE_MAGIC: {
                boost = helmImbued || maskImbued ? 69 : boost;
            }
        }
        return roll * boost / 60;
    }

    private int applySalveBoost(int roll, CombatRoll rollType) {
        int SCALE = 60;
        int boost = 60;
        boolean salve = this.hasEquipment(4081);
        boolean salveI = this.hasEquipment(12017, 25250, 26763);
        boolean salveE = this.hasEquipment(10588);
        boolean salveEI = this.hasEquipment(12018, 25278, 26782);
        switch (rollType) {
            case OFFENSIVE_MELEE: {
                boost = salve || salveI ? 70 : boost;
                boost = salveE || salveEI ? 72 : boost;
                break;
            }
            case OFFENSIVE_RANGED: {
                boost = salveI ? 70 : boost;
                boost = salveEI ? 72 : boost;
                break;
            }
            case OFFENSIVE_MAGIC: {
                boost = salveI ? 69 : boost;
                boost = salveEI ? 72 : boost;
            }
        }
        return roll * boost / 60;
    }

    private void updateEquipmentStats(Widget widget, int offset, boolean reset) {
        if (widget == null) {
            return;
        }
        int id = WidgetInfo.TO_CHILD((int)widget.getId()) - offset;
        String text = widget.getText();
        if (reset && this.original.containsKey(id)) {
            widget.setText(this.original.remove(id));
        } else if (EQUIPMENT_STATS_WIDGET_CHILD_IDS.contains(id) && !Strings.isNullOrEmpty((String)text)) {
            this.parseEquipmentStat(id, text);
            this.original.put(id, text);
        }
        Widget[] children = widget.getStaticChildren();
        if (children != null) {
            for (Widget child : children) {
                this.updateEquipmentStats(child, offset, reset);
            }
        }
    }

    private void parseEquipmentStat(int id, String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        int start = text.indexOf(": ");
        if (start >= 0) {
            try {
                this.combatBonuses.put(id, Integer.parseInt(text.substring(start + 2)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

