/*
 * Decompiled with CFR 0.152.
 */
package com.orbhider;

import com.google.inject.Provides;
import com.orbhider.OrbHiderConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Orb Hider", description="Hides minimap orbs", tags={"orbs", "orb", "minimap", "spec", "hide"})
public class OrbHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OrbHiderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OrbHiderConfig config;

    protected void startUp() throws Exception {
        this.updateAllOrbs();
    }

    protected void shutDown() throws Exception {
        this.showAllOrbs();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 160) {
            this.updateAllOrbs();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.updateAllOrbs();
    }

    @Provides
    OrbHiderConfig provideConfig(ConfigManager configManager) {
        return (OrbHiderConfig)configManager.getConfig(OrbHiderConfig.class);
    }

    public void updateAllOrbs() {
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_XP_ORB), this.config.hideXpOrb());
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB), this.config.hideHealthOrb());
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_PRAYER_ORB), this.config.hidePrayerOrb());
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_RUN_ORB), this.config.hideRunOrb());
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB), this.config.hideSpecOrb());
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_WORLDMAP_ORB), this.config.hideWorldMapOrb());
    }

    public void showAllOrbs() {
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_XP_ORB), false);
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB), false);
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_PRAYER_ORB), false);
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_RUN_ORB), false);
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB), false);
        this.updateOrb(this.client.getWidget(WidgetInfo.MINIMAP_WORLDMAP_ORB), false);
    }

    public void updateOrb(Widget orb, boolean hidden) {
        if (orb != null) {
            orb.setHidden(hidden);
        }
    }
}

