/*
 * Decompiled with CFR 0.152.
 */
package sky.cmAutoSplitter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.PrintWriter;
import java.net.Socket;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import sky.cmAutoSplitter.CoxCMAutoSplitter;
import sky.cmAutoSplitter.CoxCMAutoSplitterConfig;

public class CoxCMAutoSplitterPanel
extends PluginPanel {
    private final Client client;
    private final CoxCMAutoSplitterConfig config;
    private final CoxCMAutoSplitter splitter;
    private PrintWriter writer;
    private Socket socket;
    private JLabel status;

    @Inject
    CoxCMAutoSplitterPanel(Client client, PrintWriter writer, CoxCMAutoSplitterConfig config, CoxCMAutoSplitter splitter) {
        this.client = client;
        this.writer = writer;
        this.config = config;
        this.splitter = splitter;
    }

    private void connect() {
        block3: {
            try {
                this.socket = new Socket("localhost", this.config.port());
                this.splitter.writer = this.writer = new PrintWriter(this.socket.getOutputStream());
                this.set_connected();
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    String message = "Socket started at port <col=ff0000>" + this.config.port() + "</col>.";
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
                }
            }
            catch (Exception e) {
                if (this.client.getGameState() != GameState.LOGGED_IN) break block3;
                String message = "Could not start socket, did you start the LiveSplit server?";
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
            }
        }
    }

    public void disconnect() {
        try {
            this.socket.close();
            this.set_disconnected();
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Socket closed.", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void control(String cmd) {
        try {
            this.writer.write(cmd + "\r\n");
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startPanel() {
        this.getParent().setLayout(new BorderLayout());
        this.getParent().add((Component)((Object)this), "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel layout = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layout, 1);
        layout.setLayout(boxLayout);
        this.add(layout, "North");
        JPanel statusFrame = new JPanel();
        statusFrame.setLayout(new GridBagLayout());
        statusFrame.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.CYAN), "Status"));
        this.status = new JLabel("Not connected");
        this.status.setForeground(Color.RED);
        statusFrame.add(this.status);
        JPanel connectionFrame = new JPanel();
        connectionFrame.setLayout(new GridLayout(2, 1));
        connectionFrame.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.CYAN), "Connection"));
        JButton b_connect = new JButton("Connect");
        JButton b_disconnect = new JButton("Disconnect");
        b_connect.setFocusable(false);
        b_disconnect.setFocusable(false);
        b_connect.addActionListener(e -> this.connect());
        b_disconnect.addActionListener(e -> this.disconnect());
        connectionFrame.add(b_connect);
        connectionFrame.add(b_disconnect);
        JPanel controllerFrame = new JPanel();
        controllerFrame.setLayout(new GridLayout(6, 1));
        controllerFrame.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.CYAN), "LiveSplit Controller"));
        JButton[] controllerButtons = new JButton[]{new JButton("Split"), new JButton("Reset"), new JButton("Undo split"), new JButton("Skip split"), new JButton("Pause"), new JButton("Resume")};
        String[] controls = new String[]{"startorsplit", "reset", "unsplit", "skipsplit", "pause", "resume"};
        for (int i = 0; i < controllerButtons.length; ++i) {
            int finalI = i;
            controllerButtons[i].addActionListener(e -> this.control(controls[finalI]));
            controllerButtons[i].setFocusable(false);
            controllerFrame.add((Component)controllerButtons[i], "Center");
        }
        layout.add(statusFrame);
        layout.add(Box.createRigidArea(new Dimension(0, 15)));
        layout.add(connectionFrame);
        layout.add(Box.createRigidArea(new Dimension(0, 15)));
        layout.add(controllerFrame);
    }

    public void set_connected() {
        this.status.setText("Connected");
        this.status.setForeground(Color.GREEN);
    }

    public void set_disconnected() {
        this.status.setText("Not connected");
        this.status.setForeground(Color.RED);
    }
}

